/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.dialogs.AddParagraphDialog;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.propertysheet.ComboDialogEditor;
import com.iscobol.screenpainter.propertysheet.ElementsProvider;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.ResourceRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ParagraphEditor
extends ComboDialogEditor {
    private String propName;
    private String defName;
    private boolean shouldOpenEventEditor;
    private AbstractBeanControl gridCellEditor;

    public ParagraphEditor(String string, String string2) {
        this(string, string2, null);
    }

    public ParagraphEditor(String string, String string2, AbstractBeanControl abstractBeanControl) {
        this.propName = string;
        this.defName = string2;
        this.gridCellEditor = abstractBeanControl;
    }

    protected Object openDialog(Shell shell) {
        ParagraphType paragraphType = null;
        if (this.combo.getSelectionIndex() <= 0) {
            ScreenPainterModel screenPainterModel;
            String string;
            IscobolScreenPainterEditPart iscobolScreenPainterEditPart = PropertyDescriptorRegistry.getCurrentSelectedEditPart((boolean)false);
            if (this.defName == null && iscobolScreenPainterEditPart != null && (string = (screenPainterModel = iscobolScreenPainterEditPart.getScreenPainterModel()).getName()) != null && string.length() > 0) {
                if (this.gridCellEditor != null) {
                    string = string + "-" + IscobolBeanConstants.getShortTypeName((int)this.gridCellEditor.getType());
                }
                ScreenProgram screenProgram = screenPainterModel.getScreenProgram();
                ResourceRegistry resourceRegistry = screenProgram.getResourceRegistry();
                String string2 = this.defName = IscobolBeanConstants.getDefaultParagraphName((String)string, (String)this.propName, (int)screenProgram.getCase());
                int n = 0;
                while (resourceRegistry.getParagraph(string2) != null) {
                    string2 = this.defName + n;
                    ++n;
                }
                this.defName = string2;
            }
            screenPainterModel = new AddParagraphDialog(shell, this.defName, (ElementsProvider)this);
            paragraphType = screenPainterModel.openDialog();
        } else {
            paragraphType = (ParagraphType)this.getElements()[this.combo.getSelectionIndex() - 1];
        }
        this.shouldOpenEventEditor = true;
        return paragraphType;
    }

    public boolean shouldOpenEventEditor() {
        return this.shouldOpenEventEditor;
    }

    public Object[] getElements() {
        return PropertyDescriptorRegistry.getCurrentScreenProgram().getProgramParagraphs();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.combo.setEditable(true);
        return control;
    }

    protected void commitValue() {
        String string = this.combo.getText().trim();
        if (string.length() == 0) {
            this.setValue(null);
            if (this.vListener != null) {
                this.vListener.valueChanged(this.getValue());
            }
        } else if (PluginUtilities.isValidIdentifier((String)string)) {
            ParagraphType paragraphType = new ParagraphType(string);
            int n = this.getList().indexOf((Comparable)paragraphType);
            if (n >= 0) {
                this.setValue(this.getList().get(n));
            } else {
                this.setValue((Object)paragraphType);
                ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
                EventParagraphsEditor eventParagraphsEditor = screenProgramEditor.getEventParagraphsEditor();
                eventParagraphsEditor.addAndSelectParagraph(screenProgramEditor.getScreenProgram().getEventParagraphs(), paragraphType.getName(), paragraphType.isUserParagraph());
            }
            if (this.vListener != null) {
                this.vListener.valueChanged(this.getValue());
            }
        }
    }
}

