/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.dialogs.AddParagraphDialog;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.propertysheet.ComboDialogCellEditor;
import com.iscobol.screenpainter.propertysheet.ElementsProvider;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ParagraphPropertyEditor
extends ComboDialogCellEditor {
    private String propName;
    private boolean initialized;

    public ParagraphPropertyEditor(Composite composite, String string) {
        super(composite);
        this.propName = string;
        this.initialized = true;
        this.defCombo.removeAll();
        this.fillCombo();
    }

    protected Object doOpenDialogBox(Control control) {
        ScreenPainterModel screenPainterModel;
        IscobolScreenPainterEditPart iscobolScreenPainterEditPart;
        ParagraphType paragraphType = null;
        if (this.defCombo.getSelectionIndex() <= 0) {
            String string;
            iscobolScreenPainterEditPart = PropertyDescriptorRegistry.getCurrentSelectedEditPart((boolean)false);
            String string2 = null;
            if (iscobolScreenPainterEditPart != null && (string = (screenPainterModel = iscobolScreenPainterEditPart.getScreenPainterModel()).getName()) != null && string.length() > 0) {
                string2 = IscobolBeanConstants.getDefaultParagraphName((String)string, (String)this.propName, (int)screenPainterModel.getScreenProgram().getCase());
            }
            string = new AddParagraphDialog(control.getShell(), string2, (ElementsProvider)this);
            paragraphType = string.openDialog();
        } else {
            paragraphType = (ParagraphType)this.getElements()[this.defCombo.getSelectionIndex() - 1];
        }
        if (paragraphType != null) {
            iscobolScreenPainterEditPart = PluginUtilities.getCurrentScreenProgramEditor();
            screenPainterModel = iscobolScreenPainterEditPart.getEventParagraphsEditor();
            iscobolScreenPainterEditPart.activateEventParagraphsEditor();
            screenPainterModel.setFocus();
            screenPainterModel.addAndSelectParagraph(iscobolScreenPainterEditPart.getScreenProgram().getEventParagraphs(), paragraphType.getName(), paragraphType.isUserParagraph());
        }
        return paragraphType;
    }

    protected void fillCombo() {
        if (this.initialized) {
            this.defCombo.removeAll();
            this.getList().clear();
            this.defCombo.add("");
            Object[] objectArray = this.getElements();
            for (int i = 0; i < objectArray.length; ++i) {
                int n = this.getList().add((Comparable)objectArray[i]);
                this.defCombo.add(this.valueToString(objectArray[i]), n + 1);
            }
        }
    }

    public Object[] getElements() {
        return PropertyDescriptorRegistry.getCurrentScreenProgram().getProgramParagraphs();
    }

    protected void updateContents(Object object) {
        super.updateContents(object);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.defCombo.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.defCombo.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        return control;
    }

    private void commitValue() {
        String string = this.defCombo.getText().trim();
        if (string.length() == 0) {
            this.setValue(null);
            this.fireApplyEditorValue();
        } else if (PluginUtilities.isValidIdentifier((String)string)) {
            ParagraphType paragraphType = new ParagraphType(string);
            int n = this.getList().indexOf((Comparable)paragraphType);
            if (n >= 0) {
                this.setValue(this.getList().get(n));
            } else {
                this.setValue((Object)paragraphType);
                ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
                EventParagraphsEditor eventParagraphsEditor = screenProgramEditor.getEventParagraphsEditor();
                eventParagraphsEditor.addAndSelectParagraph(screenProgramEditor.getScreenProgram().getEventParagraphs(), paragraphType.getName(), paragraphType.isUserParagraph());
            }
            this.fireApplyEditorValue();
        }
    }

    protected CCombo createCombo(Composite composite) {
        CCombo cCombo = new CCombo(composite, 0);
        cCombo.setEditable(true);
        return cCombo;
    }

    protected boolean isEditable() {
        return true;
    }

    static /* synthetic */ void access$000(ParagraphPropertyEditor paragraphPropertyEditor) {
        paragraphPropertyEditor.commitValue();
    }
}

