/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.dialogs.AddParagraphDialog;
import com.iscobol.screenpainter.propertysheet.ComboDialogCellEditor;
import com.iscobol.screenpainter.propertysheet.ElementsProvider;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgramProcedurePropertyEditor
extends ComboDialogCellEditor {
    private String propName;

    public ProgramProcedurePropertyEditor(Composite composite, String string) {
        super(composite);
        this.propName = string;
    }

    protected Object doOpenDialogBox(Control control) {
        Object object;
        ParagraphType paragraphType = null;
        ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
        ScreenProgram screenProgram = screenProgramEditor.getScreenProgram();
        if (this.defCombo.getSelectionIndex() <= 0) {
            object = null;
            if (screenProgram != null) {
                object = IscobolBeanConstants.getDefaultParagraphName((String)screenProgram.getProgramName().replace(' ', '_'), (String)this.propName, (int)screenProgram.getCase());
            }
            AddParagraphDialog addParagraphDialog = new AddParagraphDialog(control.getShell(), object, (ElementsProvider)this);
            paragraphType = addParagraphDialog.openDialog();
        } else {
            paragraphType = (ParagraphType)this.getElements()[this.defCombo.getSelectionIndex() - 1];
        }
        if (paragraphType != null) {
            object = paragraphType;
            control.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        return paragraphType;
    }

    public Object[] getElements() {
        ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
        return screenProgramEditor.getScreenProgram().getProgramParagraphs();
    }

    protected void updateContents(Object object) {
        super.updateContents(object);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.defCombo.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.defCombo.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        return control;
    }

    private void commitValue() {
        String string = this.defCombo.getText().trim();
        if (string.length() == 0) {
            this.setValue(null);
            this.fireApplyEditorValue();
        } else if (PluginUtilities.isValidIdentifier((String)string)) {
            ParagraphType paragraphType = new ParagraphType(string);
            int n = this.getList().indexOf((Comparable)paragraphType);
            if (n >= 0) {
                this.setValue(this.getList().get(n));
            } else {
                this.setValue((Object)paragraphType);
                ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
                EventParagraphsEditor eventParagraphsEditor = screenProgramEditor.getEventParagraphsEditor();
                eventParagraphsEditor.addAndSelectParagraph(screenProgramEditor.getScreenProgram().getEventParagraphs(), paragraphType.getName(), paragraphType.isUserParagraph());
            }
            this.fireApplyEditorValue();
        }
    }

    protected CCombo createCombo(Composite composite) {
        CCombo cCombo = new CCombo(composite, 0);
        cCombo.setEditable(true);
        return cCombo;
    }

    protected boolean isEditable() {
        return true;
    }

    static /* synthetic */ void access$000(ProgramProcedurePropertyEditor programProcedurePropertyEditor) {
        programProcedurePropertyEditor.commitValue();
    }
}

