/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.CellEditorValidators;
import com.iscobol.screenpainter.propertysheet.FontPropertyDescriptor;
import com.iscobol.screenpainter.propertysheet.ImagePropertyDescriptor;
import com.iscobol.screenpainter.propertysheet.VariablePropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ResourcePropertySource
implements IPropertySource,
CellEditorValidators {
    protected static final String PROPERTY_FONT = "font name";
    protected static final String PROPERTY_IMAGE = "image file";
    protected static final String PROPERTY_IMAGEHANDLE = "bitmap-handle";
    protected static final String PROPERTY_FONTHANDLE = "font-handle";
    protected static PropertyDescriptor fontDescriptor = new FontPropertyDescriptor((Object)"font name", "font name");
    protected static PropertyDescriptor imageDescriptor = new ImagePropertyDescriptor((Object)"image file", "image file");
    protected static PropertyDescriptor fonthandleDescriptor = new VariablePropertyDescriptor((Object)"font-handle", "font-handle", -1, 26);
    protected static PropertyDescriptor imagehandleDescriptor = new VariablePropertyDescriptor((Object)"bitmap-handle", "bitmap-handle", -1, 44);
    public static final int FONT_TYPE = 1;
    public static final int IMAGE_TYPE = 2;
    private ResourceWithHandleType resource;
    private VariableType handle;
    private PropertyDescriptor[] descs = new PropertyDescriptor[2];

    public ResourcePropertySource(ResourceWithHandleType resourceWithHandleType, VariableType variableType, int n) {
        this.setResource(resourceWithHandleType);
        this.handle = variableType;
        switch (n) {
            case 2: {
                this.descs[0] = imagehandleDescriptor;
                this.descs[1] = imageDescriptor;
                break;
            }
            case 1: {
                this.descs[0] = fonthandleDescriptor;
                this.descs[1] = fontDescriptor;
            }
        }
    }

    public Object getEditableValue() {
        return this;
    }

    void setResource(ResourceWithHandleType resourceWithHandleType) {
        this.resource = resourceWithHandleType != null ? (ResourceWithHandleType)resourceWithHandleType.clone() : null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descs;
    }

    public Object getPropertyValue(Object object) {
        if (object.equals(PROPERTY_FONT) || object.equals(PROPERTY_IMAGE)) {
            return this.resource;
        }
        if (object.equals(PROPERTY_IMAGEHANDLE) || object.equals(PROPERTY_FONTHANDLE)) {
            return this.handle;
        }
        return null;
    }

    public ResourceWithHandleType getResource() {
        return this.resource;
    }

    public VariableType getHandle() {
        return this.handle;
    }

    public boolean isPropertySet(Object object) {
        return true;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
        if (object.equals(PROPERTY_FONT) || object.equals(PROPERTY_IMAGE)) {
            this.setResource((ResourceWithHandleType)object2);
        } else if (object.equals(PROPERTY_IMAGEHANDLE) || object.equals(PROPERTY_FONTHANDLE)) {
            this.handle = object2 instanceof VariableName ? ((VariableName)object2).getVariable() : (VariableType)object2;
            if (this.resource != null) {
                this.resource.setHandle(this.handle);
            }
        }
    }

    public String toString() {
        return this.resource != null ? this.resource.toString() : "";
    }
}

