/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.reportdesigner.beans.ReportGroup;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.beans.types.Repository;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.VariableListener;
import com.iscobol.screenpainter.util.ObjectPropertyCouple;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class ResourceRegistry {
    private final Hashtable ht = new Hashtable();
    private Vector<VariableListener> variableListeners = new Vector();
    private VariableType keyStatus;
    private Repository repository = new Repository();
    private VariableTypeList variableTypeList = new VariableTypeList();
    private TreeMap<String, Vector<ObjectPropertyCouple>> variableNamesMap = new TreeMap(PluginUtilities.ignoreCaseComparator);
    private boolean resetPropertyEnabled = true;

    public ResourceRegistry() {
        TreeMap<FontType, FontType> treeMap = new TreeMap<FontType, FontType>();
        this.ht.put(FontType.class, treeMap);
        this.ht.put(ParagraphType.class, new TreeMap(PluginUtilities.ignoreCaseComparator));
        this.ht.put(ImageType.class, new TreeMap());
        FontType[] fontTypeArray = new FontType[IscobolBeanConstants.STANDARD_FONT_NAMES.length];
        for (int i = 0; i < fontTypeArray.length; ++i) {
            FontType fontType = FontType.getStandardFont((String)IscobolBeanConstants.STANDARD_FONT_NAMES[i]);
            treeMap.put(fontType, fontType);
        }
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public VariableTypeList getVariableTypeList() {
        return this.variableTypeList;
    }

    public void addVariableListener(VariableListener variableListener) {
        this.variableListeners.addElement(variableListener);
    }

    public void removeVariableListener(VariableListener variableListener) {
        this.variableListeners.removeElement(variableListener);
    }

    public void registerFont(FontType fontType) {
        if (!fontType.isStandardFont()) {
            this.registerResource((Object)fontType, (Object)fontType);
        }
    }

    public void registerImage(ImageType imageType) {
        this.registerResource(imageType.getFileName(), (Object)imageType);
    }

    public void registerParagraph(String string, Object object, String string2) {
        TreeMap treeMap = (TreeMap)this.ht.get(ParagraphType.class);
        IscobolBeanConstants.registerParagraph((String)string, (Object)object, (String)string2, (Map)treeMap);
    }

    public void unregisterParagraph(String string, Object object, String string2) {
        TreeMap treeMap = (TreeMap)this.ht.get(ParagraphType.class);
        IscobolBeanConstants.unregisterParagraph((String)string, (Object)object, (String)string2, (Map)treeMap);
    }

    public void registerVariable(VariableType variableType, Object object, String string) {
        if (!variableType.isExtVar() && variableType.getQName().indexOf(40) < 0 && this.variableTypeList.findVariable(variableType.getQName()) == null) {
            this.variableTypeList.addVariable(variableType);
            this.fireVariablesAdded(new VariableType[]{variableType});
        }
        if (object != null) {
            IscobolBeanConstants.registerVariable((String)variableType.getQName(), (Object)object, (String)string, (Map)this.variableNamesMap);
        }
    }

    public void registerResource(String string, Object object) {
        this.registerResource((Object)string.toLowerCase(), object);
    }

    private void registerResource(Object object, Object object2) {
        TreeMap treeMap = (TreeMap)this.ht.get(object2.getClass());
        treeMap.put(object, object2);
    }

    public void unregisterVariable(VariableType variableType, Object object, String string) {
        boolean bl = IscobolBeanConstants.unregisterVariable((String)variableType.getName(), (Object)object, (String)string, (Map)this.variableNamesMap, null);
        if (bl) {
            this.fireVariablesRemoved(new VariableType[]{variableType});
        }
    }

    private void fireVariablesAdded(VariableType[] variableTypeArray) {
        for (VariableListener variableListener : this.variableListeners) {
            variableListener.variablesAdded(variableTypeArray);
        }
    }

    private void fireVariablesRemoved(VariableType[] variableTypeArray) {
        for (VariableListener variableListener : this.variableListeners) {
            variableListener.variablesRemoved(variableTypeArray);
        }
    }

    private boolean fireAssociationToBeRemoved(VariableType variableType, Vector<ObjectPropertyCouple> vector) {
        VariableListener variableListener;
        boolean bl = false;
        Iterator iterator = this.variableListeners.iterator();
        while (iterator.hasNext() && !(bl = (variableListener = (VariableListener)iterator.next()).associationToBeRemoved(variableType, vector))) {
        }
        return bl;
    }

    public void removeVariableAssociations(ResourcesProvider resourcesProvider) {
        Vector vector = new Vector();
        PropertyDescriptorRegistry.unregisterVariables((ResourcesProvider)resourcesProvider, (Map)this.variableNamesMap, vector);
        Vector<VariableType> vector2 = new Vector<VariableType>();
        VariableType[] variableTypeArray = vector.elements();
        while (variableTypeArray.hasMoreElements()) {
            VariableType variableType = this.variableTypeList.findVariable(variableTypeArray.nextElement().toString());
            if (variableType == null) continue;
            vector2.addElement(variableType);
        }
        variableTypeArray = new VariableType[vector2.size()];
        vector2.toArray(variableTypeArray);
        this.fireVariablesRemoved(variableTypeArray);
    }

    public void addVariableAssociations(Object object) {
        PropertyDescriptorRegistry.registerVariables((Object)object, (Map)this.variableNamesMap);
    }

    public void removeVariable(VariableType variableType) {
        this.removeVariable(variableType, true);
    }

    public void removeVariable(VariableType variableType, boolean bl) {
        this.removeVariable(variableType, false, bl);
    }

    private void removeVariable(VariableType variableType, boolean bl, boolean bl2) {
        int n = variableType.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.removeVariable((VariableType)variableType.getChildAt(i), true, bl2);
        }
        if (!variableType.isExtVar()) {
            if (bl) {
                this.variableTypeList.removeVariableFromTable(variableType);
            } else {
                this.variableTypeList.removeVariable(variableType);
            }
        }
        Vector vector = (Vector)this.variableNamesMap.get(variableType.getQName());
        this.variableNamesMap.remove(variableType.getQName());
        if (vector != null && vector.size() > 0 && this.resetPropertyEnabled && bl2 && !this.fireAssociationToBeRemoved(variableType, vector)) {
            for (ObjectPropertyCouple objectPropertyCouple : vector) {
                if (objectPropertyCouple.object == null || objectPropertyCouple.object instanceof ReportGroup || objectPropertyCouple.propName == null) continue;
                PropertyDescriptorRegistry.setProperty((Object)objectPropertyCouple.object, (String)objectPropertyCouple.propName, null, null);
            }
        }
    }

    public Vector<ObjectPropertyCouple> getVariableAssociations(VariableType variableType) {
        return (Vector)this.variableNamesMap.get(variableType.getQName());
    }

    public void changeVariablePicture(String string, String string2) {
        Vector vector = (Vector)this.variableNamesMap.get(string);
        if (vector == null) {
            return;
        }
        for (ObjectPropertyCouple objectPropertyCouple : vector) {
            if (objectPropertyCouple.object == null || objectPropertyCouple.propName == null || !objectPropertyCouple.propName.endsWith(" variable")) continue;
            String string3 = objectPropertyCouple.propName.substring(0, objectPropertyCouple.propName.length() - " variable".length());
            PropertyDescriptorRegistry.changeVariablePicture((Object)objectPropertyCouple.object, (String)string3, (String)string2);
        }
    }

    public void renameVariable(String string, String string2) {
        this.variableTypeList.renameVariable(string, string2);
        Vector vector = (Vector)this.variableNamesMap.get(string);
        this.variableNamesMap.remove(string);
        this.variableNamesMap.put(string2, vector);
        if (vector != null) {
            for (ObjectPropertyCouple objectPropertyCouple : vector) {
                if (objectPropertyCouple.object == null || objectPropertyCouple.propName == null) continue;
                PropertyDescriptorRegistry.setProperty((Object)objectPropertyCouple.object, (String)objectPropertyCouple.propName, (Object)string2, null);
            }
        }
    }

    public void renameParagraph(String string, String string2) {
        TreeMap treeMap = (TreeMap)this.ht.get(ParagraphType.class);
        Vector vector = (Vector)treeMap.get(string);
        treeMap.remove(string);
        treeMap.put(string2, vector);
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ObjectPropertyCouple objectPropertyCouple = (ObjectPropertyCouple)vector.elementAt(i);
                if (objectPropertyCouple.object == null || objectPropertyCouple.propName == null) continue;
                PropertyDescriptorRegistry.setProperty((Object)objectPropertyCouple.object, (String)objectPropertyCouple.propName, (Object)new ParagraphType(string2), null);
            }
        }
    }

    public void removeParagraph(String string) {
        TreeMap treeMap = (TreeMap)this.ht.get(ParagraphType.class);
        Vector vector = (Vector)treeMap.get(string);
        treeMap.remove(string);
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ObjectPropertyCouple objectPropertyCouple = (ObjectPropertyCouple)vector.elementAt(i);
                if (objectPropertyCouple.object == null || objectPropertyCouple.propName == null) continue;
                PropertyDescriptorRegistry.setProperty((Object)objectPropertyCouple.object, (String)objectPropertyCouple.propName, null, null);
            }
        }
    }

    public void registerParagraphs(Object[] objectArray) {
        TreeMap treeMap = (TreeMap)this.ht.get(ParagraphType.class);
        for (int i = 0; i < objectArray.length; ++i) {
            PropertyDescriptorRegistry.registerParagraphs((Object)objectArray[i], (Map)treeMap);
        }
    }

    public FontType[] getFonts() {
        return this.getFonts(false);
    }

    public FontType[] getFonts(boolean bl) {
        TreeMap treeMap = (TreeMap)this.ht.get(FontType.class);
        Vector<FontType> vector = new Vector<FontType>();
        FontType[] fontTypeArray = treeMap.keySet().iterator();
        while (fontTypeArray.hasNext()) {
            FontType fontType = (FontType)treeMap.get(fontTypeArray.next());
            if (bl && fontType.isStandardFont()) continue;
            vector.addElement(fontType);
        }
        fontTypeArray = new FontType[vector.size()];
        vector.toArray(fontTypeArray);
        return fontTypeArray;
    }

    public VariableType[] getVariables(boolean bl) {
        if (bl) {
            return this.variableTypeList.getAllVariables();
        }
        return this.variableTypeList.get01or77Variables();
    }

    public ImageType[] getImages() {
        TreeMap treeMap = (TreeMap)this.ht.get(ImageType.class);
        Vector<ImageType> vector = new Vector<ImageType>();
        ImageType[] imageTypeArray = treeMap.keySet().iterator();
        while (imageTypeArray.hasNext()) {
            ImageType imageType = (ImageType)treeMap.get(imageTypeArray.next());
            vector.addElement(imageType);
        }
        imageTypeArray = new ImageType[vector.size()];
        vector.toArray(imageTypeArray);
        return imageTypeArray;
    }

    public void setVariables(VariableType[] variableTypeArray) {
        this.variableTypeList.setVariables((SettingItem[])variableTypeArray);
    }

    public FontType[] getNotStandardFonts() {
        return this.getFonts(true);
    }

    public ParagraphType getParagraph(String string) {
        TreeMap treeMap = (TreeMap)this.ht.get(ParagraphType.class);
        if (treeMap.containsKey(string)) {
            return new ParagraphType(string);
        }
        return null;
    }

    public void setKeyStatus(VariableType variableType) {
        this.keyStatus = variableType;
    }

    public VariableType getKeyStatus() {
        return this.keyStatus;
    }

    public boolean isResetPropertyEnabled() {
        return this.resetPropertyEnabled;
    }

    public void setResetPropertyEnabled(boolean bl) {
        this.resetPropertyEnabled = bl;
    }
}

