/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.SettingItemList;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.SettingTreeItemList;
import com.iscobol.screenpainter.dialogs.SettingsDialog;
import com.iscobol.screenpainter.model.commands.AddBeanCommand;
import com.iscobol.screenpainter.model.commands.CopyBeanCommand;
import com.iscobol.screenpainter.model.commands.CutBeanCommand;
import com.iscobol.screenpainter.model.commands.DeleteBeanCommand;
import com.iscobol.screenpainter.model.commands.PasteBeanCommand;
import com.iscobol.screenpainter.model.commands.PasteData;
import com.iscobol.screenpainter.preferences.ISPPreferenceInitializer;
import com.iscobol.screenpainter.propertysheet.CellEditorValidators;
import com.iscobol.screenpainter.propertysheet.DirtyStateChangeListener;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.PropertySheetContainer;
import com.iscobol.screenpainter.propertysheet.PropertySheetTable;
import com.iscobol.screenpainter.propertysheet.SettingsContentPane;
import com.iscobol.screenpainter.util.EditableControlWrapper;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SettingsContentPane
extends Composite
implements CellEditorValidators,
PropertySheetContainer,
ISelectionProvider {
    protected SettingItemList valueWorkingCopy;
    protected TreeItem currentItem;
    protected Tree tree;
    protected SashForm splitPane;
    private FormToolkit formToolkit;
    protected PropertySheetTable propertyTable;
    protected ToolItem addItem;
    protected ToolItem removeItem;
    protected ToolItem upItem;
    protected ToolItem downItem;
    protected ToolItem addsubItem;
    private boolean dirty;
    private Label statusBar;
    protected ToolBar toolbar;
    protected SettingsDialog parentDialog;
    private boolean isTree;
    private int heightHint;
    protected int propertyColumnWidth;
    protected int valueColumnWidth;
    protected ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
    private Vector dirtyStateChangeListeners = new Vector();
    protected int[] selIdxs;
    protected String selPropName;
    private List selectionChangedListeners = new LinkedList();
    protected Listener cutListener = new /* Unavailable Anonymous Inner Class!! */;
    protected Listener copyListener = new /* Unavailable Anonymous Inner Class!! */;
    protected Listener pasteListener = new /* Unavailable Anonymous Inner Class!! */;
    protected Listener deleteListener = new /* Unavailable Anonymous Inner Class!! */;
    protected Listener selectAllListener = new /* Unavailable Anonymous Inner Class!! */;
    private SelectionUpdater selectionUpdater = new SelectionUpdater(this, null);
    private CommandStack commandStack;
    private IEditorPart editorPart;

    public SettingsContentPane(Composite composite, SettingsDialog settingsDialog, SettingItemList settingItemList, int n, int n2, int n3) {
        this(composite, settingsDialog, settingItemList, null, 600, n2, n3);
    }

    public SettingsContentPane(Composite composite, SettingsDialog settingsDialog, SettingItemList settingItemList, FormToolkit formToolkit, int n, int n2, int n3) {
        super(composite, 0);
        this.heightHint = n;
        this.propertyColumnWidth = n2;
        this.valueColumnWidth = n3;
        this.init(settingItemList);
        this.setFormToolkit(formToolkit);
        this.setParentDialog(settingsDialog);
    }

    public void setSelection(int[] nArray, String string) {
        this.selIdxs = nArray;
        this.selPropName = string;
        if (this.tree != null) {
            this.select();
        }
    }

    protected void select() {
        if (this.selIdxs != null) {
            TreeItem[] treeItemArray = this.tree.getItems();
            for (int i = 0; i < this.selIdxs.length - 1 && this.selIdxs[i] < treeItemArray.length; ++i) {
                treeItemArray = treeItemArray[this.selIdxs[i]].getItems();
            }
            if (this.selIdxs[this.selIdxs.length - 1] < treeItemArray.length) {
                this.tree.setFocus();
                this.tree.deselectAll();
                TreeItem treeItem = treeItemArray[this.selIdxs[this.selIdxs.length - 1]];
                this.tree.showItem(treeItem);
                this.tree.setSelection(treeItem);
                this.treeSelectionChanged(new TreeItem[]{treeItem});
            }
            this.propertyTable.select(this.selPropName);
        }
    }

    public void addDirtyStateChangeListener(DirtyStateChangeListener dirtyStateChangeListener) {
        this.dirtyStateChangeListeners.addElement(dirtyStateChangeListener);
    }

    public void removeDirtyStateChangeListener(DirtyStateChangeListener dirtyStateChangeListener) {
        this.dirtyStateChangeListeners.removeElement(dirtyStateChangeListener);
    }

    public FormToolkit getFormToolkit() {
        return this.formToolkit;
    }

    public void setFormToolkit(FormToolkit formToolkit) {
        this.formToolkit = formToolkit;
        if (this.propertyTable != null) {
            this.propertyTable.setFormToolkit(formToolkit);
        }
    }

    protected void setTree(boolean bl) {
        this.isTree = bl;
    }

    protected boolean isTree() {
        return this.isTree;
    }

    public boolean setFocus() {
        return this.tree.setFocus();
    }

    protected void init(SettingItemList settingItemList) {
        if (settingItemList != null) {
            this.valueWorkingCopy = settingItemList.Clone();
            this.setTree(this.valueWorkingCopy instanceof SettingTreeItemList);
        }
    }

    public void setParentDialog(SettingsDialog settingsDialog) {
        this.parentDialog = settingsDialog;
    }

    public SettingsDialog getParentDialog() {
        return this.parentDialog;
    }

    public SettingItemList getValueWorkingCopy() {
        return this.valueWorkingCopy;
    }

    protected void createAddButton() {
        this.addItem = new ToolItem(this.toolbar, 8);
        this.addItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/add_item.gif"));
        this.addItem.setToolTipText(ISPBundle.getString((String)"add_item_lbl"));
    }

    protected void createRemoveButton() {
        this.removeItem = new ToolItem(this.toolbar, 8);
        this.removeItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/remove_item.gif"));
        this.removeItem.setToolTipText(ISPBundle.getString((String)"remove_item_lbl"));
    }

    protected void createUpButton() {
        this.upItem = new ToolItem(this.toolbar, 8);
        this.upItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_up.png"));
        this.upItem.setToolTipText(ISPBundle.getString((String)"move_up_lbl"));
    }

    protected void createDownButton() {
        this.downItem = new ToolItem(this.toolbar, 8);
        this.downItem.setToolTipText(ISPBundle.getString((String)"move_down_lbl"));
        this.downItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_down.png"));
    }

    protected void createAddSubButton() {
        this.addsubItem = new ToolItem(this.toolbar, 8);
        this.addsubItem.setToolTipText(ISPBundle.getString((String)"insert_subitem_lbl"));
        this.addsubItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addsubItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/add_subitem.gif"));
    }

    protected void fillToolBar() {
        this.createAddButton();
        this.createRemoveButton();
        this.createUpButton();
        this.createDownButton();
        if (this.isTree) {
            this.createAddSubButton();
        }
    }

    protected void treeSelectionChanged(TreeItem[] treeItemArray) {
        if (treeItemArray.length > 0) {
            this.currentItem = treeItemArray[0];
            Object[] objectArray = new Object[treeItemArray.length];
            for (int i = 0; i < treeItemArray.length; ++i) {
                objectArray[i] = treeItemArray[i].getData();
                this.setItemText(treeItemArray[i], treeItemArray[i].getData());
            }
            this.propertyTable.loadTable(objectArray);
        } else {
            this.propertyTable.loadTable(null);
        }
        if (this.upItem != null) {
            this.upItem.setEnabled(treeItemArray.length == 1);
        }
        if (this.downItem != null) {
            this.downItem.setEnabled(treeItemArray.length == 1);
        }
        if (this.addsubItem != null) {
            this.addsubItem.setEnabled(treeItemArray.length == 1);
        }
    }

    protected boolean canModify() {
        List list = this.getSelectionList();
        for (TreeItem treeItem : list) {
            if (((SettingItem)treeItem.getData()).canModify()) continue;
            return false;
        }
        return true;
    }

    public void refreshPropertyTable() {
        if (this.currentItem != null) {
            this.refreshPropertyTable((SettingItem)this.currentItem.getData(), this.tree.getDisplay());
        }
    }

    protected void refreshPropertyTable(SettingItem settingItem, Display display) {
        display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Command createPasteCommand(TreeItem treeItem) {
        PasteBeanCommand pasteBeanCommand = new PasteBeanCommand();
        pasteBeanCommand.setTreeItem(treeItem);
        pasteBeanCommand.setSettingsContentPane(this);
        return pasteBeanCommand;
    }

    protected Command createAddCommand(TreeItem treeItem, boolean bl, boolean bl2) {
        AddBeanCommand addBeanCommand = new AddBeanCommand(this, treeItem, bl, bl2);
        return addBeanCommand;
    }

    protected Command createAddCommand(TreeItem treeItem) {
        if (treeItem == null) {
            return null;
        }
        AddBeanCommand addBeanCommand = new AddBeanCommand(this, treeItem);
        return addBeanCommand;
    }

    protected Command createDeleteCommand(List<TreeItem> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        TreeItem[] treeItemArray = list.toArray(new TreeItem[list.size()]);
        CompoundCommand compoundCommand = new CompoundCommand("Delete");
        for (int i = 0; i < treeItemArray.length; ++i) {
            compoundCommand.add((Command)new DeleteBeanCommand(this, treeItemArray[i]));
        }
        return compoundCommand;
    }

    protected Command createCopyCommand(List<TreeItem> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        TreeItem[] treeItemArray = list.toArray(new TreeItem[list.size()]);
        CopyBeanCommand copyBeanCommand = new CopyBeanCommand();
        PasteData pasteData = new PasteData();
        for (int i = 0; i < treeItemArray.length; ++i) {
            pasteData.addSettingItem((SettingItem)treeItemArray[i].getData());
        }
        copyBeanCommand.setPasteData(pasteData);
        return copyBeanCommand;
    }

    protected Command createCutCommand(List<TreeItem> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        TreeItem[] treeItemArray = list.toArray(new TreeItem[list.size()]);
        return this.createCutCommand(treeItemArray, new CutBeanCommand());
    }

    protected Command createCutCommand(TreeItem[] treeItemArray, CutBeanCommand cutBeanCommand) {
        PasteData pasteData = new PasteData();
        for (int i = 0; i < treeItemArray.length; ++i) {
            pasteData.addSettingItem((SettingItem)treeItemArray[i].getData());
            DeleteBeanCommand deleteBeanCommand = new DeleteBeanCommand(this, treeItemArray[i]);
            cutBeanCommand.addDeleteCommand((Command)deleteBeanCommand);
        }
        cutBeanCommand.setPasteData(pasteData);
        return cutBeanCommand;
    }

    public CommandStack getCommandStack() {
        if (this.commandStack == null) {
            this.commandStack = new CommandStack();
        }
        return this.commandStack;
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public void setEditorPart(IEditorPart iEditorPart) {
        this.editorPart = iEditorPart;
    }

    public Control createClientArea() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Composite composite = this.createComposite((Composite)this);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.heightHint;
        composite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        this.toolbar = new ToolBar(composite, 8519936);
        this.adapt((Composite)this.toolbar);
        gridData = new GridData(768);
        this.toolbar.setLayoutData((Object)gridData);
        this.fillToolBar();
        this.splitPane = new SashForm(composite, 65792);
        this.adapt((Composite)this.splitPane);
        this.splitPane.SASH_WIDTH = 5;
        gridData = new GridData(1808);
        this.splitPane.setLayoutData((Object)gridData);
        this.tree = this.createTree((Composite)this.splitPane, 2818);
        this.tree.addListener(35, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tree.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.propertyTable = this.createPropertySheetTable(this.splitPane);
        this.splitPane.setWeights(new int[]{40, 60});
        this.statusBar = this.createLabel(composite, "");
        gridData = new GridData(768);
        this.statusBar.setLayoutData((Object)gridData);
        this.statusBar.setForeground(IscobolScreenPainterPlugin.getDefault().getColorProvider().getColor(new RGB(255, 0, 0)));
        this.addItems();
        this.tree.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return composite;
    }

    protected void showContextMenu(int n, int n2) {
        TreeItem treeItem = this.tree.getSelectionCount() > 0 ? this.tree.getSelection()[0] : null;
        Menu menu = new Menu((Decorations)this.tree.getShell(), 8);
        this.fillContextMenu(menu, treeItem);
        menu.setLocation(n, n2);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (this.tree.getDisplay().readAndDispatch()) continue;
            this.tree.getDisplay().sleep();
        }
        menu.dispose();
    }

    protected void fillContextMenu(Menu menu, TreeItem treeItem) {
        MenuItem menuItem;
        MenuItem menuItem2;
        MenuItem menuItem3;
        if (this.tree.getSelectionCount() == 1) {
            menuItem3 = new MenuItem(menu, 8);
            menuItem3.setText("Add Item Before");
            menuItem3.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
            menuItem3.setEnabled(this.tree.getSelectionCount() > 0 && this.canModify());
            menuItem2 = new MenuItem(menu, 8);
            menuItem2.setText("Add Item After");
            menuItem2.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
            menuItem2.setEnabled(this.tree.getSelectionCount() > 0 && this.canModify());
            if (this.isTree) {
                menuItem = new MenuItem(menu, 8);
                menuItem.setText("Add Sub-Item");
                menuItem.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
                menuItem.setEnabled(this.tree.getSelectionCount() > 0 && this.canModify());
            }
        }
        new MenuItem(menu, 2);
        menuItem3 = new MenuItem(menu, 8);
        menuItem3.setText("Cut\tCtrl+X");
        menuItem3.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/cut_edit.gif"));
        menuItem3.addListener(13, this.cutListener);
        menuItem3.setEnabled(this.tree.getSelectionCount() > 0 && this.canModify());
        menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText("Copy\tCtrl+C");
        menuItem2.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/copy_edit.gif"));
        menuItem2.addListener(13, this.copyListener);
        menuItem2.setEnabled(this.tree.getSelectionCount() > 0);
        menuItem = new MenuItem(menu, 8);
        menuItem.setText("Paste\tCtrl+V");
        menuItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/paste_edit.gif"));
        menuItem.addListener(13, this.pasteListener);
        menuItem.setEnabled(this.canModify() && this.canPaste());
        new MenuItem(menu, 2);
        MenuItem menuItem4 = new MenuItem(menu, 8);
        menuItem4.setText("Delete");
        menuItem4.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/delete_edit.gif"));
        menuItem4.addListener(13, this.deleteListener);
        menuItem4.setEnabled(this.tree.getSelectionCount() > 0 && this.canModify());
        MenuItem menuItem5 = new MenuItem(menu, 8);
        menuItem5.setText("Select All\tCtrl+A");
        menuItem5.addListener(13, this.selectAllListener);
    }

    protected boolean canPaste() {
        PasteData pasteData;
        Object object = Clipboard.getDefault().getContents();
        if (object == null || !(object instanceof PasteData) || (pasteData = (PasteData)object).isEmpty()) {
            return false;
        }
        return pasteData.getSettingItems() != null && pasteData.getSettingItems().length != 0 && this.valueWorkingCopy.getType().isAssignableFrom(pasteData.getSettingItems()[0].getClass());
    }

    protected PropertySheetTable createPropertySheetTable(SashForm sashForm) {
        IProject iProject = this.screenProgram != null ? this.screenProgram.getProject() : null;
        PropertySheetTable propertySheetTable = new PropertySheetTable((Composite)sashForm, 0, (PropertySheetContainer)this, this.screenProgram, iProject, this.propertyColumnWidth, this.valueColumnWidth);
        propertySheetTable.setFormToolkit(this.formToolkit);
        return propertySheetTable;
    }

    public TreeItem addSubitem(TreeItem treeItem) {
        this.addSubitem(treeItem, (SettingTreeItem)treeItem.getData());
        return this.currentItem;
    }

    protected SettingItem addSubitem(TreeItem treeItem, SettingTreeItem settingTreeItem) {
        SettingTreeItem settingTreeItem2 = (SettingTreeItem)this.createNew(settingTreeItem);
        settingTreeItem.addChild(settingTreeItem2);
        this.currentItem = new TreeItem(treeItem, 0);
        this.setItemText(this.currentItem, (Object)settingTreeItem2);
        this.currentItem.setData((Object)settingTreeItem2);
        this.tree.setSelection(this.currentItem);
        this.treeSelectionChanged(this.tree.getSelection());
        this.tree.redraw();
        this.setDirty(true);
        return settingTreeItem2;
    }

    protected void setItemText(TreeItem treeItem, Object object) {
        treeItem.setText(object.toString());
    }

    protected SettingItem createNew() {
        SettingItem settingItem = this.valueWorkingCopy.createNew();
        if (settingItem.allowsDefaultValues()) {
            ISPPreferenceInitializer.initialize((Object)settingItem, (String)IscobolBeanConstants.getTypeName((int)settingItem.getType()), (IPreferenceStore)IscobolScreenPainterPlugin.getDefault().getPreferenceStore(), (ScreenProgram)this.screenProgram);
        }
        return settingItem;
    }

    protected SettingItem createNew(SettingTreeItem settingTreeItem) {
        SettingTreeItem settingTreeItem2 = ((SettingTreeItemList)this.valueWorkingCopy).createNew(settingTreeItem);
        if (settingTreeItem2.allowsDefaultValues()) {
            ISPPreferenceInitializer.initialize((Object)settingTreeItem2, (String)IscobolBeanConstants.getTypeName((int)settingTreeItem2.getType()), (IPreferenceStore)IscobolScreenPainterPlugin.getDefault().getPreferenceStore(), (ScreenProgram)this.screenProgram);
        }
        return settingTreeItem2;
    }

    public TreeItem addItem(TreeItem treeItem) {
        this.addItem(treeItem, false, false);
        return this.currentItem;
    }

    public TreeItem addItemBefore(TreeItem treeItem) {
        this.addItem(treeItem, true, false);
        return this.currentItem;
    }

    public TreeItem addItemAfter(TreeItem treeItem) {
        this.addItem(treeItem, false, true);
        return this.currentItem;
    }

    protected int getSettingItemIndex(int n, TreeItem treeItem) {
        return n;
    }

    protected SettingItem addItem(TreeItem treeItem, boolean bl, boolean bl2) {
        SettingItem settingItem;
        if (treeItem != null && treeItem.getParentItem() != null) {
            SettingTreeItem settingTreeItem = (SettingTreeItem)treeItem.getData();
            settingItem = this.createNew(settingTreeItem.getParent());
            int n = -1;
            if (bl) {
                n = treeItem.getParentItem().indexOf(treeItem);
            } else if (bl2 && (n = treeItem.getParentItem().indexOf(treeItem)) >= 0) {
                ++n;
            }
            if (n >= 0 && n < treeItem.getParentItem().getItemCount()) {
                this.currentItem = new TreeItem(treeItem.getParentItem(), 0, n);
                settingTreeItem.getParent().addChild(this.getSettingItemIndex(n, treeItem.getParentItem()), (SettingTreeItem)settingItem);
            } else {
                this.currentItem = new TreeItem(treeItem.getParentItem(), 0);
                settingTreeItem.getParent().addChild((SettingTreeItem)settingItem);
            }
        } else {
            settingItem = this.createNew();
            int n = -1;
            if (bl) {
                n = this.tree.indexOf(treeItem);
            } else if (bl2 && (n = this.tree.indexOf(treeItem)) >= 0) {
                ++n;
            }
            if (n >= 0 && n < this.tree.getItemCount()) {
                this.currentItem = new TreeItem(this.tree, 0, n);
                this.valueWorkingCopy.addSetting(this.getSettingItemIndex(n, null), settingItem);
            } else {
                this.currentItem = new TreeItem(this.tree, 0);
                this.valueWorkingCopy.addSetting(settingItem);
            }
        }
        this.setItemText(this.currentItem, (Object)settingItem);
        this.currentItem.setData((Object)settingItem);
        this.tree.setSelection(this.currentItem);
        this.treeSelectionChanged(this.tree.getSelection());
        this.tree.redraw();
        this.setDirty(true);
        return settingItem;
    }

    protected void removeItems() {
        TreeItem[] treeItemArray = this.tree.getSelection();
        for (int i = 0; i < treeItemArray.length; ++i) {
            this.removeItem(treeItemArray[i]);
        }
        this.tree.redraw();
    }

    public void removeItem(TreeItem treeItem) {
        if (treeItem.isDisposed()) {
            return;
        }
        SettingItem settingItem = (SettingItem)treeItem.getData();
        if (this.isTree) {
            if (treeItem.getParentItem() != null) {
                SettingTreeItem settingTreeItem = (SettingTreeItem)settingItem;
                settingTreeItem.getParent().removeChild(settingTreeItem);
            } else {
                this.valueWorkingCopy.removeSetting(settingItem);
            }
        } else {
            this.valueWorkingCopy.removeSetting(settingItem);
        }
        this.disposeItem(treeItem);
        PropertyDescriptorRegistry.getCurrentScreenProgram().pruneResources((ResourcesProvider)settingItem);
        this.setDirty(true);
    }

    protected void disposeItem(TreeItem treeItem) {
        int n;
        int n2;
        TreeItem treeItem2 = treeItem.getParentItem();
        Object object = treeItem2 != null ? ((n2 = treeItem2.indexOf(treeItem)) > 0 ? treeItem2.getItem(n2 - 1) : treeItem2) : ((n = this.tree.indexOf(treeItem)) > 0 ? this.tree.getItem(n - 1) : (n < this.tree.getItemCount() - 1 ? this.tree.getItem(n + 1) : null));
        treeItem.dispose();
        this.selectionUpdater.newSelItem = object;
        this.getDisplay().timerExec(100, (Runnable)this.selectionUpdater);
    }

    protected void moveItemUp() {
        TreeItem treeItem = this.tree.getSelection()[0];
        TreeItem treeItem2 = this.getPrevious(treeItem);
        this.swap(treeItem, treeItem2);
        this.setDirty(true);
    }

    protected void moveItemDown() {
        TreeItem treeItem = this.tree.getSelection()[0];
        TreeItem treeItem2 = this.getNext(treeItem);
        this.swap(treeItem, treeItem2);
        this.setDirty(true);
    }

    public void setErrorMessage(String string) {
        if (!this.statusBar.isDisposed()) {
            this.statusBar.setText(string != null ? string : "");
        }
    }

    public void valueChanged(Object object, int n, String string, Object object2, Object object3) {
        if (object == null || this.tree.isDisposed()) {
            return;
        }
        TreeItem[] treeItemArray = this.tree.getSelection();
        if (treeItemArray.length == 0) {
            treeItemArray = new TreeItem[]{this.currentItem};
        }
        if (n < treeItemArray.length && treeItemArray[n] != null && !treeItemArray[n].isDisposed()) {
            this.setItemText(treeItemArray[n], object);
        }
    }

    public void paragraphValueChanged(Object object, int n, String string, ParagraphType paragraphType, ParagraphType paragraphType2, boolean bl) {
        if (paragraphType2 != null && bl && n == 0) {
            if (this.parentDialog != null) {
                this.parentDialog.okPressed();
            }
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            EventParagraphsEditor eventParagraphsEditor = screenProgramEditor.getEventParagraphsEditor();
            screenProgramEditor.activateEventParagraphsEditor();
            eventParagraphsEditor.setFocus();
            eventParagraphsEditor.addAndSelectParagraph(this.screenProgram.getEventParagraphs(), paragraphType2.getName(), paragraphType2.isUserParagraph());
        }
    }

    protected final void refresh(TreeItem treeItem, boolean bl) {
        SettingItem settingItem;
        if (!treeItem.isDisposed() && (settingItem = (SettingItem)treeItem.getData()) != null) {
            this.setItemText(treeItem, (Object)settingItem);
        }
        if (bl) {
            TreeItem[] treeItemArray = treeItem.getItems();
            for (int i = 0; i < treeItemArray.length; ++i) {
                this.refresh(treeItemArray[i], bl);
            }
        }
    }

    protected void addItems() {
        if (this.valueWorkingCopy == null) {
            return;
        }
        SettingItem[] settingItemArray = this.valueWorkingCopy.getSettings();
        for (int i = 0; i < settingItemArray.length; ++i) {
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setData((Object)settingItemArray[i]);
            this.setItemText(treeItem, (Object)settingItemArray[i]);
            if (!this.isTree) continue;
            this.addItems(treeItem, ((SettingTreeItem)settingItemArray[i]).getChildren());
        }
    }

    protected void addItems(TreeItem treeItem, SettingTreeItem[] settingTreeItemArray) {
        for (int i = 0; i < settingTreeItemArray.length; ++i) {
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setData((Object)settingTreeItemArray[i]);
            this.setItemText(treeItem2, (Object)settingTreeItemArray[i]);
            if (settingTreeItemArray[i].getChildCount() <= 0) continue;
            this.addItems(treeItem2, settingTreeItemArray[i].getChildren());
        }
    }

    private void swap(TreeItem treeItem, TreeItem treeItem2) {
        if (treeItem2 == null) {
            return;
        }
        SettingItem settingItem = (SettingItem)treeItem.getData();
        SettingItem settingItem2 = (SettingItem)treeItem2.getData();
        if (settingItem instanceof SettingTreeItem) {
            this.swap((SettingTreeItem)settingItem, (SettingTreeItem)settingItem2);
        } else {
            this.swap(settingItem, settingItem2);
        }
        this.setItemText(treeItem, (Object)settingItem2);
        this.setItemText(treeItem2, (Object)settingItem);
        treeItem.setData((Object)settingItem2);
        treeItem2.setData((Object)settingItem);
        this.tree.setSelection(treeItem2);
        this.tree.redraw();
        treeItem.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void swap(SettingItem settingItem, SettingItem settingItem2) {
        int n = this.valueWorkingCopy.indexOf(settingItem);
        int n2 = this.valueWorkingCopy.indexOf(settingItem2);
        this.valueWorkingCopy.setSettingAt(n2, settingItem);
        this.valueWorkingCopy.setSettingAt(n, settingItem2);
    }

    private void swap(SettingTreeItem settingTreeItem, SettingTreeItem settingTreeItem2) {
        SettingTreeItem settingTreeItem3 = settingTreeItem.getParent();
        SettingTreeItem settingTreeItem4 = settingTreeItem2.getParent();
        if (settingTreeItem3 == settingTreeItem2) {
            int n;
            SettingTreeItem[] settingTreeItemArray = settingTreeItem.getChildren();
            SettingTreeItem[] settingTreeItemArray2 = settingTreeItem2.getChildren();
            settingTreeItem.removeAllChildren();
            settingTreeItem2.removeAllChildren();
            for (n = 0; n < settingTreeItemArray.length; ++n) {
                settingTreeItem2.addChild(settingTreeItemArray[n]);
            }
            for (n = 0; n < settingTreeItemArray2.length; ++n) {
                if (settingTreeItemArray2[n] == settingTreeItem) continue;
                settingTreeItem.addChild(settingTreeItemArray2[n]);
            }
            settingTreeItem.addChild(0, settingTreeItem2);
            if (settingTreeItem4 != null) {
                int n2 = settingTreeItem4.indexOf(settingTreeItem2);
                settingTreeItem4.setChildAt(n2, settingTreeItem);
            } else {
                int n3 = this.valueWorkingCopy.indexOf((SettingItem)settingTreeItem2);
                this.valueWorkingCopy.setSettingAt(n3, (SettingItem)settingTreeItem);
            }
        } else if (settingTreeItem4 == settingTreeItem) {
            int n;
            SettingTreeItem[] settingTreeItemArray = settingTreeItem.getChildren();
            SettingTreeItem[] settingTreeItemArray3 = settingTreeItem2.getChildren();
            settingTreeItem.removeAllChildren();
            settingTreeItem2.removeAllChildren();
            for (n = 0; n < settingTreeItemArray.length; ++n) {
                if (settingTreeItem2 == settingTreeItemArray[n]) continue;
                settingTreeItem2.addChild(settingTreeItemArray[n]);
            }
            for (n = 0; n < settingTreeItemArray3.length; ++n) {
                settingTreeItem.addChild(settingTreeItemArray3[n]);
            }
            settingTreeItem2.addChild(0, settingTreeItem);
            if (settingTreeItem3 != null) {
                int n4 = settingTreeItem3.indexOf(settingTreeItem);
                settingTreeItem3.setChildAt(n4, settingTreeItem2);
            } else {
                int n5 = this.valueWorkingCopy.indexOf((SettingItem)settingTreeItem);
                this.valueWorkingCopy.setSettingAt(n5, (SettingItem)settingTreeItem2);
            }
        } else if (settingTreeItem3 != null) {
            int n = settingTreeItem3.indexOf(settingTreeItem);
            if (settingTreeItem3 == settingTreeItem4) {
                int n6 = settingTreeItem3.indexOf(settingTreeItem2);
                settingTreeItem3.setChildAt(n6, settingTreeItem);
                settingTreeItem3.setChildAt(n, settingTreeItem2);
            } else {
                settingTreeItem3.setChildAt(n, settingTreeItem2);
                if (settingTreeItem4 != null) {
                    int n7 = settingTreeItem4.indexOf(settingTreeItem2);
                    settingTreeItem4.setChildAt(n7, settingTreeItem);
                } else {
                    int n8 = this.valueWorkingCopy.indexOf((SettingItem)settingTreeItem2);
                    this.valueWorkingCopy.setSettingAt(n8, (SettingItem)settingTreeItem);
                }
            }
        } else {
            int n = this.valueWorkingCopy.indexOf((SettingItem)settingTreeItem);
            if (settingTreeItem4 == null) {
                int n9 = this.valueWorkingCopy.indexOf((SettingItem)settingTreeItem2);
                this.valueWorkingCopy.setSettingAt(n9, (SettingItem)settingTreeItem);
                this.valueWorkingCopy.setSettingAt(n, (SettingItem)settingTreeItem2);
            } else {
                this.valueWorkingCopy.setSettingAt(n, (SettingItem)settingTreeItem2);
                int n10 = settingTreeItem4.indexOf(settingTreeItem2);
                settingTreeItem4.setChildAt(n10, settingTreeItem);
            }
        }
    }

    protected TreeItem getPrevious(TreeItem treeItem) {
        if (treeItem.getParentItem() != null) {
            int n = treeItem.getParentItem().indexOf(treeItem);
            if (n > 0) {
                return this.getLast(treeItem.getParentItem().getItem(n - 1));
            }
            return treeItem.getParentItem();
        }
        int n = this.tree.indexOf(treeItem);
        if (n > 0) {
            return this.getLast(this.tree.getItem(n - 1));
        }
        return null;
    }

    protected TreeItem getLast(TreeItem treeItem) {
        if (treeItem.getItemCount() == 0) {
            return treeItem;
        }
        return this.getLast(treeItem.getItem(treeItem.getItemCount() - 1));
    }

    protected TreeItem getNext(TreeItem treeItem) {
        return this.getNext(treeItem, false);
    }

    protected TreeItem getNext(TreeItem treeItem, boolean bl) {
        if (treeItem.getItemCount() > 0 && !bl) {
            return treeItem.getItem(0);
        }
        if (treeItem.getParentItem() != null) {
            int n = treeItem.getParentItem().indexOf(treeItem);
            if (n < treeItem.getParentItem().getItemCount() - 1) {
                return treeItem.getParentItem().getItem(n + 1);
            }
            return this.getNext(treeItem.getParentItem(), true);
        }
        int n = this.tree.indexOf(treeItem);
        if (n < this.tree.getItemCount() - 1) {
            return this.tree.getItem(n + 1);
        }
        return null;
    }

    protected void expandAll() {
        TreeItem[] treeItemArray = this.tree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            this.expandAll(treeItemArray[i]);
        }
    }

    protected void expandAll(TreeItem treeItem) {
        treeItem.setExpanded(true);
        TreeItem[] treeItemArray = treeItem.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            this.expandAll(treeItemArray[i]);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.fireDirtyStateChange();
    }

    private void fireDirtyStateChange() {
        int n = this.dirtyStateChangeListeners.size();
        for (int i = 0; i < n; ++i) {
            ((DirtyStateChangeListener)this.dirtyStateChangeListeners.elementAt(i)).dirtyStateChange(this.dirty);
        }
    }

    Label createLabel(Composite composite, String string) {
        if (this.formToolkit != null) {
            return this.formToolkit.createLabel(composite, string);
        }
        Label label = new Label(composite, 0);
        label.setText(string);
        return label;
    }

    Composite createComposite(Composite composite) {
        if (this.formToolkit != null) {
            return this.formToolkit.createComposite(composite);
        }
        return new Composite(composite, 0);
    }

    protected Tree createTree(Composite composite, int n) {
        if (this.formToolkit != null) {
            return this.formToolkit.createTree(composite, n);
        }
        return new Tree(composite, n);
    }

    void adapt(Composite composite) {
        if (this.formToolkit != null) {
            this.formToolkit.adapt(composite);
        }
    }

    private void fireSelectionChangedEvent() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Iterator iterator = this.selectionChangedListeners.iterator();
        while (iterator.hasNext()) {
            ((ISelectionChangedListener)iterator.next()).selectionChanged(selectionChangedEvent);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (!this.selectionChangedListeners.contains(iSelectionChangedListener)) {
            this.selectionChangedListeners.add(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        if (this.tree.isFocusControl()) {
            return new StructuredSelection(this.getSelectionList());
        }
        Control control = this.tree.getDisplay().getFocusControl();
        if (EditableControlWrapper.isEditableControl((Control)control)) {
            return new StructuredSelection((Object)EditableControlWrapper.getInstance((Control)control));
        }
        return new StructuredSelection();
    }

    List<TreeItem> getSelectionList() {
        TreeItem[] treeItemArray = this.tree.getSelection();
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        for (int i = 0; i < treeItemArray.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < treeItemArray.length && bl; ++j) {
                if (i == j) continue;
                bl &= !this.isDescendant(treeItemArray[i], treeItemArray[j]);
            }
            if (!bl) continue;
            arrayList.add(treeItemArray[i]);
        }
        return arrayList;
    }

    boolean isDescendant(TreeItem treeItem, TreeItem treeItem2) {
        for (TreeItem treeItem3 = treeItem.getParentItem(); treeItem3 != null; treeItem3 = treeItem3.getParentItem()) {
            if (treeItem3 != treeItem2) continue;
            return true;
        }
        return false;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
    }

    public void selectAll() {
        this.tree.selectAll();
    }

    public SettingItem cut(TreeItem treeItem, int[] nArray) {
        SettingItem settingItem = (SettingItem)treeItem.getData();
        if (nArray != null && nArray.length > 0) {
            SettingTreeItem settingTreeItem;
            nArray[0] = settingItem instanceof SettingTreeItem && (settingTreeItem = ((SettingTreeItem)settingItem).getParent()) != null ? settingTreeItem.indexOf((SettingTreeItem)settingItem) : this.valueWorkingCopy.indexOf(settingItem);
        }
        this.removeItem(treeItem);
        return settingItem;
    }

    public TreeItem undoCut(SettingItem settingItem, TreeItem treeItem, int n) {
        TreeItem treeItem2;
        SettingItemList settingItemList = this.valueWorkingCopy;
        SettingTreeItem settingTreeItem = treeItem != null ? (SettingTreeItem)treeItem.getData() : null;
        SettingItem settingItem2 = settingItem;
        if (settingTreeItem != null) {
            treeItem2 = n < treeItem.getItemCount() ? new TreeItem(treeItem, 0, n) : new TreeItem(treeItem, 0);
            settingTreeItem.addChild(n, (SettingTreeItem)settingItem2);
        } else {
            treeItem2 = n < this.tree.getItemCount() ? new TreeItem(this.tree, 0, n) : new TreeItem(this.tree, 0);
            settingItemList.addSetting(n, settingItem2);
        }
        this.setItemText(treeItem2, (Object)settingItem2);
        treeItem2.setData((Object)settingItem2);
        if (this.isTree) {
            this.undoCutChildren((SettingTreeItem)settingItem2, ((SettingTreeItem)settingItem2).getChildren(), treeItem2);
        }
        this.tree.redraw();
        this.setDirty(true);
        return treeItem2;
    }

    private void undoCutChildren(SettingTreeItem settingTreeItem, SettingTreeItem[] settingTreeItemArray, TreeItem treeItem) {
        for (int i = 0; i < settingTreeItemArray.length; ++i) {
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            this.setItemText(treeItem2, (Object)settingTreeItemArray[i]);
            treeItem2.setData((Object)settingTreeItemArray[i]);
            this.pasteChildren(settingTreeItemArray[i], settingTreeItemArray[i].getChildren(), treeItem2);
        }
    }

    public TreeItem paste(SettingItem settingItem, TreeItem treeItem, int n) {
        TreeItem treeItem2;
        SettingItemList settingItemList = this.valueWorkingCopy;
        SettingTreeItem settingTreeItem = treeItem != null ? (SettingTreeItem)treeItem.getData() : null;
        SettingItem settingItem2 = settingItem;
        SettingItem settingItem3 = PropertyDescriptorRegistry.cloneSettingItem((SettingItem)settingItem2);
        if (settingTreeItem != null) {
            if (n < treeItem.getItemCount()) {
                treeItem2 = new TreeItem(treeItem, 0, n);
                settingTreeItem.addChild(n, (SettingTreeItem)settingItem3);
            } else {
                treeItem2 = new TreeItem(treeItem, 0);
                settingTreeItem.addChild((SettingTreeItem)settingItem3);
            }
        } else if (n < this.tree.getItemCount()) {
            treeItem2 = new TreeItem(this.tree, 0, n);
            settingItemList.addSetting(n, settingItem3);
        } else {
            treeItem2 = new TreeItem(this.tree, 0);
            settingItemList.addSetting(settingItem3);
        }
        this.setItemText(treeItem2, (Object)settingItem3);
        treeItem2.setData((Object)settingItem3);
        if (this.isTree) {
            this.pasteChildren((SettingTreeItem)settingItem3, ((SettingTreeItem)settingItem3).getChildren(), treeItem2);
        }
        this.tree.redraw();
        this.setDirty(true);
        return treeItem2;
    }

    private void pasteChildren(SettingTreeItem settingTreeItem, SettingTreeItem[] settingTreeItemArray, TreeItem treeItem) {
        settingTreeItem.removeAllChildren();
        for (int i = 0; i < settingTreeItemArray.length; ++i) {
            SettingTreeItem settingTreeItem2 = (SettingTreeItem)PropertyDescriptorRegistry.cloneBean((Object)settingTreeItemArray[i]);
            settingTreeItem.addChild(settingTreeItem2);
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            this.setItemText(treeItem2, (Object)settingTreeItem2);
            treeItem2.setData((Object)settingTreeItem2);
            this.pasteChildren(settingTreeItem2, settingTreeItemArray[i].getChildren(), treeItem2);
        }
    }

    protected void deleteItems() {
        Command command = this.createDeleteCommand(this.getSelectionList());
        if (command != null && command.canExecute()) {
            this.getCommandStack().execute(command);
        }
    }

    protected void cutItems() {
        Command command = this.createCutCommand(this.getSelectionList());
        if (command != null && command.canExecute()) {
            this.getCommandStack().execute(command);
        }
    }

    protected void copyItems() {
        Command command = this.createCopyCommand(this.getSelectionList());
        if (command != null && command.canExecute()) {
            this.getCommandStack().execute(command);
        }
    }

    protected void pasteItems() {
        List list = this.getSelectionList();
        Command command = this.createPasteCommand(list.isEmpty() ? null : (TreeItem)list.get(0));
        if (command != null && command.canExecute()) {
            this.getCommandStack().execute(command);
        }
    }

    static /* synthetic */ boolean access$100(SettingsContentPane settingsContentPane) {
        return settingsContentPane.isTree;
    }

    static /* synthetic */ void access$200(SettingsContentPane settingsContentPane) {
        settingsContentPane.fireSelectionChangedEvent();
    }

    static /* synthetic */ IEditorPart access$300(SettingsContentPane settingsContentPane) {
        return settingsContentPane.editorPart;
    }
}

