/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.propertysheet.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextEditor
extends CellEditor {
    protected Text text;
    private boolean numeric;

    public TextEditor() {
        this(false);
    }

    public TextEditor(boolean bl) {
        this.numeric = bl;
    }

    protected void intCreateEditor(Composite composite) {
        this.text = new Text(composite, 0);
        this.text.setBackground(composite.getBackground());
        this.setEditable(this.editable);
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (this.text != null) {
            this.text.setEditable(bl);
        }
    }

    public Control getEditor() {
        return this.text;
    }

    public void addListener(int n, Listener listener) {
        this.text.addListener(n, listener);
    }

    public Object getValue() {
        String string = this.text.getText();
        if (this.numeric && string.trim().length() == 0) {
            string = "0";
        }
        return string;
    }

    public void doSetValue(Object object) {
        if (this.numeric && (object == null || object.toString().trim().length() == 0)) {
            object = "0";
        }
        if (object == null) {
            this.text.setText("");
        } else {
            this.text.setText(object.toString());
        }
    }

    public void dispose() {
        this.vListener = null;
        this.text.dispose();
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public String valueToString(Object object) {
        if (this.numeric) {
            return object == null || object.toString().trim().length() == 0 ? "0" : object.toString();
        }
        return object == null ? "" : object.toString();
    }
}

