/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.util.BeanReader;
import com.iscobol.screenpainter.util.BeanWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class UIFontManager {
    private List<FontType> installedFonts = new ArrayList();
    private static UIFontManager instance;

    public static UIFontManager getInstance() {
        if (instance == null) {
            instance = new UIFontManager();
        }
        return instance;
    }

    private UIFontManager() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        try (BeanReader beanReader = null;){
            beanReader = new BeanReader((InputStream)new FileInputStream(this.getFontFile()));
            FontType[] fontTypeArray = (FontType[])beanReader.readObject();
            if (fontTypeArray != null) {
                for (int i = 0; i < fontTypeArray.length; ++i) {
                    this.installedFonts.add(fontTypeArray[i]);
                }
            }
        }
    }

    public void save() {
        try (BeanWriter beanWriter = null;){
            beanWriter = new BeanWriter((OutputStream)new FileOutputStream(this.getFontFile()));
            beanWriter.writeObject((Object)this.installedFonts.toArray(new FontType[this.installedFonts.size()]));
        }
    }

    private File getFontDirectory() {
        File file = this.getStateLocation();
        if (file != null) {
            File file2 = new File(file.getAbsolutePath() + File.separator + "fonts");
            if (!file2.exists()) {
                file2.mkdir();
            }
            return file2;
        }
        return null;
    }

    public FontType getFont(String string) {
        for (int i = 0; i < this.installedFonts.size(); ++i) {
            if (!((FontType)this.installedFonts.get(i)).getDisplayName().equalsIgnoreCase(string)) continue;
            return (FontType)this.installedFonts.get(i);
        }
        return null;
    }

    private File getFontFile() {
        File file = this.getFontDirectory();
        if (file != null) {
            return new File(file.getAbsolutePath() + File.separator + "installed_fonts");
        }
        return null;
    }

    private File getStateLocation() {
        IPath iPath = IscobolScreenPainterPlugin.getDefault().getStateLocation();
        if (iPath != null) {
            return iPath.toFile();
        }
        return null;
    }

    public FontType[] getInstalledFonts() {
        return this.installedFonts.toArray(new FontType[this.installedFonts.size()]);
    }

    public void addFont(FontType fontType) {
        if (!this.installedFonts.contains(fontType)) {
            this.installedFonts.add(fontType);
        }
    }

    public void removeFont(FontType fontType) {
        if (this.installedFonts.contains(fontType)) {
            this.installedFonts.remove(fontType);
        }
    }
}

