/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.plugins.editor.util.SortedList;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.dialogs.AddVariableDialog;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.propertysheet.DialogEditor;
import com.iscobol.screenpainter.propertysheet.ElementsProvider;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class VariableEditor
extends DialogEditor
implements ElementsProvider {
    private int deftype = -1;
    private int handleUsage;
    private String propName;
    private String defpicture;
    private AbstractBeanControl gridCellEditor;
    protected CCombo combo;
    private SortedList list;
    private boolean mouseDown;

    public VariableEditor(int n, int n2, String string, String string2) {
        this(n, n2, string, string2, null);
    }

    public VariableEditor(int n, int n2, String string, String string2, AbstractBeanControl abstractBeanControl) {
        this.propName = string;
        this.defpicture = string2;
        this.handleUsage = n2;
        this.gridCellEditor = abstractBeanControl;
        if (n <= 0) {
            n = 0;
        }
        this.deftype = n;
    }

    public void setFocus() {
        this.combo.setFocus();
    }

    protected final SortedList getList() {
        if (this.list == null) {
            this.list = this.createList();
        }
        return this.list;
    }

    protected SortedList createList() {
        return new SortedList();
    }

    void intHandleEvent(Event event) {
        switch (event.type) {
            case 16: {
                event.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: {
                        this.commitValue();
                        this.dispose();
                        event.doit = false;
                        break;
                    }
                    case 2: {
                        if (this.vListener != null) {
                            this.vListener.valueChanged(this.getValue());
                        }
                        this.dispose();
                        event.doit = false;
                    }
                }
                this.mouseDown = false;
            }
        }
    }

    void addListener(int n, Listener listener) {
        super.addListener(n, listener);
        this.contents.addListener(n, listener);
    }

    protected void clearSelection() {
        this.combo.select(0);
        this.setValue(null);
    }

    public void setDefaultHandleUsage(int n) {
        this.handleUsage = n;
        this.deftype = -1;
    }

    protected Object openDialog(Shell shell) {
        Object object;
        String string;
        VariableName variableName = null;
        String string2 = null;
        IscobolScreenPainterEditPart iscobolScreenPainterEditPart = PropertyDescriptorRegistry.getCurrentSelectedEditPart((boolean)false);
        ScreenPainterModel screenPainterModel = iscobolScreenPainterEditPart.getScreenPainterModel();
        if (this.combo.getSelectionIndex() <= 0) {
            string = screenPainterModel.getName();
            if (string != null && string.length() > 0) {
                if (this.gridCellEditor != null) {
                    string = string + "-" + IscobolBeanConstants.getShortTypeName((int)this.gridCellEditor.getType());
                }
                object = this.propName.length() > 3 ? this.propName.substring(0, 3) : this.propName;
                object = ((String)object).trim();
                string2 = screenPainterModel.getScreenProgram().getNewVariableName(string + "-" + (String)object);
            }
        } else {
            string2 = ((VariableType)this.getList().get(this.combo.getSelectionIndex() - 1)).getName();
        }
        string = new AddVariableDialog(shell, screenPainterModel.getScreenProgram(), (VariableName)this.getValue(), string2, this.deftype, this.handleUsage, this.defpicture);
        variableName = string.openDialog();
        object = this.getValue();
        if (object instanceof VariableName && variableName != null) {
            VariableName variableName2 = (VariableName)object;
            String string3 = variableName.getFullString();
            if (variableName2.getFullString().equals(string3) && variableName2.getVariable() == null) {
                int n = string3.lastIndexOf(32);
                if (n >= 0) {
                    string3 = string3.substring(n + 1);
                }
                variableName = string.createNewVariable(string3);
            }
        }
        return variableName;
    }

    public Object[] getElements() {
        if (this.deftype < 0) {
            return new Object[0];
        }
        ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
        return screenProgram.getProgramVariables();
    }

    public String valueToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof VariableType) {
            VariableType variableType = (VariableType)object;
            if (variableType.hasDuplicates()) {
                return variableType.getQName();
            }
            return variableType.getName();
        }
        VariableName variableName = (VariableName)object;
        return variableName.getFullString();
    }

    public Object getValue() {
        return this.value;
    }

    public void doSetValue(Object object) {
        this.value = object instanceof VariableType ? new VariableName((VariableType)object, ((VariableType)object).getName()) : object;
        this.updateContents(this.value);
    }

    protected Control createContents(Composite composite) {
        this.combo = new CCombo(composite, 0);
        this.combo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.combo.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.combo.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.combo.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fillCombo();
        this.contents = this.combo;
        return this.contents;
    }

    protected void fillCombo() {
        int n;
        this.combo.removeAll();
        this.getList().clear();
        Object[] objectArray = this.getElements();
        for (n = 0; n < objectArray.length; ++n) {
            this.getList().add((Comparable)objectArray[n]);
        }
        this.combo.add("");
        for (n = 0; n < this.list.size(); ++n) {
            this.combo.add(this.elementToString(this.list.get(n)));
        }
    }

    protected String elementToString(Object object) {
        return this.valueToString(object);
    }

    protected void updateContents(Object object) {
        VariableName variableName = (VariableName)object;
        this.combo.setText("");
        if (variableName == null) {
            this.combo.select(0);
        } else {
            VariableType variableType = variableName.getVariable();
            if (variableType != null) {
                int n = this.getList().indexOf((Comparable)variableType);
                if (n >= 0) {
                    this.combo.setItem(n + 1, this.elementToString((Object)variableType));
                    this.combo.select(n + 1);
                    this.getList().setElementAt(n, (Comparable)variableType);
                } else {
                    n = this.getList().add((Comparable)variableType);
                    this.combo.add(this.elementToString((Object)variableType), n + 1);
                    this.combo.select(n + 1);
                }
            } else {
                this.combo.select(0);
            }
            this.combo.setText(variableName.getFullString());
        }
    }

    private void commitValue() {
        String string = this.combo.getText().trim();
        if (string.length() == 0) {
            this.setValue(null);
            if (this.vListener != null) {
                this.vListener.valueChanged(this.getValue());
            }
        } else if (PluginUtilities.isValidIdentifier((String)string)) {
            VariableType variableType = PropertyDescriptorRegistry.getCurrentScreenProgram().getProgramVariable(string);
            if (variableType != null) {
                int n = this.getList().indexOf((Comparable)variableType);
                if (n >= 0) {
                    this.setValue(this.getList().get(n));
                }
            } else {
                VariableName variableName = VariableType.getVariableName((String)string, (String)this.defpicture, (int)this.handleUsage, (int)this.deftype);
                this.setValue((Object)variableName);
            }
            if (this.vListener != null) {
                this.vListener.valueChanged(this.getValue());
            }
        }
    }

    static /* synthetic */ void access$000(VariableEditor variableEditor) {
        variableEditor.commitValue();
    }

    static /* synthetic */ SortedList access$100(VariableEditor variableEditor) {
        return variableEditor.list;
    }

    static /* synthetic */ boolean access$200(VariableEditor variableEditor) {
        return variableEditor.mouseDown;
    }

    static /* synthetic */ boolean access$202(VariableEditor variableEditor, boolean bl) {
        variableEditor.mouseDown = bl;
        return variableEditor.mouseDown;
    }
}

