/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.plugins.editor.util.SortedList;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.dialogs.AddVariableDialog;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VariableFieldEditor {
    private Label label;
    private CCombo combo;
    private Button button;
    private Composite control;
    private SortedList list;
    private String namePrefix;
    private int defaultType;
    private int handleUsage;
    private String defaultPicture;
    private VariableType[] elements;
    private SelectionListener selectionListener;

    public VariableFieldEditor(Composite composite, String string, String string2, int n, boolean bl, VariableType[] variableTypeArray, String string3) {
        this(composite, string, string2, n, 0, null, bl, variableTypeArray, string3);
    }

    public VariableFieldEditor(Composite composite, String string, String string2, int n, int n2, String string3, boolean bl, VariableType[] variableTypeArray, String string4) {
        this.namePrefix = string2;
        this.defaultType = n;
        this.handleUsage = n2;
        this.defaultPicture = string3;
        this.elements = variableTypeArray;
        this.control = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.control.setLayout((Layout)gridLayout);
        this.label = new Label(this.control, 0);
        this.label.setText(string);
        this.combo = new CCombo(this.control, 2048);
        this.combo.setEditable(bl);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.combo.setLayoutData((Object)gridData);
        this.button = new Button(this.control, 8);
        this.button.setText("...");
        this.fillCombo();
        VariableName variableName = null;
        if (string4 != null && string4.length() > 0) {
            variableName = new VariableName(null, string4);
        }
        this.updateContents(variableName);
        this.button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.combo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateContents(Object object) {
        VariableName variableName = (VariableName)object;
        this.combo.setText("");
        if (variableName == null) {
            this.combo.select(0);
        } else {
            VariableType variableType = variableName.getVariable();
            if (variableType != null) {
                int n = this.getList().indexOf((Comparable)variableType);
                if (n >= 0) {
                    this.combo.setItem(n + 1, this.valueToString((Object)variableType));
                    this.combo.select(n + 1);
                    this.getList().setElementAt(n, (Comparable)variableType);
                } else {
                    n = this.getList().add((Comparable)variableType);
                    this.combo.add(this.valueToString((Object)variableType), n + 1);
                    this.combo.select(n + 1);
                }
            } else {
                this.combo.select(0);
            }
            this.combo.setText(variableName.getFullString());
        }
    }

    protected Object openDialog(Shell shell) {
        String string;
        String string2 = null;
        IscobolScreenPainterEditPart iscobolScreenPainterEditPart = PropertyDescriptorRegistry.getCurrentSelectedEditPart((boolean)false);
        ScreenPainterModel screenPainterModel = iscobolScreenPainterEditPart.getScreenPainterModel();
        if (this.combo.getSelectionIndex() <= 0) {
            string = screenPainterModel.getName();
            if (string != null && string.length() > 0) {
                string2 = screenPainterModel.getScreenProgram().getNewVariableName(string + "-" + this.namePrefix);
            }
        } else {
            string2 = ((VariableType)this.getList().get(this.combo.getSelectionIndex() - 1)).getName();
        }
        string = new AddVariableDialog(shell, screenPainterModel.getScreenProgram(), this.getValue(), string2, this.defaultType, this.handleUsage, this.defaultPicture);
        return string.openDialog();
    }

    public Object[] getElements() {
        return this.elements;
    }

    protected void fillCombo() {
        int n;
        this.combo.removeAll();
        this.getList().clear();
        Object[] objectArray = this.getElements();
        for (n = 0; n < objectArray.length; ++n) {
            this.getList().add((Comparable)objectArray[n]);
        }
        this.combo.add("");
        for (n = 0; n < this.list.size(); ++n) {
            this.combo.add(this.valueToString(this.list.get(n)));
        }
    }

    protected final SortedList getList() {
        if (this.list == null) {
            this.list = this.createList();
        }
        return this.list;
    }

    protected SortedList createList() {
        return new SortedList();
    }

    public Label getLabel() {
        return this.label;
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public Button getButton() {
        return this.button;
    }

    public Composite getControl() {
        return this.control;
    }

    public VariableName getValue() {
        String string = this.combo.getText().trim();
        if (string.length() > 0) {
            VariableType variableType = null;
            if (this.combo.getSelectionIndex() > 0) {
                variableType = (VariableType)this.getList().get(this.combo.getSelectionIndex() - 1);
            }
            return new VariableName(variableType, string);
        }
        return null;
    }

    public int getHandleUsage() {
        return this.handleUsage;
    }

    public void setHandleUsage(int n) {
        this.handleUsage = n;
    }

    public SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public String valueToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof VariableType) {
            VariableType variableType = (VariableType)object;
            if (variableType.hasDuplicates()) {
                return variableType.getQName();
            }
            return variableType.getName();
        }
        VariableName variableName = (VariableName)object;
        return variableName.getFullString();
    }

    public static void validateVariable(VariableName variableName, String string, ScreenProgram screenProgram) throws IllegalArgumentException {
        if (variableName != null && variableName.getVariable() == null) {
            String string2 = variableName.getFullString();
            int n = string2.indexOf(40);
            if (n >= 0) {
                string2 = string2.substring(0, n).trim();
            }
            VariableType variableType = screenProgram.getProgramVariable(string2);
            variableName.setVariable(variableType);
            if (variableType == null && !PluginUtilities.isValidIdentifier((String)string2)) {
                throw new IllegalArgumentException("Invalid value of '" + string + "'");
            }
        }
    }

    public VariableType getSelectedVariable() {
        if (this.combo.getSelectionIndex() > 0) {
            return (VariableType)this.getList().get(this.combo.getSelectionIndex() - 1);
        }
        return null;
    }

    static /* synthetic */ Button access$000(VariableFieldEditor variableFieldEditor) {
        return variableFieldEditor.button;
    }

    static /* synthetic */ SelectionListener access$100(VariableFieldEditor variableFieldEditor) {
        return variableFieldEditor.selectionListener;
    }
}

