/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.dialogs.AddVariableDialog;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.propertysheet.ComboDialogCellEditor;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.beans.PropertyDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VariablePropertyEditor
extends ComboDialogCellEditor {
    private int deftype = -1;
    private int handleUsage;
    private String propName;
    private boolean initialized = true;

    public VariablePropertyEditor(Composite composite, int n, int n2, String string) {
        super(composite);
        this.propName = string;
        this.handleUsage = n2;
        this.defCombo.removeAll();
        if (n <= 0) {
            n = 0;
        }
        this.deftype = n;
        this.fillCombo();
    }

    private boolean isValidIdentifier(String string) {
        int n = string.indexOf(40);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return PluginUtilities.isValidIdentifier((String)string);
    }

    private void commitValue() {
        String string;
        Object object;
        String string2 = this.defCombo.getText().trim();
        int n = -1;
        IscobolScreenPainterEditPart iscobolScreenPainterEditPart = PropertyDescriptorRegistry.getCurrentSelectedEditPart();
        if (iscobolScreenPainterEditPart == null) {
            return;
        }
        ScreenPainterModel screenPainterModel = iscobolScreenPainterEditPart.getScreenPainterModel();
        if (string2.length() == 0) {
            this.setValue(null);
        } else if (this.isValidIdentifier(string2)) {
            object = PropertyDescriptorRegistry.getCurrentScreenProgram().getProgramVariable(string2);
            if (object != null) {
                this.setValue((Object)new VariableName(object, string2));
            } else {
                string = this.getPictureProp(screenPainterModel);
                VariableName variableName = VariableType.getVariableName((String)string2, (String)string, (int)this.handleUsage, (int)this.deftype);
                this.setValue((Object)variableName);
                n = string2.indexOf(40);
            }
        }
        if (n >= 0) {
            object = string2.substring(0, n);
            if (PropertyDescriptorRegistry.getCurrentScreenProgram().getProgramVariable((String)object) == null) {
                PluginUtilities.logMessage((String)("The '" + (String)object + "' data-item will not be automatically generated"), (int)8);
                this.fireApplyEditorValue();
            } else {
                string = screenPainterModel.getScreenProgram();
                string.setMustAskConfirmDeleteVariable(false);
                this.fireApplyEditorValue();
                string.setMustAskConfirmDeleteVariable(true);
            }
        } else {
            this.fireApplyEditorValue();
        }
        this.deactivate();
    }

    protected void doSetValue(Object object) {
        if (object instanceof VariableType) {
            object = new VariableName((VariableType)object, ((VariableType)object).getName());
        }
        super.doSetValue(object);
    }

    protected Control createContents(Composite composite) {
        super.createContents(composite);
        this.defCombo.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.defCombo.setBackground(composite.getBackground());
        this.defCombo.setFont(composite.getFont());
        return this.defCombo;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\r') {
            this.commitValue();
        }
    }

    protected void fillCombo() {
        if (this.initialized) {
            this.defCombo.removeAll();
            this.getList().clear();
            this.defCombo.add("");
            Object[] objectArray = this.getElements();
            for (int i = 0; i < objectArray.length; ++i) {
                int n = this.getList().add((Comparable)objectArray[i]);
                this.defCombo.add(this.valueToString(objectArray[i]), n + 1);
            }
        }
    }

    protected void updateContents(Object object) {
        if (this.defCombo == null) {
            return;
        }
        VariableName variableName = (VariableName)object;
        if (variableName == null) {
            this.defCombo.select(0);
        } else if (variableName.isOccurs()) {
            this.defCombo.setText(variableName.toString());
        } else {
            VariableType variableType = variableName.getVariable();
            if (variableType != null) {
                int n = this.getList().indexOf((Comparable)variableType);
                if (n >= 0) {
                    this.getList().setElementAt(n, (Comparable)variableType);
                    this.defCombo.setItem(n + 1, this.valueToString((Object)variableType));
                    this.defCombo.select(n + 1);
                } else {
                    n = this.getList().add((Comparable)variableType);
                    this.defCombo.add(this.valueToString((Object)variableType), n + 1);
                    this.defCombo.select(n + 1);
                }
            } else {
                this.defCombo.select(0);
            }
        }
        this.setValueValid(this.isCorrect(object));
    }

    protected Object doOpenDialogBox(Control control) {
        String string;
        String string2;
        VariableName variableName = null;
        String string3 = null;
        IscobolScreenPainterEditPart iscobolScreenPainterEditPart = PropertyDescriptorRegistry.getCurrentSelectedEditPart((boolean)false);
        ScreenPainterModel screenPainterModel = iscobolScreenPainterEditPart.getScreenPainterModel();
        if (this.defCombo.getSelectionIndex() <= 0) {
            if (screenPainterModel != null && (string2 = screenPainterModel.getName()) != null && string2.length() > 0) {
                string = this.propName.length() > 3 ? this.propName.substring(0, 3) : this.propName;
                string = string.trim();
                string3 = screenPainterModel.getScreenProgram().getNewVariableName(string2 + "-" + string);
            }
        } else {
            string3 = ((VariableType)this.getList().get(this.defCombo.getSelectionIndex() - 1)).getName();
        }
        string2 = this.getPictureProp(screenPainterModel);
        string = new AddVariableDialog(control.getShell(), screenPainterModel.getScreenProgram(), (VariableName)this.getValue(), string3, this.deftype, this.handleUsage, string2);
        variableName = string.openDialog();
        Object object = this.getValue();
        if (object instanceof VariableName && variableName != null) {
            VariableName variableName2 = (VariableName)object;
            String string4 = variableName.getFullString();
            if (variableName2.getFullString().equals(string4) && variableName2.getVariable() == null) {
                int n = string4.lastIndexOf(32);
                if (n >= 0) {
                    string4 = string4.substring(n + 1);
                }
                variableName = VariableType.getVariableName((String)string4, (String)string2, (int)this.handleUsage, (int)this.deftype);
            }
        }
        return variableName;
    }

    public Object[] getElements() {
        ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
        return screenProgram.getProgramVariables();
    }

    private String getPictureProp(ScreenPainterModel screenPainterModel) {
        Object object;
        if (screenPainterModel == null || (object = screenPainterModel.getTarget()) == null || !this.propName.endsWith(" variable")) {
            return null;
        }
        String string = this.propName.substring(0, this.propName.length() - " variable".length()) + " picture";
        PropertyDescriptor propertyDescriptor = PropertyDescriptorRegistry.getJPropertyDescriptor(object.getClass(), (String)string);
        if (propertyDescriptor != null) {
            try {
                return (String)propertyDescriptor.getReadMethod().invoke(object, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected String valueToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof VariableType) {
            VariableType variableType = (VariableType)object;
            if (variableType.hasDuplicates()) {
                return variableType.getQName();
            }
            return variableType.getName();
        }
        return ((VariableName)object).getFullString();
    }

    protected CCombo createCombo(Composite composite) {
        CCombo cCombo = new CCombo(composite, 0);
        cCombo.setEditable(true);
        return cCombo;
    }

    protected boolean isEditable() {
        return true;
    }

    static /* synthetic */ void access$000(VariablePropertyEditor variablePropertyEditor) {
        variablePropertyEditor.commitValue();
    }
}

