/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet.pages;

import com.iscobol.screenpainter.BaseGraphicalEditor;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.propertysheet.FilteredPropertySource;
import com.iscobol.screenpainter.propertysheet.IPropertySource2;
import com.iscobol.screenpainter.propertysheet.pages.UndoablePropertySheetPage;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class TabbedPropertySheetPage
extends Page
implements IPropertySheetPage {
    private static final int PROPERTIES_TAB_INDEX = 0;
    private static final int EVENTS_TAB_INDEX = 1;
    private static final int EXCEPTIONS_TAB_INDEX = 2;
    private static final int PROCEDURES_TAB_INDEX = 3;
    private static final int VARIABLES_TAB_INDEX = 4;
    private CTabFolder tabFolder;
    private Composite control;
    private IWorkbenchPart part;
    private ISelection selection;
    private ArrayList<UndoablePropertySheetPage> pages = new ArrayList();
    private BaseGraphicalEditor editor;
    private String lastSelectedPropertyName;
    private Object lastEditPartModel;
    private int lastTabFolderSelectedIndex = 0;

    public TabbedPropertySheetPage(BaseGraphicalEditor baseGraphicalEditor) {
        this.editor = baseGraphicalEditor;
    }

    public void dispose() {
        super.dispose();
        this.pages.clear();
    }

    public void createControl(Composite composite) {
        this.control = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        this.control.setLayout((Layout)gridLayout);
        this.tabFolder = new CTabFolder(this.control, 0);
        GridData gridData = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gridData);
        this.pages.add(this.createPage("Properties"));
        this.pages.add(this.createPage("Events"));
        this.pages.add(this.createPage("Exceptions"));
        this.pages.add(this.createPage("Procedures"));
        this.pages.add(this.createPage("Variables"));
        this.tabFolder.setSelection(0);
        this.tabFolder.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabFolder.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setGraphicalEditor(BaseGraphicalEditor baseGraphicalEditor) {
        this.editor = baseGraphicalEditor;
        for (UndoablePropertySheetPage undoablePropertySheetPage : this.pages) {
            undoablePropertySheetPage.setGraphicalEditor(this.editor);
        }
    }

    public BaseGraphicalEditor getGraphicalEditor() {
        return this.editor;
    }

    private void tabFolderSelchange(int n) {
        this.lastTabFolderSelectedIndex = n;
        ((UndoablePropertySheetPage)this.pages.get(n)).getControl().setFocus();
        if (this.part != null && this.selection != null) {
            this.selectionChanged(this.part, this.selection);
        }
    }

    private UndoablePropertySheetPage createPage(String string) {
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        cTabItem.setText(string);
        UndoablePropertySheetPage undoablePropertySheetPage = new UndoablePropertySheetPage(this.editor);
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        cTabItem.setControl((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new FillLayout());
        undoablePropertySheetPage.createControl(composite2);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(768));
        composite3.setLayout((Layout)new FillLayout());
        StatusLineManager statusLineManager = new StatusLineManager();
        statusLineManager.createControl(composite3);
        undoablePropertySheetPage.makeContributions((IMenuManager)new MenuManager(), (IToolBarManager)new ToolBarManager(), (IStatusLineManager)statusLineManager);
        if (undoablePropertySheetPage.getControl() instanceof Tree) {
            Tree tree = (Tree)undoablePropertySheetPage.getControl();
            tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return undoablePropertySheetPage;
    }

    private int getFilterCategory() {
        switch (this.tabFolder.getSelectionIndex()) {
            default: {
                return 5;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: 
        }
        return 3;
    }

    public void selectPropertiesTab() {
        this.tabFolder.setSelection(0);
        this.tabFolderSelchange(0);
    }

    public void selectEventsTab() {
        this.tabFolder.setSelection(1);
        this.tabFolderSelchange(1);
    }

    public void selectProceduresTab() {
        this.tabFolder.setSelection(3);
        this.tabFolderSelchange(3);
    }

    public void selectExceptionsTab() {
        this.tabFolder.setSelection(2);
        this.tabFolderSelchange(2);
    }

    public void selectVariablesTab() {
        this.tabFolder.setSelection(4);
        this.tabFolderSelchange(4);
    }

    public PropertySheetPage getCurrentPropertySheetPage() {
        return (PropertySheetPage)this.pages.get(this.tabFolder.getSelectionIndex());
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.getCurrentPropertySheetPage().getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        int n;
        Tree tree;
        StructuredSelection structuredSelection;
        this.part = iWorkbenchPart;
        this.selection = iSelection;
        Object object = null;
        if (iSelection instanceof StructuredSelection) {
            structuredSelection = (StructuredSelection)iSelection;
            ArrayList<FilteredPropertySource> arrayList = new ArrayList<FilteredPropertySource>();
            tree = structuredSelection.toArray();
            boolean bl = false;
            IProject iProject = null;
            for (Object object2 : tree) {
                ScreenPainterModel screenPainterModel;
                EditPart editPart;
                if (!(object2 instanceof EditPart) || !((editPart = (EditPart)object2).getModel() instanceof IPropertySource2)) continue;
                object = editPart.getModel();
                if (editPart.getModel() instanceof ScreenPainterModel) {
                    screenPainterModel = (ScreenPainterModel)editPart.getModel();
                    n = IscobolBeanConstants.getGuiControlType((int)screenPainterModel.getType());
                } else {
                    screenPainterModel = null;
                    n = -1;
                }
                if (iProject == null && screenPainterModel != null) {
                    iProject = screenPainterModel.getScreenProgram().getProject();
                    bl = "true".equals(PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobolsp.showonlywd2supported"));
                }
                this.tabFolder.setSelection(this.lastTabFolderSelectedIndex);
                FilteredPropertySource filteredPropertySource = new FilteredPropertySource((IPropertySource2)object, this.getFilterCategory(), bl, n, iProject);
                arrayList.add(0, filteredPropertySource);
            }
            iSelection = new StructuredSelection(arrayList.toArray());
        }
        structuredSelection = (PropertySheetPage)this.pages.get(this.tabFolder.getSelectionIndex());
        structuredSelection.selectionChanged(iWorkbenchPart, iSelection);
        if (object != null && this.lastEditPartModel != object) {
            int n2;
            if (structuredSelection.getControl() instanceof Tree && (n2 = this.getModelType(object)) >= 0) {
                tree = (Tree)structuredSelection.getControl();
                TreeItem[] treeItemArray = tree.getItems();
                if (this.lastSelectedPropertyName != null) {
                    boolean bl = false;
                    for (n = 0; n < treeItemArray.length && !bl; ++n) {
                        if (!treeItemArray[n].getText(0).equals(this.lastSelectedPropertyName)) continue;
                        this.selectItem(treeItemArray[n]);
                        bl = true;
                    }
                    if (!bl) {
                        this.setDefaultProperty(n2, treeItemArray);
                    }
                } else {
                    this.setDefaultProperty(n2, treeItemArray);
                }
            }
            this.lastEditPartModel = object;
        }
    }

    public void setActionBars(IActionBars iActionBars) {
        super.setActionBars(iActionBars);
        for (int i = 0; i < this.pages.size(); ++i) {
            ((UndoablePropertySheetPage)this.pages.get(i)).setActionBars(iActionBars);
        }
    }

    private void selectItem(TreeItem treeItem) {
        Tree tree = treeItem.getParent();
        tree.setSelection(treeItem);
        tree.showItem(treeItem);
    }

    private void setDefaultProperty(int n, TreeItem[] treeItemArray) {
        boolean bl = false;
        String string = IscobolBeanConstants.getDefaultProperty((int)n);
        if (string != null) {
            for (int i = 0; i < treeItemArray.length && !bl; ++i) {
                if (!treeItemArray[i].getText(0).equals(string)) continue;
                this.selectItem(treeItemArray[i]);
                bl = true;
            }
            if (!bl && treeItemArray.length > 0) {
                this.selectItem(treeItemArray[0]);
            }
        } else if (treeItemArray.length > 0) {
            this.selectItem(treeItemArray[0]);
        }
    }

    public Object getLastEditPartModel() {
        return this.lastEditPartModel;
    }

    public void setLastEditPartModel(Object object) {
        this.lastEditPartModel = object;
    }

    public String getLastSelectedPropertyName() {
        return this.lastSelectedPropertyName;
    }

    public void setLastSelectedPropertyName(String string) {
        this.lastSelectedPropertyName = string;
    }

    public int getModelType(Object object) {
        if (object instanceof ScreenPainterModel) {
            return ((ScreenPainterModel)object).getType();
        }
        return -1;
    }

    static /* synthetic */ CTabFolder access$000(TabbedPropertySheetPage tabbedPropertySheetPage) {
        return tabbedPropertySheetPage.tabFolder;
    }

    static /* synthetic */ void access$100(TabbedPropertySheetPage tabbedPropertySheetPage, int n) {
        tabbedPropertySheetPage.tabFolderSelchange(n);
    }

    static /* synthetic */ String access$202(TabbedPropertySheetPage tabbedPropertySheetPage, String string) {
        tabbedPropertySheetPage.lastSelectedPropertyName = string;
        return tabbedPropertySheetPage.lastSelectedPropertyName;
    }
}

