/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet.pages;

import com.iscobol.screenpainter.BaseGraphicalEditor;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class UndoablePropertySheetPage
extends PropertySheetPage {
    private static final String[] actionIds = new String[]{ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.COPY.getId(), ActionFactory.CUT.getId(), ActionFactory.PASTE.getId()};
    private final CommandStackEventListener commandStackEventListener = new /* Unavailable Anonymous Inner Class!! */;
    private BaseGraphicalEditor editor;
    private IActionBars actionBars;

    public UndoablePropertySheetPage(BaseGraphicalEditor baseGraphicalEditor) {
        this.setGraphicalEditor(baseGraphicalEditor);
    }

    public void setGraphicalEditor(BaseGraphicalEditor baseGraphicalEditor) {
        CommandStack commandStack;
        if (this.editor != null) {
            commandStack = this.editor.getCommandStack();
            commandStack.removeCommandStackEventListener(this.commandStackEventListener);
        }
        this.editor = baseGraphicalEditor;
        if (this.editor != null) {
            commandStack = this.editor.getCommandStack();
            commandStack.addCommandStackEventListener(this.commandStackEventListener);
            this.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(commandStack));
        }
        this.updateActionBars();
    }

    public BaseGraphicalEditor getGraphicalEditor() {
        return this.editor;
    }

    public void createControl(Composite composite) {
        TypedListener typedListener;
        Listener[] listenerArray;
        super.createControl(composite);
        Control control = this.getControl();
        if (control != null && (listenerArray = control.getListeners(3)).length > 0 && listenerArray[0] instanceof TypedListener && (typedListener = (TypedListener)listenerArray[0]).getEventListener() instanceof MouseListener) {
            MouseListener mouseListener = (MouseListener)typedListener.getEventListener();
            control.removeMouseListener(mouseListener);
            control.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void dispose() {
        if (this.editor != null) {
            CommandStack commandStack = this.editor.getCommandStack();
            commandStack.removeCommandStackEventListener(this.commandStackEventListener);
        }
        super.dispose();
    }

    public void setActionBars(IActionBars iActionBars) {
        this.actionBars = iActionBars;
        this.updateActionBars();
    }

    private void updateActionBars() {
        if (this.actionBars != null && this.editor != null) {
            for (int i = 0; i < actionIds.length; ++i) {
                IAction iAction = this.editor.getActionRegistry().getAction((Object)actionIds[i]);
                this.actionBars.setGlobalActionHandler(actionIds[i], iAction);
            }
        }
    }
}

