/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util;

import com.iscobol.screenpainter.beans.types.ColorType;
import java.awt.Color;

public class ColorPalette {
    private Color[] colors = new Color[16];
    private boolean report;

    public ColorPalette(boolean bl) {
        this("", bl);
    }

    public ColorPalette(ColorPalette colorPalette) {
        this.report = colorPalette.report;
        for (int i = 0; i < this.colors.length; ++i) {
            this.setColor(i, colorPalette.getColor(i));
        }
    }

    public ColorPalette(String string, boolean bl) {
        this.report = bl;
        this.setColors(string);
    }

    public Color getColor(int n) throws ArrayIndexOutOfBoundsException {
        return this.colors[n];
    }

    public void setColor(int n, Color color) throws ArrayIndexOutOfBoundsException {
        this.colors[n] = color;
    }

    public void resetColor(int n) throws ArrayIndexOutOfBoundsException {
        this.colors[n] = ColorType.getDefaultColor((int)n, (boolean)this.report);
    }

    public void resetAllColors() {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = ColorType.getDefaultColor((int)i, (boolean)this.report);
        }
    }

    public void setColors(String string) {
        this.resetAllColors();
        for (String string2 : string.split("\\;")) {
            String[] stringArray = string2.split("\\,");
            try {
                this.colors[Integer.parseInt((String)stringArray[0]) - 1] = new Color(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.colors.length; ++i) {
            if (this.colors[i] == ColorType.getDefaultColor((int)i, (boolean)this.report)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(i + 1);
            stringBuilder.append(',');
            stringBuilder.append(this.colors[i].getRed());
            stringBuilder.append(',');
            stringBuilder.append(this.colors[i].getGreen());
            stringBuilder.append(',');
            stringBuilder.append(this.colors[i].getBlue());
        }
        return stringBuilder.toString();
    }

    public boolean isDefault(int n) throws ArrayIndexOutOfBoundsException {
        return this.colors[n].equals(ColorType.getDefaultColor((int)n, (boolean)this.report));
    }

    public boolean isPaletteChanged() {
        for (int i = 0; i < this.colors.length; ++i) {
            if (this.isDefault(i)) continue;
            return true;
        }
        return false;
    }
}

