/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util;

import com.iscobol.screenpainter.util.EditableControlWrapper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class EditableControlWrapper {
    public abstract void cut();

    public abstract void copy();

    public abstract void paste();

    public abstract boolean canPaste();

    public abstract boolean canCopy();

    public abstract boolean canCut();

    public static EditableControlWrapper getInstance(Combo combo) {
        return new EditableComboWrapper(combo);
    }

    public static EditableControlWrapper getInstance(CCombo cCombo) {
        return new EditableCComboWrapper(cCombo);
    }

    public static EditableControlWrapper getInstance(Text text) {
        return new EditableTextWrapper(text);
    }

    public static EditableControlWrapper getInstance(StyledText styledText) {
        return new EditableStyledTextWrapper(styledText);
    }

    public static EditableControlWrapper getInstance(Spinner spinner) {
        return new EditableSpinnerWrapper(spinner);
    }

    public static EditableControlWrapper getInstance(Control control) {
        if (control == null) {
            throw new IllegalArgumentException("null");
        }
        if (control instanceof Text) {
            return EditableControlWrapper.getInstance((Text)((Text)control));
        }
        if (control instanceof StyledText) {
            return EditableControlWrapper.getInstance((StyledText)((StyledText)control));
        }
        if (control instanceof Combo) {
            return EditableControlWrapper.getInstance((Combo)((Combo)control));
        }
        if (control instanceof CCombo) {
            return EditableControlWrapper.getInstance((CCombo)((CCombo)control));
        }
        if (control instanceof Spinner) {
            return EditableControlWrapper.getInstance((Spinner)((Spinner)control));
        }
        throw new IllegalArgumentException("Invalid control type '" + control.getClass() + "'");
    }

    public static boolean isEditableControl(Control control) {
        return control instanceof Text || control instanceof StyledText || control instanceof Combo || control instanceof CCombo || control instanceof Spinner;
    }
}

