/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.plugins.editor.ITextDataTransfer;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolReconcilingEngine;
import com.iscobol.plugins.editor.IscobolStyledText;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.plugins.editor.util.ProjectFileFinder;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.types.CopySettingItem;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.model.commands.PasteData;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class ISPTextDataTransfer
implements ITextDataTransfer {
    public void copy(IscobolEditor iscobolEditor) {
        VariableTypeList variableTypeList;
        ProjectFileFinder projectFileFinder;
        String[] stringArray;
        String string;
        IRegion iRegion;
        IProject iProject = iscobolEditor.getProject();
        IDocument iDocument = iscobolEditor.getViewer().getDocument();
        IscobolStyledText iscobolStyledText = (IscobolStyledText)iscobolEditor.getViewer().getTextWidget();
        String string2 = iscobolStyledText.getSelectionText();
        if (string2.length() == 0) {
            return;
        }
        String string3 = string2;
        int n = iscobolStyledText.getSelectionRange().x;
        try {
            int n2 = iDocument.getLineOfOffset(n);
            iRegion = iDocument.getLineInformation(n2);
            if (iRegion.getOffset() < n) {
                string3 = iDocument.get(iRegion.getOffset(), n - iRegion.getOffset()) + string3;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (iProject != null) {
            string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject), (String)"-sp=");
            stringArray = IscobolReconcilingEngine.getSyntaxCheckingOptions((IResource)iProject, null, (String)(string != null ? string.toString() : ""), (ICompiler)Factory.getCompiler((IProject)iProject));
            projectFileFinder = new ProjectFileFinder(iProject);
        } else {
            string = null;
            stringArray = new String[]{"-jj"};
            projectFileFinder = null;
        }
        ArrayList arrayList = new ArrayList();
        PluginUtilities.analyzeCopy((String)string3, null, (String)"xxx", (String[])stringArray, arrayList, null, (IProject)iProject, (ProjectFileFinder)projectFileFinder, (int)0, null);
        iRegion = new PasteData();
        String string4 = "Unable to paste the copy data, due to syntax not recognized by the parser";
        if (!arrayList.isEmpty()) {
            variableTypeList = (VariableTypeList)arrayList.get(0);
            int n3 = variableTypeList.getSettingCount();
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    iRegion.addSettingItem(variableTypeList.getSettingAt(i));
                }
            } else {
                iRegion.setVariablesErrorMessage(string4);
            }
        } else {
            iRegion.setVariablesErrorMessage(string4);
        }
        iRegion.setTextData(string2);
        variableTypeList = TextTransfer.getInstance();
        LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
        StructuredSelection structuredSelection = new StructuredSelection((Object)iRegion);
        localSelectionTransfer.setSelection((ISelection)structuredSelection);
        org.eclipse.swt.dnd.Clipboard clipboard = new org.eclipse.swt.dnd.Clipboard(iscobolEditor.getSite().getShell().getDisplay());
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        RTFTransfer rTFTransfer = RTFTransfer.getInstance();
        Object object = clipboard.getContents((Transfer)rTFTransfer, 1);
        if (object != null) {
            arrayList2.add(rTFTransfer);
            arrayList3.add(object);
        }
        Object object2 = clipboard.getContents((Transfer)variableTypeList, 1);
        arrayList2.add(variableTypeList);
        if (object2 != null) {
            arrayList3.add(object2);
        } else {
            arrayList3.add(string2);
        }
        arrayList2.add(localSelectionTransfer);
        arrayList3.add(structuredSelection);
        clipboard.setContents(arrayList3.toArray(), arrayList2.toArray(new Transfer[arrayList2.size()]), 1);
    }

    public String paste(IscobolEditor iscobolEditor) {
        String[] stringArray;
        Object object = Clipboard.getDefault().getContents();
        if (object == null || !(object instanceof PasteData)) {
            return null;
        }
        PasteData pasteData = (PasteData)object;
        if (pasteData.getTextData() != null) {
            return pasteData.getTextData();
        }
        SettingItem[] settingItemArray = pasteData.getSettingItems();
        if (settingItemArray.length == 0 || !(settingItemArray[0] instanceof VariableType) && !(settingItemArray[0] instanceof CopySettingItem)) {
            return null;
        }
        IDocument iDocument = iscobolEditor.getViewer().getDocument();
        IscobolStyledText iscobolStyledText = (IscobolStyledText)iscobolEditor.getViewer().getTextWidget();
        String string = iscobolStyledText.getSelectionText();
        int n = string.length() > 0 ? iscobolStyledText.getSelectionRange().x : iscobolStyledText.getCaretOffset();
        String string2 = "";
        try {
            int n2 = iDocument.getLineOfOffset(n);
            stringArray = iDocument.getLineInformation(n2);
            if (stringArray.getOffset() < n) {
                string2 = iDocument.get(stringArray.getOffset(), n - stringArray.getOffset());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringArray = new String[]{"", null};
        boolean bl = iscobolEditor.getFormat() == 1 || iscobolEditor.getFormat() == 4;
        int n3 = IscobolScreenPainterPlugin.getIntFromStore((String)"iscobol.progfile.case");
        boolean bl2 = iscobolEditor.getDecimalPointComma();
        CobolFormatter cobolFormatter = new CobolFormatter(bl, n3);
        for (int i = 0; i < settingItemArray.length; ++i) {
            if (settingItemArray[i] instanceof VariableType) {
                this.getVarDeclCode((VariableType)settingItemArray[i], bl2, "", stringArray, cobolFormatter, stringBuilder);
                continue;
            }
            if (!(settingItemArray[i] instanceof CopySettingItem)) continue;
            String string3 = "copy \"" + ((CopySettingItem)settingItemArray[i]).fileName + "\".";
            if (i == 0) {
                string3 = string2 + string3;
            }
            stringBuilder.append(cobolFormatter.formatLine(string3));
        }
        return stringBuilder.toString();
    }

    private void getVarDeclCode(VariableType variableType, boolean bl, String string, String[] stringArray, CobolFormatter cobolFormatter, StringBuilder stringBuilder) {
        stringBuilder.append(CodeGenerator.getVarDeclCode((VariableType)variableType, null, (boolean)bl, (String)string, (String[])stringArray, null, (CobolFormatter)cobolFormatter));
        SettingTreeItem[] settingTreeItemArray = variableType.getChildren();
        string = string + "   ";
        for (SettingTreeItem settingTreeItem : settingTreeItemArray) {
            this.getVarDeclCode((VariableType)settingTreeItem, bl, string, stringArray, cobolFormatter, stringBuilder);
        }
    }
}

