/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class RenameDataLayoutParticipant
extends RenameParticipant {
    private IFile file;

    protected boolean initialize(Object object) {
        this.file = (IFile)object;
        return true;
    }

    public String getName() {
        return "Rename Data Layout Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        if (this.renameScreenProgramWithoutExtension()) {
            try {
                IContainer iContainer = PluginUtilities.getFDFolder((IProject)this.file.getProject());
                return RefactoringStatus.createErrorStatus((String)("The extension of the files under the '" + iContainer.getName() + "' folder should be 'idl'.If you change the extension, the file will not be visible anymore in the 'Data' and 'File' views"));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        return null;
    }

    private boolean renameScreenProgramWithoutExtension() {
        RenameArguments renameArguments = this.getArguments();
        if (!renameArguments.getNewName().endsWith("idl")) {
            IProject iProject = this.file.getProject();
            try {
                if (iProject != null && iProject.getNature(IscobolEditor.ID + "." + "IscobolNature") != null) {
                    IContainer iContainer = PluginUtilities.getFDFolder((IProject)iProject);
                    return iContainer != null && iContainer.equals(this.file.getParent());
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }
}

