/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class RenameScreenProgramParticipant
extends RenameParticipant {
    private IFile file;

    protected boolean initialize(Object object) {
        this.file = (IFile)object;
        return true;
    }

    public String getName() {
        return "Rename Screen Program Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        if (this.renameScreenProgramWithoutExtension()) {
            try {
                IContainer iContainer = PluginUtilities.getScreenFolder((IProject)this.file.getProject());
                return RefactoringStatus.createErrorStatus((String)("The extension of the files under the '" + iContainer.getName() + "' folder should be 'isp'.If you change the extension, the file will not be visible anymore in the 'Structural' and 'File' views"));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        ScreenProgramEditor screenProgramEditor = PluginUtilities.findScreenProgramEditor((IFile)this.file);
        if (screenProgramEditor != null && screenProgramEditor.isDirty()) {
            screenProgramEditor.getSite().getShell().getDisplay().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        return null;
    }

    private boolean renameScreenProgramWithoutExtension() {
        RenameArguments renameArguments = this.getArguments();
        if (!renameArguments.getNewName().endsWith("isp")) {
            IProject iProject = this.file.getProject();
            try {
                if (iProject != null && iProject.getNature(IscobolEditor.ID + "." + "IscobolNature") != null) {
                    IContainer iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
                    return iContainer != null && iContainer.equals(this.file.getParent());
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }
}

