/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.ScreenRoot;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.AbstractScreenRootNavigatorAdapter;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractScreenProgramNavigatorAdapter
extends AbstractScreenRootNavigatorAdapter {
    public boolean handleOpen(OpenEvent openEvent, IStructuredSelection iStructuredSelection) {
        if (!this.checkSelection(iStructuredSelection)) {
            return false;
        }
        IScreenProgramAdapter iScreenProgramAdapter = (IScreenProgramAdapter)iStructuredSelection.getFirstElement();
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            ScreenProgram screenProgram = iScreenProgramAdapter.getScreenProgram();
            if (!PluginUtilities.checkRelease((ScreenRoot)screenProgram, (Shell)iWorkbenchWindow.getShell())) {
                return false;
            }
            screenProgram.disableReleaseCheck();
            ScreenProgramEditor screenProgramEditor = null;
            if (iWorkbenchPage != null) {
                try {
                    FileEditorInput fileEditorInput = new FileEditorInput(screenProgram.getFile());
                    screenProgramEditor = (ScreenProgramEditor)PluginUtilities.findEditor((IWorkbenchPage)iWorkbenchPage, (IEditorInput)fileEditorInput, (String)"iscobolscreenpainter.MultipageScreenSectionEditor");
                    if (screenProgramEditor != null) {
                        iWorkbenchPage.activate((IWorkbenchPart)screenProgramEditor);
                    } else {
                        screenProgramEditor = (ScreenProgramEditor)iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, "iscobolscreenpainter.MultipageScreenSectionEditor", true, 3);
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
                this.activateEditorPage(screenProgramEditor);
            }
        }
        return true;
    }

    protected abstract void activateEditorPage(ScreenProgramEditor var1);
}

