/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.plugins.editor.views.IscobolNavigatorAdapter;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.util.adapters.DataSetNavigatorAdapter;
import com.iscobol.screenpainter.util.adapters.FileSectionAdapter;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DataSetAdapter
extends PlatformObject
implements IscobolWorkbenchAdapter,
IscobolProjectAdapter,
IScreenProgramAdapter {
    private FileSectionAdapter parent;
    private DataSet dataSet;
    private int hashCode;

    public DataSetAdapter(DataSet dataSet, FileSectionAdapter fileSectionAdapter) {
        this.parent = fileSectionAdapter;
        this.dataSet = dataSet;
    }

    public Object[] getChildren() {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/dataset.png");
    }

    public String getLabel() {
        return this.dataSet.getName();
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return false;
    }

    public Image getImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/dataset.png");
    }

    public IFile getProgramFile() {
        return this.parent.getProgramFile();
    }

    public ScreenProgram getScreenProgram() {
        return this.parent.getScreenProgram();
    }

    public IProject getProject() {
        return this.getScreenProgram().getFile().getProject();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataSetAdapter)) {
            return false;
        }
        return this.dataSet.getName().equalsIgnoreCase(((DataSetAdapter)object).dataSet.getName());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (this.parent.getScreenProgram().getFile().getFullPath().toPortableString() + this.dataSet.getName()).hashCode();
        }
        return this.hashCode;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == ScreenProgram.class) {
            return this.getScreenProgram();
        }
        return super.getAdapter(clazz);
    }

    public IscobolNavigatorAdapter getIscobolNavigatorAdapter() {
        return new DataSetNavigatorAdapter();
    }

    public String getProgramName() {
        return this.getScreenProgram().getProgramName();
    }
}

