/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.actions.DeleteDataSetAction;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.util.adapters.AbstractScreenProgramNavigatorAdapter;
import com.iscobol.screenpainter.util.adapters.DataSetAdapter;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.KeyEvent;

public class DataSetNavigatorAdapter
extends AbstractScreenProgramNavigatorAdapter {
    private DataSet dataSet;

    protected boolean checkSelection(IStructuredSelection iStructuredSelection) {
        return true;
    }

    private boolean intCheckSelection(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        if (list.size() == 0) {
            return false;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() instanceof DataSetAdapter) continue;
            return false;
        }
        return true;
    }

    private DeleteDataSetAction getAction(IStructuredSelection iStructuredSelection) {
        DeleteDataSetAction deleteDataSetAction = new DeleteDataSetAction();
        deleteDataSetAction.selectionChanged(null, (ISelection)iStructuredSelection);
        return deleteDataSetAction;
    }

    public void fillContextMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return;
        }
        DeleteDataSetAction deleteDataSetAction = this.getAction(iStructuredSelection);
        deleteDataSetAction.setText("Delete");
        deleteDataSetAction.setImageDescriptor(IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/delete.gif"));
        iMenuManager.insertAfter("org.eclipse.ui.PasteAction", (IAction)deleteDataSetAction);
    }

    public boolean handleKeyPressed(KeyEvent keyEvent, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return false;
        }
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
            DeleteDataSetAction deleteDataSetAction = this.getAction(iStructuredSelection);
            deleteDataSetAction.run();
            return true;
        }
        return false;
    }

    public boolean handleOpen(OpenEvent openEvent, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return false;
        }
        this.dataSet = ((DataSetAdapter)iStructuredSelection.getFirstElement()).getDataSet();
        return super.handleOpen(openEvent, iStructuredSelection);
    }

    protected void activateEditorPage(ScreenProgramEditor screenProgramEditor) {
        if (screenProgramEditor != null) {
            screenProgramEditor.activateFileSectionPage(this.dataSet);
        }
    }

    protected Class getAdaptableType() {
        return DataSetAdapter.class;
    }
}

