/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.plugins.editor.views.IscobolNavigatorAdapter;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.EFDAdapter;
import com.iscobol.screenpainter.util.adapters.FDEventParagraphsAdapter;
import com.iscobol.screenpainter.util.adapters.FDNavigatorAdapter;
import com.iscobol.screenpainter.util.adapters.FileControlAdapter;
import com.iscobol.screenpainter.util.adapters.IFDAdapter;
import com.iscobol.screenpainter.util.adapters.IOHandlingAdapter;
import com.iscobol.screenpainter.util.adapters.KeyDefinitionAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FDAdapter
extends PlatformObject
implements IWorkbenchAdapter,
IscobolWorkbenchAdapter,
IscobolProjectAdapter,
IFDAdapter {
    private IFile dlFile;
    private int hashCode;
    private FileControlAdapter fileControl;
    private KeyDefinitionAdapter keyDefinition;
    private IOHandlingAdapter ioHandling;
    private EFDAdapter efd;
    private FDEventParagraphsAdapter eventPar;

    public FDAdapter(IFile iFile) {
        this.dlFile = iFile;
        this.hashCode = this.dlFile.getFullPath().toPortableString().hashCode();
        this.fileControl = new FileControlAdapter(this);
        this.keyDefinition = new KeyDefinitionAdapter(this);
        this.ioHandling = new IOHandlingAdapter(this);
        this.efd = new EFDAdapter(this);
        this.eventPar = new FDEventParagraphsAdapter(this);
    }

    public FileControlAdapter getFileControl() {
        return this.fileControl;
    }

    public KeyDefinitionAdapter getKeyDefinition() {
        return this.keyDefinition;
    }

    public IOHandlingAdapter getIoHandling() {
        return this.ioHandling;
    }

    public EFDAdapter getEfd() {
        return this.efd;
    }

    public FDEventParagraphsAdapter getEventPar() {
        return this.eventPar;
    }

    public Object[] getChildren() {
        return new Object[]{this.fileControl, this.keyDefinition, this.ioHandling, this.efd, this.eventPar};
    }

    public boolean hasChildren() {
        return true;
    }

    public IFile getDataLayoutFile() {
        return this.dlFile;
    }

    public ImageDescriptor getImageDescriptor() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/fdsl.png");
    }

    public String getLabel() {
        return new ScreenFD_SL(this.dlFile).getFdName();
    }

    public Object getParent() {
        return this.dlFile.getParent();
    }

    public Image getImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/fdsl.png");
    }

    public ScreenFD_SL getDataLayout() {
        return PluginUtilities.getDataLayout((IFile)this.dlFile);
    }

    public IProject getProject() {
        return this.dlFile.getProject();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FDAdapter)) {
            return false;
        }
        return this.dlFile.equals(((FDAdapter)object).dlFile);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Object[] getChildren(Object object) {
        return this.getChildren();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getImageDescriptor();
    }

    public String getLabel(Object object) {
        return this.getLabel();
    }

    public Object getParent(Object object) {
        return this.getParent();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IResource.class) {
            return this.getDataLayout().getFile();
        }
        if (clazz == ScreenFD_SL.class) {
            return this.getDataLayout();
        }
        return super.getAdapter(clazz);
    }

    public IscobolNavigatorAdapter getIscobolNavigatorAdapter() {
        return new FDNavigatorAdapter();
    }
}

