/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.FDAdapter;
import com.iscobol.screenpainter.util.adapters.IFDListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ProjectWorkbenchAdapter;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.actions.ActionFactory;

public class FDListWorkbenchAdapter
extends PlatformObject
implements IscobolWorkbenchAdapter,
IscobolProjectAdapter,
IFDListWorkbenchAdapter {
    ActionFactory factory;
    private IProject project;
    private ProjectWorkbenchAdapter parent;
    private static final String LABEL = "fd";
    private int hashCode;

    public FDListWorkbenchAdapter(IProject iProject, ProjectWorkbenchAdapter projectWorkbenchAdapter) {
        this.project = iProject;
        this.parent = projectWorkbenchAdapter;
        this.hashCode = iProject.getFullPath().toPortableString().hashCode();
    }

    public boolean hasChildren() {
        return this.getFDs().length > 0;
    }

    public Object[] getChildren() {
        return this.getFDs();
    }

    public Image getImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/fdsl_list.png");
    }

    public ImageDescriptor getImageDescriptor() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/fdsl_list.png");
    }

    public String getLabel() {
        return LABEL;
    }

    public Object getParent() {
        return this.parent;
    }

    public IProject getProject() {
        return this.parent.getProject();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FDListWorkbenchAdapter)) {
            return false;
        }
        boolean bl = this.project.equals(((FDListWorkbenchAdapter)object).project);
        return bl;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IResource.class) {
            try {
                return PluginUtilities.getFDFolder((IProject)this.getProject());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return super.getAdapter(clazz);
    }

    public FDAdapter[] getFDs() {
        try {
            IContainer iContainer = PluginUtilities.getFDFolder((IProject)this.project);
            if (iContainer != null) {
                Vector<FDAdapter> vector = new Vector<FDAdapter>();
                IResource[] iResourceArray = iContainer.members();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    IFile iFile;
                    if (iResourceArray[i].getType() != 1 || (iFile = (IFile)iResourceArray[i]).getFileExtension() == null || !iFile.getFileExtension().equals("idl")) continue;
                    vector.addElement(new FDAdapter(iFile));
                }
                if (vector.size() > 0) {
                    return vector.toArray(new FDAdapter[vector.size()]);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new FDAdapter[0];
    }
}

