/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ProjectWorkbenchAdapter;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class FileListWorkbenchAdapter
extends PlatformObject
implements IscobolWorkbenchAdapter,
IscobolProjectAdapter {
    private IProject project;
    private int hashCode;
    private ProjectWorkbenchAdapter parent;
    private static final String LABEL = "file";

    public FileListWorkbenchAdapter(IProject iProject, ProjectWorkbenchAdapter projectWorkbenchAdapter) {
        this.project = iProject;
        this.parent = projectWorkbenchAdapter;
        this.hashCode = iProject.getFullPath().toPortableString().hashCode();
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public Object[] getChildren() {
        return this.getMembers();
    }

    public IResource[] getMembers() {
        Vector<IResource> vector = new Vector<IResource>();
        try {
            IResource[] iResourceArray = this.project.members();
            for (int i = 0; i < iResourceArray.length; ++i) {
                if (iResourceArray[i].getName().startsWith(".")) continue;
                if (iResourceArray[i].getType() == 2) {
                    if (PluginUtilities.isScreenFolder((IContainer)((IFolder)iResourceArray[i])) || PluginUtilities.isFDFolder((IContainer)((IFolder)iResourceArray[i]))) continue;
                    vector.addElement(iResourceArray[i]);
                    continue;
                }
                vector.addElement(iResourceArray[i]);
            }
            iResourceArray = new IResource[vector.size()];
            vector.toArray(iResourceArray);
            return iResourceArray;
        }
        catch (CoreException coreException) {
            return new IResource[0];
        }
    }

    public Image getImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/file_list.gif");
    }

    public ImageDescriptor getImageDescriptor() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/file_list.gif");
    }

    public String getLabel() {
        return LABEL;
    }

    public Object getParent() {
        return this.parent;
    }

    public IProject getProject() {
        return this.project;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileListWorkbenchAdapter)) {
            return false;
        }
        return this.project.equals(((FileListWorkbenchAdapter)object).project);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IProject.class) {
            return this.project;
        }
        return super.getAdapter(clazz);
    }
}

