/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.views.IIscobolProgramListProvider;
import com.iscobol.plugins.editor.views.IscobolProgramAdapter;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.IProgramListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ProjectWorkbenchAdapter;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.actions.ActionFactory;

public class ProgramListWorkbenchAdapter
extends PlatformObject
implements IscobolWorkbenchAdapter,
IscobolProjectAdapter,
IProgramListWorkbenchAdapter {
    private static final String LABEL = "structure";
    ActionFactory factory;
    private IProject project;
    private ProjectWorkbenchAdapter parent;
    private int hashCode;

    public ProgramListWorkbenchAdapter(IProject iProject, ProjectWorkbenchAdapter projectWorkbenchAdapter) {
        this.project = iProject;
        this.parent = projectWorkbenchAdapter;
        this.hashCode = iProject.getFullPath().toPortableString().hashCode();
    }

    public boolean hasChildren() {
        return this.getPrograms().length > 0;
    }

    public Object[] getChildren() {
        return this.getPrograms();
    }

    public Image getImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/program_list.gif");
    }

    public ImageDescriptor getImageDescriptor() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/program_list.gif");
    }

    public String getLabel() {
        return LABEL;
    }

    public Object getParent() {
        return this.parent;
    }

    public IProject getProject() {
        return this.parent.getProject();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProgramListWorkbenchAdapter)) {
            return false;
        }
        boolean bl = this.project.equals(((ProgramListWorkbenchAdapter)object).project);
        return bl;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IResource.class) {
            try {
                return PluginUtilities.getScreenFolder((IProject)this.getProject());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return super.getAdapter(clazz);
    }

    public IscobolProgramAdapter[] getPrograms() {
        try {
            IContainer iContainer = PluginUtilities.getScreenFolder((IProject)this.project);
            if (iContainer != null) {
                Vector<IscobolProgramAdapter> vector = new Vector<IscobolProgramAdapter>();
                IResource[] iResourceArray = iContainer.members();
                IIscobolProgramListProvider[] iIscobolProgramListProviderArray = IscobolEditorPlugin.getDefault().getProgramListProviders();
                block2: for (int i = 0; i < iResourceArray.length; ++i) {
                    if (iResourceArray[i].getType() != 1) continue;
                    IFile iFile = (IFile)iResourceArray[i];
                    for (IIscobolProgramListProvider iIscobolProgramListProvider : iIscobolProgramListProviderArray) {
                        IscobolProgramAdapter iscobolProgramAdapter = iIscobolProgramListProvider.getProgramAdapter(iFile);
                        if (iscobolProgramAdapter == null) continue;
                        vector.addElement(iscobolProgramAdapter);
                        continue block2;
                    }
                }
                if (vector.size() > 0) {
                    return vector.toArray(new IscobolProgramAdapter[vector.size()]);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new IscobolProgramAdapter[0];
    }
}

