/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.plugins.editor.views.IscobolNavigatorAdapter;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.FDListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.FileListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ProgramListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ProjectWorkbenchAdapter;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;

public class ProjectWorkbenchAdapter
extends PlatformObject
implements IscobolWorkbenchAdapter,
IscobolProjectAdapter,
IscobolNavigatorAdapter {
    private IProject project;
    private FileListWorkbenchAdapter fileList;
    private ProgramListWorkbenchAdapter programList;
    private FDListWorkbenchAdapter fdList;
    private int hashCode;

    public ProjectWorkbenchAdapter(IProject iProject) {
        this.project = iProject;
        this.fileList = new FileListWorkbenchAdapter(iProject, this);
        this.programList = new ProgramListWorkbenchAdapter(iProject, this);
        this.fdList = new FDListWorkbenchAdapter(iProject, this);
        this.hashCode = iProject.getFullPath().toPortableString().hashCode();
    }

    public Object[] getChildren() {
        return new Object[]{this.programList, this.fdList, this.fileList};
    }

    public boolean hasChildren() {
        return true;
    }

    public Image getImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/project.gif");
    }

    public ImageDescriptor getImageDescriptor() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/project.gif");
    }

    public String getLabel() {
        return this.project.getName();
    }

    public Object getParent() {
        return this.project.getParent();
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProjectWorkbenchAdapter)) {
            return false;
        }
        return this.project.equals(((ProjectWorkbenchAdapter)object).project);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public FileListWorkbenchAdapter getFileList() {
        return this.fileList;
    }

    public ProgramListWorkbenchAdapter getProgramList() {
        return this.programList;
    }

    public FDListWorkbenchAdapter getFdList() {
        return this.fdList;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IPropertySource.class) {
            return new ResourcePropertySource((IResource)this.getProject());
        }
        return super.getAdapter(clazz);
    }

    private DeleteResourceAction getDeleteResourceAction(IStructuredSelection iStructuredSelection) {
        DeleteResourceAction deleteResourceAction = new DeleteResourceAction((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        boolean bl = this.setSelection((SelectionListenerAction)deleteResourceAction, iStructuredSelection);
        if (bl) {
            return deleteResourceAction;
        }
        return null;
    }

    private RenameResourceAction getRenameResourceAction(IStructuredSelection iStructuredSelection) {
        RenameResourceAction renameResourceAction = new RenameResourceAction((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        boolean bl = this.setSelection((SelectionListenerAction)renameResourceAction, iStructuredSelection);
        if (bl) {
            return renameResourceAction;
        }
        return null;
    }

    private boolean setSelection(SelectionListenerAction selectionListenerAction, IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof ProjectWorkbenchAdapter)) {
                return false;
            }
            objectArray2[i] = ((ProjectWorkbenchAdapter)objectArray[i]).getProject();
        }
        iStructuredSelection = new StructuredSelection(objectArray2);
        IIscobolNavigator iIscobolNavigator = PluginUtilities.findDataNavigator();
        selectionListenerAction.selectionChanged(new SelectionChangedEvent((ISelectionProvider)(iIscobolNavigator != null ? iIscobolNavigator.getViewer() : null), (ISelection)iStructuredSelection));
        return true;
    }

    public void fillContextMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        RenameResourceAction renameResourceAction = this.getRenameResourceAction(iStructuredSelection);
        if (renameResourceAction != null) {
            renameResourceAction.setText("Rename...");
            iMenuManager.insertAfter("org.eclipse.ui.PasteAction", (IAction)renameResourceAction);
        }
        if ((renameResourceAction = this.getDeleteResourceAction(iStructuredSelection)) != null) {
            renameResourceAction.setImageDescriptor(IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/delete.gif"));
            iMenuManager.insertAfter("org.eclipse.ui.PasteAction", (IAction)renameResourceAction);
        }
        ActionContributionItem actionContributionItem = (ActionContributionItem)iMenuManager.find("org.eclipse.ui.PasteAction");
        ArrayList arrayList = new ArrayList();
        for (Object object : iStructuredSelection) {
            if (object == this) {
                object = this.getContainer();
            }
            if (object == null) continue;
            arrayList.add(object);
        }
        ((SelectionListenerAction)actionContributionItem.getAction()).selectionChanged((IStructuredSelection)new StructuredSelection(arrayList));
    }

    public IContainer getContainer() {
        return this.getProject();
    }

    public boolean handleKeyPressed(KeyEvent keyEvent, IStructuredSelection iStructuredSelection) {
        return false;
    }

    public boolean handleOpen(OpenEvent openEvent, IStructuredSelection iStructuredSelection) {
        return false;
    }

    public IscobolNavigatorAdapter getIscobolNavigatorAdapter() {
        return new MyIscobolNavigatorAdapter(this);
    }
}

