/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.reportdesigner.actions.DeleteReportAction;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.util.adapters.AbstractScreenProgramNavigatorAdapter;
import com.iscobol.screenpainter.util.adapters.ReportAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionAdapter;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.KeyEvent;

public class ReportNavigatorAdapter
extends AbstractScreenProgramNavigatorAdapter {
    private String reportName;

    protected boolean checkSelection(IStructuredSelection iStructuredSelection) {
        return true;
    }

    private boolean intCheckSelection(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        if (list.size() == 0) {
            return false;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() instanceof ReportAdapter) continue;
            return false;
        }
        return true;
    }

    private DeleteReportAction getAction(IStructuredSelection iStructuredSelection) {
        DeleteReportAction deleteReportAction = new DeleteReportAction();
        deleteReportAction.selectionChanged(null, (ISelection)iStructuredSelection);
        return deleteReportAction;
    }

    public void fillContextMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return;
        }
        DeleteReportAction deleteReportAction = this.getAction(iStructuredSelection);
        deleteReportAction.setText("Delete");
        deleteReportAction.setImageDescriptor(IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/delete.gif"));
        iMenuManager.insertAfter("org.eclipse.ui.PasteAction", (IAction)deleteReportAction);
    }

    public boolean handleKeyPressed(KeyEvent keyEvent, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return false;
        }
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
            DeleteReportAction deleteReportAction = this.getAction(iStructuredSelection);
            deleteReportAction.run();
            return true;
        }
        return false;
    }

    public boolean handleOpen(OpenEvent openEvent, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return false;
        }
        this.reportName = ((ReportAdapter)iStructuredSelection.getFirstElement()).getReport().getName();
        return super.handleOpen(openEvent, iStructuredSelection);
    }

    protected void activateEditorPage(ScreenProgramEditor screenProgramEditor) {
        if (screenProgramEditor != null && this.reportName != null) {
            screenProgramEditor.setCurrentReport(this.reportName);
        }
    }

    protected Class getAdaptableType() {
        return ScreenSectionAdapter.class;
    }
}

