/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.plugins.editor.views.IscobolNavigatorAdapter;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.EventParagraphsAdapter;
import com.iscobol.screenpainter.util.adapters.FileSectionAdapter;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import com.iscobol.screenpainter.util.adapters.LinkageSectionAdapter;
import com.iscobol.screenpainter.util.adapters.ReportListAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenProgramNavigatorAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionListAdapter;
import com.iscobol.screenpainter.util.adapters.WorkingStorageAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ScreenProgramAdapter
extends PlatformObject
implements IWorkbenchAdapter,
IscobolWorkbenchAdapter,
IscobolProjectAdapter,
IScreenProgramAdapter {
    private int hashCode;
    private IFile programFile;
    private ScreenSectionListAdapter ssList;
    private ReportListAdapter rptList;
    private WorkingStorageAdapter working;
    private LinkageSectionAdapter linkage;
    private FileSectionAdapter fileSection;
    private EventParagraphsAdapter eventPar;

    public ScreenProgramAdapter(IFile iFile) {
        this.programFile = iFile;
        this.hashCode = iFile.getFullPath().toPortableString().hashCode();
        this.ssList = new ScreenSectionListAdapter(this);
        this.rptList = new ReportListAdapter(this);
        this.working = new WorkingStorageAdapter(this);
        this.linkage = new LinkageSectionAdapter(this);
        this.fileSection = new FileSectionAdapter(this);
        this.eventPar = new EventParagraphsAdapter(this);
    }

    public ScreenSectionListAdapter getScreenList() {
        return this.ssList;
    }

    public ReportListAdapter getReportList() {
        return this.rptList;
    }

    public EventParagraphsAdapter getEventPar() {
        return this.eventPar;
    }

    public WorkingStorageAdapter getWorking() {
        return this.working;
    }

    public LinkageSectionAdapter getLinkage() {
        return this.linkage;
    }

    public FileSectionAdapter getFileSection() {
        return this.fileSection;
    }

    public Object[] getChildren() {
        return new Object[]{this.ssList, this.rptList, this.working, this.linkage, this.fileSection, this.eventPar};
    }

    public boolean hasChildren() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/program.png");
    }

    public String getLabel() {
        String string = this.programFile.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public IFile getProgramFile() {
        return this.programFile;
    }

    public Object getParent() {
        return this.programFile.getParent();
    }

    public Image getImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/program.png");
    }

    public ScreenProgram getScreenProgram() {
        return PluginUtilities.getScreenProgram((IFile)this.programFile);
    }

    public IProject getProject() {
        return this.programFile.getProject();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScreenProgramAdapter)) {
            return false;
        }
        return this.programFile.equals(((ScreenProgramAdapter)object).programFile);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Object[] getChildren(Object object) {
        return this.getChildren();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getImageDescriptor();
    }

    public String getLabel(Object object) {
        return this.getLabel();
    }

    public Object getParent(Object object) {
        return this.getParent();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IResource.class) {
            return this.programFile;
        }
        if (clazz == ScreenProgram.class) {
            return this.getScreenProgram();
        }
        return super.getAdapter(clazz);
    }

    public IscobolNavigatorAdapter getIscobolNavigatorAdapter() {
        return new ScreenProgramNavigatorAdapter();
    }

    public String getProgramName() {
        return this.getScreenProgram().getProgramName();
    }
}

