/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.adapters;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.actions.DeleteScreenSectionAction;
import com.iscobol.screenpainter.util.adapters.AbstractScreenProgramNavigatorAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionAdapter;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.KeyEvent;

public class ScreenSectionNavigatorAdapter
extends AbstractScreenProgramNavigatorAdapter {
    private String screenSectionName;

    protected boolean checkSelection(IStructuredSelection iStructuredSelection) {
        return true;
    }

    private boolean intCheckSelection(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        if (list.size() == 0) {
            return false;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() instanceof ScreenSectionAdapter) continue;
            return false;
        }
        return true;
    }

    private DeleteScreenSectionAction getAction(IStructuredSelection iStructuredSelection) {
        DeleteScreenSectionAction deleteScreenSectionAction = new DeleteScreenSectionAction();
        deleteScreenSectionAction.selectionChanged(null, (ISelection)iStructuredSelection);
        return deleteScreenSectionAction;
    }

    public void fillContextMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return;
        }
        DeleteScreenSectionAction deleteScreenSectionAction = this.getAction(iStructuredSelection);
        deleteScreenSectionAction.setText("Delete");
        deleteScreenSectionAction.setImageDescriptor(IscobolScreenPainterPlugin.getDefault().getImageProvider().getDescriptor("/delete.gif"));
        iMenuManager.insertAfter("org.eclipse.ui.PasteAction", (IAction)deleteScreenSectionAction);
    }

    public boolean handleKeyPressed(KeyEvent keyEvent, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return false;
        }
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
            DeleteScreenSectionAction deleteScreenSectionAction = this.getAction(iStructuredSelection);
            deleteScreenSectionAction.run();
            return true;
        }
        return false;
    }

    public boolean handleOpen(OpenEvent openEvent, IStructuredSelection iStructuredSelection) {
        if (!this.intCheckSelection(iStructuredSelection)) {
            return false;
        }
        this.screenSectionName = ((ScreenSectionAdapter)iStructuredSelection.getFirstElement()).getWindow().getName();
        return super.handleOpen(openEvent, iStructuredSelection);
    }

    protected void activateEditorPage(ScreenProgramEditor screenProgramEditor) {
        if (screenProgramEditor != null && this.screenSectionName != null) {
            screenProgramEditor.setCurrentScreenSection(this.screenSectionName);
        }
    }

    protected Class getAdaptableType() {
        return ScreenSectionAdapter.class;
    }
}

