/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.util.debug;

import com.iscobol.plugins.editor.debug.IDebugHelper;
import com.iscobol.plugins.editor.debug.IscobolBreakpoint;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;

public class DebugHelperImpl
implements IDebugHelper {
    private Map<IFile, int[]> cache = new HashMap();

    public String getFileName(IscobolBreakpoint iscobolBreakpoint) {
        ScreenProgram screenProgram;
        String string = iscobolBreakpoint.getFilename();
        if (string.endsWith("isp") && (screenProgram = PluginUtilities.getScreenProgram((IFile)((IFile)iscobolBreakpoint.getMarker().getResource()))) != null) {
            string = screenProgram.getSplitSource() ? screenProgram.getProgramName() + screenProgram.getEventFileSuffix() : screenProgram.getProgramName() + screenProgram.getProgramFileSuffix();
        }
        return string;
    }

    public int getLineNumber(IscobolBreakpoint iscobolBreakpoint) {
        ScreenProgram screenProgram;
        int n = iscobolBreakpoint.getLineNumber();
        String string = iscobolBreakpoint.getFilename();
        if (string.endsWith("isp") && (screenProgram = PluginUtilities.getScreenProgram((IFile)((IFile)iscobolBreakpoint.getMarker().getResource()))) != null) {
            int[] nArray = (int[])this.cache.get(screenProgram.getFile());
            if (nArray == null) {
                nArray = new int[]{0, -1};
                CodeGenerator codeGenerator = new CodeGenerator(screenProgram, true);
                codeGenerator.refreshFolders();
                StringBuilder stringBuilder = new StringBuilder();
                codeGenerator.generate(!screenProgram.getRegenerateTaggedAreaOnly(), stringBuilder);
                LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(stringBuilder.toString()));
                try {
                    String string2 = lineNumberReader.readLine();
                    while (string2 != null) {
                        if (string2.equals("      *> ##### EVENT PARAGRAPH HEADER #####")) {
                            nArray[1] = 0;
                        } else {
                            if (string2.equals("      *> ##### EVENT PARAGRAPH START #####")) {
                                nArray[0] = lineNumberReader.getLineNumber();
                                break;
                            }
                            if (nArray[1] >= 0) {
                                nArray[1] = nArray[1] + 1;
                            }
                        }
                        string2 = lineNumberReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.cache.put(screenProgram.getFile(), nArray);
            }
            n = screenProgram.getSplitSource() && !screenProgram.isAGenericCobolProgram() ? n + nArray[1] + 1 : n + nArray[0] - 1;
        }
        return n;
    }
}

