/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.views;

import com.iscobol.plugins.editor.findinobject.AbstractFindInObjectMatch;
import com.iscobol.plugins.editor.findinobject.FindInObjectResult;
import com.iscobol.screenpainter.ConsistencyCheckResult;
import com.iscobol.screenpainter.findinobject.FindInObjectMatch;
import com.iscobol.screenpainter.findinobject.FindInObjectResultViewer;
import com.iscobol.screenpainter.findinobject.FindInObjectUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsistencyCheckView
extends ViewPart
implements IUpdate {
    public static final String ID = "com.iscobol.screenpainter.views.ConsistencyCheck";
    private ConsistencyCheckResult consistencyCheckResult;
    private FindInObjectResultViewer resultViewer = new FindInObjectResultViewer((IUpdate)this);

    public void createPartControl(Composite composite) {
        this.resultViewer.createControl(composite);
    }

    public void setFocus() {
        this.resultViewer.setFocus();
    }

    public FindInObjectResult getConsistencyCheckResult() {
        return this.consistencyCheckResult;
    }

    public void setConsistencyCheckResult(ConsistencyCheckResult consistencyCheckResult) {
        this.consistencyCheckResult = consistencyCheckResult;
        Object[] objectArray = this.consistencyCheckResult != null ? this.consistencyCheckResult.getMatches() : new FindInObjectMatch[]{};
        this.resultViewer.setInput((AbstractFindInObjectMatch[])objectArray, -1);
    }

    private String getLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.consistencyCheckResult != null) {
            stringBuilder.append("Checked '" + FindInObjectUtilities.getLabelFor((Object)this.consistencyCheckResult.getTarget()));
            stringBuilder.append("': ");
            stringBuilder.append(this.consistencyCheckResult.getMatchCount());
            stringBuilder.append(" error");
            if (this.consistencyCheckResult.getMatchCount() != 1) {
                stringBuilder.append("s");
            }
        } else {
            stringBuilder.append("0 errors");
        }
        stringBuilder.append(" found");
        return stringBuilder.toString();
    }

    public void update() {
        this.setContentDescription(this.getLabel());
    }
}

