/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.wizards.AcubenchProgramFromProjectImportPage;
import com.iscobol.screenpainter.wizards.AcubenchProgramImportPage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class AcubenchProgramFromProjectImportPage
extends AcubenchProgramImportPage {
    private Map<File, AcubenchProgramInfo> programInfos = new HashMap();

    public AcubenchProgramFromProjectImportPage(String string, String string2) {
        super(string, string2);
    }

    protected void loadFileTree(File file) {
        File[] fileArray = PluginUtilities.listFiles((File)file, (FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree.removeAll();
        Image image = IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/gen_project.gif");
        for (File file2 : fileArray) {
            TreeItem treeItem = new TreeItem(this.fileTree, 0);
            String string = this.getFileTreeItemText(file2.getName());
            treeItem.setText(string);
            treeItem.setData((Object)file2);
            treeItem.setImage(image);
            for (AcubenchProgramInfo acubenchProgramInfo : this.loadProjectInfo(file2)) {
                TreeItem treeItem2 = new TreeItem(treeItem, 0);
                string = this.getFileTreeItemText(acubenchProgramInfo.programFile.getName());
                treeItem2.setText(string);
                treeItem2.setData((Object)acubenchProgramInfo.programFile);
                treeItem2.setImage(this.getFileTreeItemImage());
                this.programInfos.put(acubenchProgramInfo.programFile, acubenchProgramInfo);
            }
        }
        this.progNames = null;
        this.validatePage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AcubenchProgramInfo[] loadProjectInfo(File file) {
        LinkedHashMap<String, AcubenchProgramInfo> linkedHashMap = new LinkedHashMap<String, AcubenchProgramInfo>();
        UpperCaseReader upperCaseReader = null;
        try {
            upperCaseReader = new UpperCaseReader(this, (Reader)new InputStreamReader(new FileInputStream(file)));
            String string = file.getName();
            string = string.substring(0, string.length() - 4).toUpperCase();
            String string2 = "[PROGRAM_CONTENT-" + string + ":PROGRAM";
            String string3 = "[FILE_CONTENT-" + string + ":FILE";
            AcubenchProgramInfo acubenchProgramInfo = null;
            String string4 = upperCaseReader.readUpperCaseLine();
            while (string4 != null) {
                Object object;
                String string5;
                if (string4.startsWith(string2)) {
                    acubenchProgramInfo = new AcubenchProgramInfo(null);
                    string4 = upperCaseReader.readUpperCaseLine();
                    if (string4 != null && string4.startsWith("RELATIVE_PATH=")) {
                        string5 = string4.substring("RELATIVE_PATH=".length());
                        object = new File(string5);
                        if (!((File)object).isAbsolute() && !string5.startsWith(File.separator)) {
                            object = new File(file.getParent() + File.separator + object);
                        }
                        acubenchProgramInfo.programFile = object;
                        linkedHashMap.put(string5, acubenchProgramInfo);
                    }
                } else if (string4.startsWith(string3)) {
                    String string6;
                    string4 = upperCaseReader.readUpperCaseLine();
                    string5 = upperCaseReader.readUpperCaseLine();
                    object = upperCaseReader.readUpperCaseLine();
                    if (string4 != null && string4.startsWith("RELATIVE_PATH=") && "FOLDER_NAME=SOURCE".equals(string5) && object != null && ((String)object).startsWith("OWNER_PATH=") && (acubenchProgramInfo = (AcubenchProgramInfo)linkedHashMap.get(string6 = ((String)object).substring("OWNER_PATH=".length()))) != null) {
                        String string7 = string4.substring("RELATIVE_PATH=".length());
                        File file2 = new File(string7);
                        if (!file2.isAbsolute() && !string7.startsWith(File.separator)) {
                            file2 = new File(file.getParent() + File.separator + file2);
                        }
                        acubenchProgramInfo.sourceProgramFile = file2;
                    }
                }
                string4 = upperCaseReader.readUpperCaseLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (upperCaseReader != null) {
                try {
                    upperCaseReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return linkedHashMap.values().toArray(new AcubenchProgramInfo[linkedHashMap.size()]);
    }

    protected void handleFileTreeSelection(SelectionEvent selectionEvent) {
        TreeItem treeItem = (TreeItem)selectionEvent.item;
        boolean bl = treeItem.getChecked();
        PluginUtilities.checkItems((TreeItem)treeItem, (boolean)bl);
        PluginUtilities.checkPath((TreeItem)treeItem.getParentItem(), (boolean)bl, (boolean)false);
        super.handleFileTreeSelection(selectionEvent);
    }

    protected void createTaggedAreaControls(Composite composite, int n) {
        this.importSourceBtn = new Button(composite, 32);
        this.importSourceBtn.setText(ISPBundle.getString((String)"import_source_with_tagged_lbl"));
        this.importSourceBtn.setSelection(this.importSource);
        this.importSourceBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        this.importSourceBtn.setLayoutData((Object)gridData);
    }

    protected void activateEditor(TreeItem treeItem) {
        if (treeItem.getParentItem() == null) {
            return;
        }
        super.activateEditor(treeItem);
    }

    protected void setProgramFiles() {
        Vector<String> vector = new Vector<String>();
        Vector<File> vector2 = new Vector<File>();
        for (TreeItem treeItem : this.fileTree.getItems()) {
            if (!treeItem.getChecked()) continue;
            for (TreeItem treeItem2 : treeItem.getItems()) {
                if (!treeItem2.getChecked()) continue;
                vector.addElement(treeItem2.getText());
                vector2.addElement((File)treeItem2.getData());
            }
        }
        if (vector2.size() == 0) {
            this.progNames = null;
            this.progFiles = null;
        } else {
            this.progNames = vector.toArray(new String[vector.size()]);
            this.progFiles = vector2.toArray(new File[vector2.size()]);
            vector2.toArray(this.progFiles);
        }
    }

    protected void afterImportOperations(ScreenProgram screenProgram, File file) {
        String string;
        String string2;
        int n;
        super.afterImportOperations(screenProgram, file);
        AcubenchProgramInfo acubenchProgramInfo = (AcubenchProgramInfo)this.programInfos.get(file);
        if (acubenchProgramInfo != null && acubenchProgramInfo.sourceProgramFile != null && (n = (string2 = acubenchProgramInfo.sourceProgramFile.getName()).lastIndexOf(46)) >= 0 && !(string = string2.substring(n)).equalsIgnoreCase(screenProgram.getProgramFileSuffix())) {
            screenProgram.setFollowDefaultFlag(false);
            screenProgram.setProgramFileSuffix(string);
        }
    }

    protected String getSourceDir(File file) {
        AcubenchProgramInfo acubenchProgramInfo = (AcubenchProgramInfo)this.programInfos.get(file);
        if (acubenchProgramInfo != null && acubenchProgramInfo.sourceProgramFile != null) {
            return acubenchProgramInfo.sourceProgramFile.getParentFile().getAbsolutePath();
        }
        return super.getSourceDir(file);
    }

    public boolean validateFileName(String string) {
        return string.toLowerCase().endsWith(".pjt");
    }
}

