/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.programimport.ImpAcb;
import com.iscobol.screenpainter.wizards.AbstractProgramImportPage;
import java.io.File;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AcubenchProgramImportPage
extends AbstractProgramImportPage {
    static final int PROMPT_WHEN_PROGRAM_EXITS_NONE = 0;
    static final int PROMPT_WHEN_PROGRAM_EXITS_YES = 1;
    static final int PROMPT_WHEN_PROGRAM_EXITS_NO = 2;
    static final String SOURCE_FORMAT_ANSI = "ANSI";
    static final String SOURCE_FORMAT_TERMINAL = "Terminal";
    private Button changeCellSizeBtn;
    private Text cellWidthFactTxt;
    private Text cellHeightFactTxt;
    private Text leftTextAddWidthTxt;
    private Label cellWidthFactLbl;
    private Label cellHeightFactLbl;
    private Label leftTextAddWidthLbl;
    private float cellWidthFact = this.getLastCellWidthFactor();
    private float cellHeightFact = this.getLastCellHeightFactor();
    private int leftTextAdditionalWidth = this.getLastLeftTextAdditionalWidth();
    private boolean changeCellSizeEnabled = this.getLastChangeCellSizeEnabled();
    private String changeSourceFormat = this.getLastChangeSourceFormat();
    private int promptWhenProgramExits = this.getLastPromptWhenProgramExits();
    private CCombo promptWPECmb;
    private Button changeSourceFormatBtn;
    private Button ansiFormat;
    private Button terminalFormat;
    protected Button importSourceBtn;
    protected boolean importSource = this.getLastImportSourceEnabled();
    private Text sourceDirTxt;
    private Label sourceDirLbl;
    private Button sourceBrowseBtn;
    private String sourceDir = this.importSource ? this.getLastTaggedSourceImportDirectory() : "";
    private boolean refreshFolders = true;

    public AcubenchProgramImportPage(String string, String string2) {
        super(string, string2);
    }

    protected boolean hasTaggedAreaControls() {
        return true;
    }

    protected void createTaggedAreaControls(Composite composite, int n) {
        this.importSourceBtn = new Button(composite, 32);
        this.importSourceBtn.setText(ISPBundle.getString((String)"import_source_with_tagged_lbl"));
        this.importSourceBtn.setSelection(this.importSource);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        this.importSourceBtn.setLayoutData((Object)gridData);
        this.sourceDirLbl = new Label(composite, 0);
        this.sourceDirLbl.setText("Directory:");
        this.sourceDirLbl.setEnabled(this.importSource);
        this.sourceDirTxt = new Text(composite, 2048);
        this.sourceDirTxt.setEnabled(this.importSource);
        gridData = new GridData(768);
        this.sourceDirTxt.setLayoutData((Object)gridData);
        if (this.importSource) {
            this.sourceDirTxt.setText(this.sourceDir);
        }
        this.sourceBrowseBtn = new Button(composite, 8);
        this.sourceBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.sourceBrowseBtn.setEnabled(this.importSource);
        this.importSourceBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceDirTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.sourceBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean importProgramInfo0(ScreenProgram screenProgram, File file) {
        ImpAcb impAcb = new ImpAcb();
        impAcb.setCellHeightFact(this.cellHeightFact);
        impAcb.setCellWidthFact(this.cellWidthFact);
        boolean bl = impAcb.importProject(screenProgram, file);
        this.afterImportOperations(screenProgram, file);
        if (bl && this.importSource) {
            CodeGenerator codeGenerator = new CodeGenerator(screenProgram);
            if (this.refreshFolders) {
                codeGenerator.refreshFolders();
                this.refreshFolders = false;
            }
            codeGenerator.setTaggedSourceDir(this.getSourceDir(file));
            codeGenerator.generate(screenProgram.getProgramNamingConvention());
        }
        return bl;
    }

    protected void afterImportOperations(ScreenProgram screenProgram, File file) {
        if (this.promptWhenProgramExits != 0) {
            screenProgram.setPromptWhenProgramExits(this.promptWhenProgramExits == 1);
        }
        if (this.changeSourceFormat.length() > 0) {
            screenProgram.setFollowDefaultFlag(false);
            screenProgram.setAnsiFormat(this.changeSourceFormat.equals(SOURCE_FORMAT_ANSI));
        }
    }

    protected String getSourceDir(File file) {
        return this.sourceDir;
    }

    protected void setLastCellWidthFactor(float f) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.cellWidthFactor", f);
    }

    protected float getLastCellWidthFactor() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getFloat("iscobol.cellWidthFactor");
    }

    protected boolean getLastChangeCellSizeEnabled() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.changeCellSizeEn");
    }

    protected void setLastChangeCellSizeEnabled(boolean bl) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.changeCellSizeEn", bl);
    }

    protected String getLastChangeSourceFormat() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getString("iscobol.changeSourceFormat");
    }

    protected void setLastChangeSourceFormat(String string) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.changeSourceFormat", string);
    }

    protected void setLastCellHeightFactor(float f) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.cellHeightFactor", f);
    }

    protected float getLastCellHeightFactor() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getFloat("iscobol.cellHeightFactor");
    }

    protected void setLastLeftTextAdditionalWidth(int n) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.lefttextaddwidth", n);
    }

    protected int getLastLeftTextAdditionalWidth() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getInt("iscobol.lefttextaddwidth");
    }

    protected void setLastPromptWhenProgramExits(int n) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.promptWhenProgramExits", n);
    }

    protected int getLastPromptWhenProgramExits() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getInt("iscobol.promptWhenProgramExits");
    }

    protected String getLastTaggedSourceImportDirectory() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getString("iscobol.TaggedImportDirectory");
    }

    protected void setLastTaggedSourceImportDirectory(String string) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.TaggedImportDirectory", string);
    }

    protected void setLastImportSourceEnabled(boolean bl) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.importcobolsource", bl);
    }

    protected boolean getLastImportSourceEnabled() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.importcobolsource");
    }

    public String getChangeSourceFormat() {
        return this.changeSourceFormat;
    }

    public float getCellWidthFactor() {
        return this.changeCellSizeEnabled ? this.cellWidthFact : 1.0f;
    }

    public float getCellHeightFactor() {
        return this.changeCellSizeEnabled ? this.cellHeightFact : 1.0f;
    }

    public int getPromptWhenProgramExits() {
        return this.promptWhenProgramExits;
    }

    public boolean validateFileName(String string) {
        return string.toLowerCase().endsWith(".psf") || string.toLowerCase().endsWith(".cpf");
    }

    protected Image getFileTreeItemImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/program.png");
    }

    protected boolean hasAdvancedControls() {
        return true;
    }

    protected void createAdvancedControls(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        this.changeCellSizeBtn = new Button(composite, 32);
        this.changeCellSizeBtn.setText("Change the original cell size");
        this.changeCellSizeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.changeCellSizeBtn.setLayoutData((Object)gridData);
        this.changeCellSizeBtn.setSelection(this.changeCellSizeEnabled);
        this.cellWidthFactLbl = new Label(composite, 0);
        this.cellWidthFactLbl.setText("Cell Width Factor");
        this.cellWidthFactTxt = new Text(composite, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.cellWidthFactTxt.setLayoutData((Object)gridData);
        this.cellWidthFactTxt.setText("" + this.cellWidthFact);
        this.cellWidthFactTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cellWidthFactLbl.setEnabled(this.changeCellSizeEnabled);
        this.cellWidthFactTxt.setEnabled(this.changeCellSizeEnabled);
        this.cellHeightFactLbl = new Label(composite, 0);
        this.cellHeightFactLbl.setText("Cell Height Factor");
        this.cellHeightFactTxt = new Text(composite, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.cellHeightFactTxt.setLayoutData((Object)gridData);
        this.cellHeightFactTxt.setText("" + this.cellHeightFact);
        this.cellHeightFactTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cellHeightFactLbl.setEnabled(this.changeCellSizeEnabled);
        this.cellHeightFactTxt.setEnabled(this.changeCellSizeEnabled);
        Composite composite2 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        composite2.setLayoutData((Object)gridData);
        this.leftTextAddWidthLbl = new Label(composite2, 0);
        this.leftTextAddWidthLbl.setText("Left-Text Check Box/Radio Button additional width");
        this.leftTextAddWidthTxt = new Text(composite2, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.leftTextAddWidthTxt.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Pixels");
        this.leftTextAddWidthTxt.setText(String.valueOf(this.leftTextAdditionalWidth));
        this.leftTextAddWidthTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        label = new Label(composite, 0);
        label.setText("Prompt when program exits");
        this.promptWPECmb = new CCombo(composite, 2056);
        this.promptWPECmb.add("None");
        this.promptWPECmb.add("Yes");
        this.promptWPECmb.add("No");
        this.promptWPECmb.select(this.promptWhenProgramExits);
        this.promptWPECmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 100;
        this.promptWPECmb.setLayoutData((Object)gridData);
        this.changeSourceFormatBtn = new Button(composite, 32);
        this.changeSourceFormatBtn.setText("Change the original cobol source format");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.changeSourceFormatBtn.setLayoutData((Object)gridData);
        composite2 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData();
        composite2.setLayoutData((Object)gridData);
        this.ansiFormat = new Button(composite2, 16);
        this.ansiFormat.setText(SOURCE_FORMAT_ANSI);
        this.ansiFormat.setSelection(this.changeSourceFormat.equals(SOURCE_FORMAT_ANSI));
        this.terminalFormat = new Button(composite2, 16);
        this.terminalFormat.setText(SOURCE_FORMAT_TERMINAL);
        this.terminalFormat.setSelection(this.changeSourceFormat.equals(SOURCE_FORMAT_TERMINAL));
        if (this.changeSourceFormat.length() > 0) {
            this.changeSourceFormatBtn.setSelection(true);
        } else {
            this.changeSourceFormatBtn.setSelection(false);
            this.ansiFormat.setEnabled(false);
            this.terminalFormat.setEnabled(false);
            this.ansiFormat.setSelection(true);
        }
        this.changeSourceFormatBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.ansiFormat.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.terminalFormat.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean validatePage() {
        if (this.changeCellSizeEnabled) {
            if (this.cellWidthFact <= 0.0f) {
                this.setPageInvalid("Invalid value of 'Cell Width Factor'");
                return false;
            }
            if (this.cellHeightFact <= 0.0f) {
                this.setPageInvalid("Invalid value of 'Cell Height Factor'");
                return false;
            }
        }
        if (this.leftTextAdditionalWidth < 0) {
            this.setPageInvalid("Invalid value of 'Left-Text Check Box/Radio Button additional width'");
            return false;
        }
        return super.validatePage();
    }

    protected boolean getCreateLinks() {
        return false;
    }

    static /* synthetic */ Label access$000(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.sourceDirLbl;
    }

    static /* synthetic */ Text access$100(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.sourceDirTxt;
    }

    static /* synthetic */ Button access$200(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.sourceBrowseBtn;
    }

    static /* synthetic */ String access$302(AcubenchProgramImportPage acubenchProgramImportPage, String string) {
        acubenchProgramImportPage.sourceDir = string;
        return acubenchProgramImportPage.sourceDir;
    }

    static /* synthetic */ boolean access$402(AcubenchProgramImportPage acubenchProgramImportPage, boolean bl) {
        acubenchProgramImportPage.changeCellSizeEnabled = bl;
        return acubenchProgramImportPage.changeCellSizeEnabled;
    }

    static /* synthetic */ Button access$500(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.changeCellSizeBtn;
    }

    static /* synthetic */ boolean access$400(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.changeCellSizeEnabled;
    }

    static /* synthetic */ Text access$600(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.cellWidthFactTxt;
    }

    static /* synthetic */ Text access$700(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.cellHeightFactTxt;
    }

    static /* synthetic */ Label access$800(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.cellHeightFactLbl;
    }

    static /* synthetic */ Label access$900(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.cellWidthFactLbl;
    }

    static /* synthetic */ float access$1002(AcubenchProgramImportPage acubenchProgramImportPage, float f) {
        acubenchProgramImportPage.cellWidthFact = f;
        return acubenchProgramImportPage.cellWidthFact;
    }

    static /* synthetic */ float access$1000(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.cellWidthFact;
    }

    static /* synthetic */ float access$1102(AcubenchProgramImportPage acubenchProgramImportPage, float f) {
        acubenchProgramImportPage.cellHeightFact = f;
        return acubenchProgramImportPage.cellHeightFact;
    }

    static /* synthetic */ float access$1100(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.cellHeightFact;
    }

    static /* synthetic */ int access$1202(AcubenchProgramImportPage acubenchProgramImportPage, int n) {
        acubenchProgramImportPage.leftTextAdditionalWidth = n;
        return acubenchProgramImportPage.leftTextAdditionalWidth;
    }

    static /* synthetic */ Text access$1300(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.leftTextAddWidthTxt;
    }

    static /* synthetic */ int access$1200(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.leftTextAdditionalWidth;
    }

    static /* synthetic */ int access$1402(AcubenchProgramImportPage acubenchProgramImportPage, int n) {
        acubenchProgramImportPage.promptWhenProgramExits = n;
        return acubenchProgramImportPage.promptWhenProgramExits;
    }

    static /* synthetic */ CCombo access$1500(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.promptWPECmb;
    }

    static /* synthetic */ int access$1400(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.promptWhenProgramExits;
    }

    static /* synthetic */ Button access$1600(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.changeSourceFormatBtn;
    }

    static /* synthetic */ Button access$1700(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.ansiFormat;
    }

    static /* synthetic */ Button access$1800(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.terminalFormat;
    }

    static /* synthetic */ String access$1902(AcubenchProgramImportPage acubenchProgramImportPage, String string) {
        acubenchProgramImportPage.changeSourceFormat = string;
        return acubenchProgramImportPage.changeSourceFormat;
    }

    static /* synthetic */ String access$1900(AcubenchProgramImportPage acubenchProgramImportPage) {
        return acubenchProgramImportPage.changeSourceFormat;
    }
}

