/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractButton;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.wizards.AbstractProgramImportPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class IscobolScreenProgramImportPage
extends AbstractProgramImportPage {
    private Button _2013R1CompatibilityBtn;
    private boolean _2013R1Compatibility = this.getLast2013R1Compatibility();
    private Button _2016R2CompatibilityBtn;
    private boolean _2016R2Compatibility = this.getLast2016R2Compatibility();
    private Button createLinksBtn;
    private boolean createLinks;

    public IscobolScreenProgramImportPage(String string, String string2) {
        super(string, string2);
    }

    protected boolean hasAdvancedControls() {
        return true;
    }

    protected void createAdvancedControls(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        this._2013R1CompatibilityBtn = new Button(composite, 32);
        this._2013R1CompatibilityBtn.setText("IDE 2013 R1 compatibility");
        this._2013R1CompatibilityBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this._2013R1CompatibilityBtn.setSelection(this._2013R1Compatibility);
        this._2016R2CompatibilityBtn = new Button(composite, 32);
        this._2016R2CompatibilityBtn.setText("IDE 2016 R2 compatibility");
        this._2016R2CompatibilityBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this._2016R2CompatibilityBtn.setSelection(this._2016R2Compatibility);
        this.createLinksBtn = new Button(composite, 32);
        this.createLinksBtn.setText(IsresourceBundle.getString((String)"create_links_lbl"));
        this.createLinksBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean getLast2013R1Compatibility() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.2013r1comp");
    }

    protected void setLast2013R1Compatibility(boolean bl) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.2013r1comp", bl);
    }

    protected boolean getLast2016R2Compatibility() {
        return IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.2016r2comp");
    }

    protected void setLast2016R2Compatibility(boolean bl) {
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.2016r2comp", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean importProgramInfo0(ScreenProgram screenProgram, File file) {
        boolean bl;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            screenProgram.load((InputStream)fileInputStream);
            if (!this.checkRelease(screenProgram.getIscobolRelease(true), screenProgram.getProgramName())) {
                boolean bl2 = false;
                return bl2;
            }
            if (this._2013R1Compatibility) {
                this.adjustButtonsDimension(screenProgram);
            }
            if (this._2016R2Compatibility) {
                this.adjustScreenLocation(screenProgram);
            }
            bl = true;
        }
        catch (IOException iOException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private void adjustButtonsDimension(ScreenProgram screenProgram) {
        for (AbstractBeanWindow abstractBeanWindow : screenProgram.getScreenSections()) {
            this.adjustButtonsDimension(abstractBeanWindow.getComponents());
            for (IToolbar iToolbar : abstractBeanWindow.getToolbars()) {
                if (!(iToolbar instanceof AbstractBeanToolbar)) continue;
                this.adjustButtonsDimension(((AbstractBeanToolbar)iToolbar).getComponents());
            }
        }
    }

    private void adjustScreenLocation(ScreenProgram screenProgram) {
        for (AbstractBeanWindow abstractBeanWindow : screenProgram.getScreenSections()) {
            if (abstractBeanWindow.getScreenLine() == 5.0f) {
                abstractBeanWindow.setScreenLine(0.0f);
            }
            if (abstractBeanWindow.getScreenColumn() != 10.0f) continue;
            abstractBeanWindow.setScreenColumn(0.0f);
        }
    }

    private void adjustButtonsDimension(AbstractBeanControl[] abstractBeanControlArray) {
        for (AbstractBeanControl abstractBeanControl : abstractBeanControlArray) {
            if (abstractBeanControl instanceof AbstractButton) {
                this.adjustDimension((AbstractButton)abstractBeanControl);
                continue;
            }
            if (abstractBeanControl instanceof AbstractTabbedPane) {
                for (TabPage tabPage : ((AbstractTabbedPane)abstractBeanControl).getPages()) {
                    this.adjustButtonsDimension(tabPage.getComponents());
                }
                continue;
            }
            if (!(abstractBeanControl instanceof ComponentsContainer)) continue;
            this.adjustButtonsDimension(((ComponentsContainer)abstractBeanControl).getComponents());
        }
    }

    private void adjustDimension(AbstractButton abstractButton) {
        if (abstractButton.getBitmap() != null) {
            if (this.isSizeDefault(abstractButton)) {
                abstractButton.setSizePixels(Math.round(abstractButton.getSizePixels() - 8.0f));
            }
            if (this.isLinesDefault(abstractButton)) {
                abstractButton.setLinesPixels(Math.round(abstractButton.getLinesPixels() - 8.0f));
            }
        }
    }

    private boolean isSizeDefault(AbstractButton abstractButton) {
        return !abstractButton.isSizeUnitPixel() && abstractButton.getSizeUnit().getValue() != 2 && !abstractButton.getWidthInCells();
    }

    private boolean isLinesDefault(AbstractButton abstractButton) {
        return !abstractButton.isLinesUnitPixel() && abstractButton.getLinesUnit().getValue() != 2 && !abstractButton.getHeightInCells();
    }

    public boolean validateFileName(String string) {
        return string.endsWith(".isp");
    }

    protected Image getFileTreeItemImage() {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/program.png");
    }

    protected boolean getCreateLinks() {
        return this.createLinks;
    }

    static /* synthetic */ boolean access$002(IscobolScreenProgramImportPage iscobolScreenProgramImportPage, boolean bl) {
        iscobolScreenProgramImportPage._2013R1Compatibility = bl;
        return iscobolScreenProgramImportPage._2013R1Compatibility;
    }

    static /* synthetic */ Button access$100(IscobolScreenProgramImportPage iscobolScreenProgramImportPage) {
        return iscobolScreenProgramImportPage._2013R1CompatibilityBtn;
    }

    static /* synthetic */ boolean access$000(IscobolScreenProgramImportPage iscobolScreenProgramImportPage) {
        return iscobolScreenProgramImportPage._2013R1Compatibility;
    }

    static /* synthetic */ boolean access$202(IscobolScreenProgramImportPage iscobolScreenProgramImportPage, boolean bl) {
        iscobolScreenProgramImportPage._2016R2Compatibility = bl;
        return iscobolScreenProgramImportPage._2016R2Compatibility;
    }

    static /* synthetic */ Button access$300(IscobolScreenProgramImportPage iscobolScreenProgramImportPage) {
        return iscobolScreenProgramImportPage._2016R2CompatibilityBtn;
    }

    static /* synthetic */ boolean access$200(IscobolScreenProgramImportPage iscobolScreenProgramImportPage) {
        return iscobolScreenProgramImportPage._2016R2Compatibility;
    }

    static /* synthetic */ boolean access$402(IscobolScreenProgramImportPage iscobolScreenProgramImportPage, boolean bl) {
        iscobolScreenProgramImportPage.createLinks = bl;
        return iscobolScreenProgramImportPage.createLinks;
    }

    static /* synthetic */ Button access$500(IscobolScreenProgramImportPage iscobolScreenProgramImportPage) {
        return iscobolScreenProgramImportPage.createLinksBtn;
    }
}

