/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class IscobolScreenProgramPropertiesImportExportPage
extends WizardPage {
    private IStructuredSelection selection;
    private Tree tree;
    private boolean existsProjects;
    protected IFile screenProgramFile;

    public IscobolScreenProgramPropertiesImportExportPage(String string, IStructuredSelection iStructuredSelection, boolean bl) {
        super(string, (bl ? "Import" : "Export") + " Screen Program Properties", null);
        this.selection = iStructuredSelection;
    }

    public IFile getScreenProgramFile() {
        return this.screenProgramFile;
    }

    private boolean validatePage() {
        if (!this.existsProjects) {
            this.setPageInvalid(IsresourceBundle.getString((String)"no_projects_msg"));
            return false;
        }
        boolean bl = this.validateParent();
        if (bl) {
            this.setPageValid();
        }
        return bl;
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    private boolean validateParent() {
        if (this.screenProgramFile == null) {
            this.setPageInvalid("No Program selected");
            return false;
        }
        return true;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Select Screen Program");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.tree = new Tree(composite2, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 80;
        this.tree.setLayoutData((Object)gridData);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray != null) {
            for (IProject iProject : iProjectArray) {
                if (!iProject.isOpen() || !this.isIscobolProject(iProject)) continue;
                this.existsProjects = true;
                TreeItem treeItem = new TreeItem(this.tree, 0);
                treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/project.gif"));
                treeItem.setText(iProject.getName());
                treeItem.setData((Object)iProject);
                try {
                    IContainer iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
                    if (iContainer == null) continue;
                    IResource[] iResourceArray = iContainer.members();
                    for (int i = 0; i < iResourceArray.length; ++i) {
                        IFile iFile;
                        if (iResourceArray[i].getType() != 1 || (iFile = (IFile)iResourceArray[i]).getFileExtension() == null || !iFile.getFileExtension().equals("isp")) continue;
                        TreeItem treeItem2 = new TreeItem(treeItem, 0);
                        treeItem2.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/program.png"));
                        treeItem2.setText(iFile.getName().substring(0, iFile.getName().lastIndexOf(46)));
                        treeItem2.setData((Object)iFile);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.selection.isEmpty() && this.selection.getFirstElement() instanceof IScreenProgramAdapter) {
            this.select(((IScreenProgramAdapter)this.selection.getFirstElement()).getProgramFile(), null);
        }
        this.validatePage();
    }

    private boolean select(IFile iFile, TreeItem treeItem) {
        TreeItem[] treeItemArray;
        for (TreeItem treeItem2 : treeItemArray = treeItem != null ? treeItem.getItems() : this.tree.getItems()) {
            if (treeItem2.getData() instanceof IFile && treeItem2.getData().equals(iFile)) {
                this.tree.setSelection(treeItem2);
                this.screenProgramFile = iFile;
                return true;
            }
            if (!this.select(iFile, treeItem2)) continue;
            return true;
        }
        return false;
    }

    private boolean isIscobolProject(IProject iProject) {
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ boolean access$000(IscobolScreenProgramPropertiesImportExportPage iscobolScreenProgramPropertiesImportExportPage) {
        return iscobolScreenProgramPropertiesImportExportPage.validatePage();
    }
}

