/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.wizards.FileSelectionWizardPage;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.AlphabetList;
import com.iscobol.screenpainter.beans.types.Repository;
import com.iscobol.screenpainter.util.BeanReader;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.wizards.IscobolScreenProgramPropertiesImportExportPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class IscobolScreenProgramPropertiesImportWizard
extends Wizard
implements IImportWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IscobolScreenProgramPropertiesImportExportPage page1;
    private FileSelectionWizardPage page2;

    public IscobolScreenProgramPropertiesImportWizard() {
        this.setWindowTitle("Import Screen Program Properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        IFile iFile = this.page1.getScreenProgramFile();
        if (iFile == null) {
            return false;
        }
        String string = this.page2.getFileName();
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        try (BeanReader beanReader = null;){
            ScreenProgram screenProgram = PluginUtilities.getScreenProgram((IFile)iFile);
            beanReader = new BeanReader((InputStream)new FileInputStream(file));
            try {
                screenProgram.getResourceRegistry().setRepository((Repository)beanReader.readObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                screenProgram.setAlphabets((AlphabetList)beanReader.readObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string2 = screenProgram.getMainScreen();
            String string3 = screenProgram.getRemarks();
            int n = screenProgram.getProgramIdClause();
            boolean bl = screenProgram.getPromptWhenProgramExits();
            try {
                screenProgram.setProperties((Hashtable)beanReader.readObject());
                screenProgram.setMainScreen(string2);
                screenProgram.setRemarks(string3);
                screenProgram.setProgramIdClause(n);
                screenProgram.setPromptWhenProgramExits(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PluginUtilities.markEditorDirtyOrSave((ScreenProgram)screenProgram);
        }
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    public void addPages() {
        this.page1 = new IscobolScreenProgramPropertiesImportExportPage(IscobolScreenProgramPropertiesImportExportPage.class.getName(), this.selection, true);
        this.page1.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new FileSelectionWizardPage("IscobolScreenProgramPropertiesImportPage2", "Import Screen Program Properties", IsresourceBundle.getString((String)"src_propfile_lbl") + ":", IsresourceBundle.getString((String)"sel_propfile_lbl"), new String[]{"*.ispp", "*.*"}, false);
        this.page2.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page2);
        this.page2.setPreviousPage((IWizardPage)this.page1);
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }
}

