/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionAdapter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class IscobolScreenSectionExportPage
extends WizardPage {
    private static final String ELEMENT = "element";
    private static final String LIST = "list";
    private static final String RELEASE = "release";
    private IStructuredSelection selection;
    private Tree tree;
    private AbstractBeanWindow screenSection;
    private String iscobolRelease;
    private static final Pattern SCREEN_PATTERN = Pattern.compile("(\\s+<array\\s+class=\"com\\.iscobol\\.screenpainter\\.beans\\.AbstractBeanWindow\"\\s+length=\"(\\d+)\">)");

    public IscobolScreenSectionExportPage(String string, IStructuredSelection iStructuredSelection) {
        super(string, "Export Screen Section", null);
        this.selection = iStructuredSelection;
    }

    public AbstractBeanWindow getScreenSection() {
        return this.screenSection;
    }

    public String getIscobolRelease() {
        return this.iscobolRelease;
    }

    private boolean validatePage() {
        boolean bl = this.validateParent();
        if (bl) {
            this.setPageValid();
        }
        return bl;
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    private void setSelectedItem() {
        if (!this.selection.isEmpty()) {
            TreeItem treeItem;
            Object object = this.selection.getFirstElement();
            if (object instanceof ScreenSectionAdapter) {
                ScreenSectionAdapter screenSectionAdapter = (ScreenSectionAdapter)object;
                IFile iFile = screenSectionAdapter.getProgramFile();
                TreeItem treeItem2 = this.findProjectItem(iFile.getProject());
                if (treeItem2 != null) {
                    List list = (List)treeItem2.getData(LIST);
                    int n = -1;
                    for (int i = 0; i < list.size() && n < 0; ++i) {
                        if (!((IFile)list.get(i)).equals(iFile)) continue;
                        this.loadScreenProgram((IFile)list.get(i), treeItem2.getItem(i));
                        n = i;
                    }
                    if (n >= 0) {
                        ScreenProgram screenProgram = PluginUtilities.getScreenProgram((IFile)((IFile)list.get(n)));
                        AbstractBeanWindow[] abstractBeanWindowArray = screenProgram.getScreenSections();
                        String string = screenProgram.getIscobolRelease(true);
                        int n2 = -1;
                        for (int i = 0; i < abstractBeanWindowArray.length && n2 < 0; ++i) {
                            if (!abstractBeanWindowArray[i].getName().equals(screenSectionAdapter.getWindow().getName())) continue;
                            this.loadScreenSection(abstractBeanWindowArray[i], treeItem2.getItem(n).getItem(i));
                            n2 = i;
                        }
                        if (n2 >= 0) {
                            this.tree.setSelection(treeItem2.getItem(n).getItem(n2));
                            this.screenSection = abstractBeanWindowArray[n2];
                            this.iscobolRelease = string;
                        } else {
                            this.tree.setSelection(treeItem2.getItem(n));
                        }
                    } else {
                        this.tree.setSelection(treeItem2);
                    }
                }
            } else if (object instanceof IScreenProgramAdapter) {
                IFile iFile = ((IScreenProgramAdapter)object).getProgramFile();
                TreeItem treeItem3 = this.findProjectItem(iFile.getProject());
                if (treeItem3 != null) {
                    List list = (List)treeItem3.getData(LIST);
                    int n = -1;
                    for (int i = 0; i < list.size() && n < 0; ++i) {
                        if (!((IFile)list.get(i)).equals(iFile)) continue;
                        this.loadScreenProgram((IFile)list.get(i), treeItem3.getItem(i));
                        n = i;
                    }
                    if (n >= 0) {
                        this.tree.setSelection(treeItem3.getItem(n));
                    } else {
                        this.tree.setSelection(treeItem3);
                    }
                }
            } else if (object instanceof IProject && (treeItem = this.findProjectItem((IProject)object)) != null) {
                this.tree.setSelection(treeItem);
            }
        }
        this.validatePage();
    }

    private boolean validateParent() {
        if (this.screenSection == null) {
            this.setPageInvalid("Select a screen section to export");
            return false;
        }
        return true;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Select screen section");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.tree = new Tree(composite2, 268437508);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 80;
        this.tree.setLayoutData((Object)gridData);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        for (IProject iProject : iProjectArray) {
            if (!iProject.isOpen() || !this.isIscobolProject(iProject)) continue;
            arrayList.add(iProject);
        }
        this.tree.addListener(36, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tree.setItemCount(arrayList.size());
        this.tree.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private TreeItem findProjectItem(IProject iProject) {
        for (TreeItem treeItem : this.tree.getItems()) {
            if (treeItem.getData(ELEMENT) == null || !treeItem.getData(ELEMENT).equals(iProject)) continue;
            return treeItem;
        }
        return null;
    }

    private int getScreenSectionCount(IFile iFile) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents()));
            String string = bufferedReader.readLine();
            while (string != null) {
                Matcher matcher = SCREEN_PATTERN.matcher(string);
                if (matcher.find() && matcher.groupCount() >= 2) {
                    return Integer.parseInt(matcher.group(2));
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private void loadProject(IProject iProject, TreeItem treeItem) {
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/project.gif"));
        treeItem.setText(iProject.getName());
        IContainer iContainer = null;
        try {
            iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
            if (iContainer == null) {
                return;
            }
            ArrayList<IFile> arrayList = new ArrayList<IFile>();
            for (IResource iResource : iContainer.members()) {
                if (!(iResource instanceof IFile) || !iResource.getName().endsWith(".isp")) continue;
                arrayList.add((IFile)iResource);
            }
            treeItem.setData(ELEMENT, (Object)iProject);
            treeItem.setData(LIST, arrayList);
            treeItem.setItemCount(arrayList.size());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void loadScreenProgram(IFile iFile, TreeItem treeItem) {
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/program.png"));
        treeItem.setText(iFile.getLocation().removeFileExtension().lastSegment());
        treeItem.setItemCount(this.getScreenSectionCount(iFile));
        treeItem.setData(ELEMENT, (Object)iFile);
    }

    private void loadScreenSection(AbstractBeanWindow abstractBeanWindow, TreeItem treeItem) {
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/screen.png"));
        treeItem.setText(abstractBeanWindow.getName());
        treeItem.setData(ELEMENT, (Object)abstractBeanWindow);
    }

    private boolean isIscobolProject(IProject iProject) {
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ Tree access$000(IscobolScreenSectionExportPage iscobolScreenSectionExportPage) {
        return iscobolScreenSectionExportPage.tree;
    }

    static /* synthetic */ void access$100(IscobolScreenSectionExportPage iscobolScreenSectionExportPage, IProject iProject, TreeItem treeItem) {
        iscobolScreenSectionExportPage.loadProject(iProject, treeItem);
    }

    static /* synthetic */ void access$200(IscobolScreenSectionExportPage iscobolScreenSectionExportPage, IFile iFile, TreeItem treeItem) {
        iscobolScreenSectionExportPage.loadScreenProgram(iFile, treeItem);
    }

    static /* synthetic */ void access$300(IscobolScreenSectionExportPage iscobolScreenSectionExportPage, AbstractBeanWindow abstractBeanWindow, TreeItem treeItem) {
        iscobolScreenSectionExportPage.loadScreenSection(abstractBeanWindow, treeItem);
    }

    static /* synthetic */ AbstractBeanWindow access$402(IscobolScreenSectionExportPage iscobolScreenSectionExportPage, AbstractBeanWindow abstractBeanWindow) {
        iscobolScreenSectionExportPage.screenSection = abstractBeanWindow;
        return iscobolScreenSectionExportPage.screenSection;
    }

    static /* synthetic */ String access$502(IscobolScreenSectionExportPage iscobolScreenSectionExportPage, String string) {
        iscobolScreenSectionExportPage.iscobolRelease = string;
        return iscobolScreenSectionExportPage.iscobolRelease;
    }

    static /* synthetic */ boolean access$600(IscobolScreenSectionExportPage iscobolScreenSectionExportPage) {
        return iscobolScreenSectionExportPage.validatePage();
    }

    static /* synthetic */ void access$700(IscobolScreenSectionExportPage iscobolScreenSectionExportPage) {
        iscobolScreenSectionExportPage.setSelectedItem();
    }
}

