/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.wizards.IscobolNewFilePage;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.wizards.ScreenSectionWizard;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ide.IDE;

public class NewScreenProgramCreationPage
extends IscobolNewFilePage {
    public NewScreenProgramCreationPage(IStructuredSelection iStructuredSelection) {
        super("newScreenProgramPage1", "newScreenProgramPage1", iStructuredSelection);
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            if (this.isIscobolProject(iProject)) {
                IContainer iContainer = null;
                try {
                    iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (iContainer != null) {
                    this.setContainerFullPath(iContainer.getFullPath());
                }
            }
        } else if (object instanceof IscobolProjectAdapter) {
            IContainer iContainer = null;
            try {
                iContainer = PluginUtilities.getScreenFolder((IProject)((IscobolProjectAdapter)object).getProject());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (iContainer != null) {
                this.setContainerFullPath(iContainer.getFullPath());
            }
        }
    }

    private boolean isIscobolProject(IProject iProject) {
        if (iProject == null) {
            return false;
        }
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IFile createNewFile() {
        IFile iFile = super.createNewFile();
        if (iFile.exists()) {
            IEditorDescriptor iEditorDescriptor;
            ScreenProgram screenProgram = new ScreenProgram(iFile);
            screenProgram.setImported(true);
            if (!iFile.isLinked()) {
                iEditorDescriptor = ScreenSectionWizard.createDefaultWindow((String)"screen-1", (String)"screen-1", (ScreenProgram)screenProgram);
                screenProgram.addScreenSection((AbstractBeanWindow)iEditorDescriptor);
                if (iFile.getProject() != null && "true".equals(PluginUtilities.getPersistentProperty((IResource)iFile.getProject(), (String)"Default", (String)"iscobolsp.showonlywd2supported"))) {
                    screenProgram.setFollowDefaultFlag(false);
                    screenProgram.setGenerateGoback(true);
                }
                screenProgram.save();
            }
            if ((iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile)) == null || !iEditorDescriptor.getId().equals("iscobolscreenpainter.MultipageScreenSectionEditor")) {
                IDE.setDefaultEditor((IFile)iFile, (String)"iscobolscreenpainter.MultipageScreenSectionEditor");
            }
        }
        return iFile;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IPath iPath = this.getContainerFullPath();
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (!(iResource instanceof IContainer && this.isIscobolProject(iResource.getProject()) && PluginUtilities.isScreenFolder((IContainer)((IContainer)iResource)))) {
            this.setErrorMessage(ISPBundle.getString((String)"file_not_in_screen_fld_msg"));
            return false;
        }
        String string = this.getFileName();
        if (!string.endsWith(".isp")) {
            this.setErrorMessage("File extension must be 'isp'");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

