/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.wizards;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.ImageProvider;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ScreenProgramSelector
extends Composite {
    private Tree viewer;
    private IFile programFile;
    private IStructuredSelection selection;

    public ScreenProgramSelector(Composite composite, int n, IStructuredSelection iStructuredSelection) {
        super(composite, n);
        this.selection = iStructuredSelection;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText("Select parent program");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.viewer = new Tree((Composite)this, 2052);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.viewer.setLayoutData((Object)gridData);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        ImageProvider imageProvider = IscobolScreenPainterPlugin.getDefault().getImageProvider();
        for (int i = 0; i < iProjectArray.length; ++i) {
            try {
                if (!this.isIscobolProject(iProjectArray[i])) continue;
                TreeItem treeItem = new TreeItem(this.viewer, 0);
                treeItem.setText(iProjectArray[i].getName());
                treeItem.setImage(imageProvider.getImage("/project.gif"));
                IContainer iContainer = PluginUtilities.getScreenFolder((IProject)iProjectArray[i]);
                if (iContainer == null) continue;
                this.visit(iContainer, treeItem, imageProvider);
                continue;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (this.selection != null) {
            if (this.selection.getFirstElement() instanceof IFile) {
                IFile iFile = (IFile)this.selection.getFirstElement();
                if (iFile.getFileExtension() != null && iFile.getFileExtension().equals("isp")) {
                    this.select(iFile);
                }
            } else if (this.selection.getFirstElement() instanceof IScreenProgramAdapter) {
                this.select(((IScreenProgramAdapter)this.selection.getFirstElement()).getScreenProgram().getFile());
            }
        }
    }

    private void select(IFile iFile) {
        IPath iPath = iFile.getFullPath().removeFileExtension();
        if (this.select(this.viewer.getItems(), iPath, 0)) {
            this.programFile = iFile;
        }
    }

    private boolean select(TreeItem[] treeItemArray, IPath iPath, int n) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!treeItemArray[i].getText().equals(iPath.segment(n))) continue;
            if (treeItemArray[i].getItemCount() > 0) {
                this.select(treeItemArray[i].getItems(), iPath, n + 1);
                break;
            }
            this.viewer.setSelection(treeItemArray[i]);
            return true;
        }
        return false;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.viewer.addSelectionListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.viewer.removeSelectionListener(selectionListener);
    }

    private void visit(IContainer iContainer, TreeItem treeItem, ImageProvider imageProvider) throws CoreException {
        TreeItem treeItem2 = new TreeItem(treeItem, 0);
        treeItem2.setText(iContainer.getName());
        treeItem2.setImage(imageProvider.getImage("/folder.gif"));
        IResource[] iResourceArray = iContainer.members();
        for (int i = 0; i < iResourceArray.length; ++i) {
            if (!(iResourceArray[i] instanceof IFile)) continue;
            IFile iFile = (IFile)iResourceArray[i];
            if (iFile.getFileExtension() != null && iFile.getFileExtension().equals("isp")) {
                TreeItem treeItem3 = new TreeItem(treeItem2, 0);
                String string = iFile.getName();
                string = string.substring(0, string.length() - "isp".length() - 1);
                treeItem3.setText(string);
                treeItem3.setImage(imageProvider.getImage("/program.png"));
                treeItem3.setData((Object)iFile);
                continue;
            }
            if (!(iResourceArray[i] instanceof IFolder)) continue;
            this.visit((IContainer)((IFolder)iResourceArray[i]), treeItem2, imageProvider);
        }
    }

    public boolean validateParent() {
        TreeItem treeItem;
        if (this.viewer.getSelectionCount() > 0 && (treeItem = this.viewer.getSelection()[0]).getData() != null) {
            this.programFile = (IFile)treeItem.getData();
            return true;
        }
        this.programFile = null;
        return false;
    }

    public IFile getProgramFile() {
        return this.programFile;
    }

    private boolean isIscobolProject(IProject iProject) {
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

