/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.servicedesigner;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IDataDivision;
import com.iscobol.interfaces.compiler.IElkParser;
import com.iscobol.interfaces.compiler.IElkParserExtension;
import com.iscobol.interfaces.compiler.IEntry;
import com.iscobol.interfaces.compiler.ILinkageSection;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPreProcessor;
import com.iscobol.interfaces.compiler.IProcedureDivision;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.IVariableDeclaration;
import com.iscobol.interfaces.compiler.IVariableDeclarationList;
import com.iscobol.interfaces.compiler.IVariableName;
import com.iscobol.interfaces.compiler.IVariableNameList;
import com.iscobol.plugins.editor.util.Service;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.servicedesigner.DataMapItem;
import com.iscobol.servicedesigner.ServiceSettingsPanel;
import com.iscobol.servicedesigner.dialogs.DataMapDialog;
import com.iscobol.servicedesigner.dialogs.LinkageItemDialog;
import com.iscobol.servicedesigner.dialogs.OperationDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceEditor
extends EditorPart
implements IResourceChangeListener {
    public static final String ID = "iscobolscreenpainter.ServiceEditor";
    private static final String USING_KEY = "using";
    private static final String OPERATION_KEY = "operation";
    private boolean dirty;
    private FileEditorInput input;
    private IPcc pcc;
    private IPcc cobolProgram;
    private ILinkageSection linkage;
    private Vector<IPreProcessor> allPreprocessors;
    private Map<File, Service.CobolSource> cobolSources;
    private Service srv;
    private ICompiler compiler;
    private Service.CobolSource currSource;
    private Properties serviceProps;
    private Properties serviceDefaults;
    private Map<String, Service.PropToken> servicePropsTokens;
    private LinkedHashMap<IVariableDeclaration, DataMapItem> dataMap = new LinkedHashMap();
    private ServiceSettingsPanel serviceSettings;
    private Label operationLbl;
    private ToolBar operationToolbar;
    private Label linkageLbl;
    private ToolBar linkageToolbar;
    private Label dataMapLbl;
    private ToolBar dataMapToolbar;
    private ToolItem editOperationItem;
    private ToolItem editLinkageItem;
    private ToolItem editDataMapItem;
    private ToolItem deleteDataMapItem;
    private Table operationTbl;
    private SashForm dataMapSash;
    private Tree linkageTree;
    private Tree dataMapTree;
    private Label linkageDecorationLbl;
    private Combo linkageDecorationCmb;
    private Label entryPointLbl;
    private Combo entryPointCmb;
    private CTabFolder tabFolder;
    private Composite serviceCmp;
    private Composite dataMapCmp;
    private LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();

    public ServiceEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta().findMember(iFile.getFullPath());
        if (iResourceDelta != null) {
            switch (iResourceDelta.getKind()) {
                case 2: {
                    Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    break;
                }
                case 4: {
                    if ((iResourceDelta.getFlags() & 0x100) != 256 && (iResourceDelta.getFlags() & 0x800) != 2048) break;
                    Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
    }

    private void setDirty(boolean bl) {
        this.dirty = bl;
        this.firePropertyChange(257);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IResource.class) {
            return this.input.getFile();
        }
        return super.getAdapter(clazz);
    }

    private Service.CobolSource getCobolSource(String string) {
        return Service.getCobolSource((String)string, (Map)this.cobolSources, (Vector)this.allPreprocessors);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        IToken iToken;
        Object object;
        Object object2;
        Object object3;
        IVariableDeclarationList iVariableDeclarationList;
        if (this.pcc == null) {
            this.setDirty(false);
            return;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.allPreprocessors = this.pcc.getTokenManager().getAllPreProcessors();
        this.cobolSources = new HashMap();
        this.currSource = this.srv.setServiceDirectives(this.serviceProps, this.serviceDefaults, this.getCobolSource(this.input.getFile().getLocation().toString()), this.cobolSources, this.allPreprocessors, this.servicePropsTokens);
        if (this.linkage != null) {
            iVariableDeclarationList = this.linkage.getVariableDeclarationList();
            object3 = iVariableDeclarationList.getFirst();
            while (object3 != null) {
                object2 = (DataMapItem)this.dataMap.get(object3);
                if (object2 != null) {
                    this.putElkDirectives((DataMapItem)object2, null);
                }
                object3 = iVariableDeclarationList.getNext();
            }
            object3 = this.linkage.getElkToken();
            object2 = this.linkageDecorationCmb.getText();
            if (object3 != null || !"Default".equals(object2)) {
                object = "";
                if (this.currSource.getFormat() == 1) {
                    object = (String)object + "      ";
                }
                object = (String)object + "$elk decoration=" + ((String)object2).toLowerCase();
                if (object3 != null) {
                    this.currSource = this.getCobolSource(object3.getFileName());
                    this.currSource.setLine(object3.getFLN() - 1, (String)object);
                } else {
                    iToken = this.linkage.getFirstToken();
                    this.currSource = this.getCobolSource(iToken.getFileName());
                    this.currSource.addLineBefore(iToken.getFLN() - 1, (String)object);
                }
            }
        }
        if ((iVariableDeclarationList = this.cobolProgram.getProcedureDivision()) != null) {
            object3 = (String)this.operationTbl.getItem(0).getData("operation");
            object2 = ServiceEditor.removeQuotes((String)iVariableDeclarationList.getServiceBridgeOperation());
            if (object2 != null || !((String)object3).equals(this.getDefaultProcedureOperation())) {
                object = "";
                if (this.currSource.getFormat() == 1) {
                    object = (String)object + "      ";
                }
                object = (String)object + "$elk operation=" + (String)object3;
                if (object2 != null) {
                    iToken = iVariableDeclarationList.getElkToken();
                    this.currSource = this.getCobolSource(iToken.getFileName());
                    this.currSource.setLine(iToken.getFLN() - 1, (String)object);
                } else {
                    iToken = iVariableDeclarationList.getFirstToken();
                    this.currSource = this.getCobolSource(iToken.getFileName());
                    this.currSource.addLineBefore(iToken.getFLN() - 1, (String)object);
                }
            }
        }
        object = this.cobolProgram.getEntryPoints();
        for (int i = 0; i < ((IEntry[])object).length; ++i) {
            IToken iToken2;
            object3 = (String)this.operationTbl.getItem(i + 1).getData("operation");
            object2 = ServiceEditor.removeQuotes((String)object[i].getServiceBridgeOperation());
            if (object2 == null && ((String)object3).equals(this.getEntryName(object[i]))) continue;
            String string = "";
            if (this.currSource.getFormat() == 1) {
                string = string + "      ";
            }
            string = string + "$elk operation=" + (String)object3;
            if (object2 != null) {
                iToken2 = object[i].getElkToken();
                this.currSource = this.getCobolSource(iToken2.getFileName());
                this.currSource.setLine(iToken2.getFLN() - 1, string);
                continue;
            }
            iToken2 = object[i].getKeyWord();
            this.currSource = this.getCobolSource(iToken2.getFileName());
            this.currSource.addLineBefore(iToken2.getFLN() - 1, string);
        }
        Service.saveFile((Map)this.cobolSources);
        this.initFields(true);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.setDirty(false);
    }

    public void dispose() {
        this.cobolSources = null;
        this.currSource = null;
        this.allPreprocessors = null;
        this.pcc = null;
        this.cobolProgram = null;
        this.linkage = null;
        this.serviceProps = null;
        this.servicePropsTokens = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    private void putElkDirectives(DataMapItem dataMapItem, DataMapItem dataMapItem2) {
        int n;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dataMapItem.hidden) {
            arrayList.add("hidden");
        } else {
            if (dataMapItem.value != null && dataMapItem.value.length() > 0) {
                arrayList.add("value=" + dataMapItem.value);
            }
            if (dataMapItem.useGroup) {
                arrayList.add("use group");
            }
            int n3 = arrayList.size();
            boolean bl = dataMapItem2 != null && dataMapItem2.direction != dataMapItem.direction || dataMapItem2 == null && dataMapItem.direction != 0;
            switch (dataMapItem.direction) {
                case 0: {
                    if (dataMapItem.nameIn != null && dataMapItem.nameIn.length() > 0) {
                        arrayList.add("name=" + dataMapItem.nameIn);
                    }
                    if (dataMapItem.typeIn != null && dataMapItem.typeIn.length() > 0 && !dataMapItem.typeIn.equals(dataMapItem.vd.getUsageElk())) {
                        arrayList.add("type=" + dataMapItem.typeIn);
                    }
                    int n4 = arrayList.size();
                    if (dataMapItem.nameOut != null && dataMapItem.nameOut.length() > 0) {
                        arrayList.add("name=" + dataMapItem.nameOut);
                    }
                    if (dataMapItem.typeOut != null && dataMapItem.typeOut.length() > 0 && !dataMapItem.typeOut.equals(dataMapItem.vd.getUsageElk())) {
                        arrayList.add("type=" + dataMapItem.typeOut);
                    }
                    if (!bl && arrayList.size() <= 0) break;
                    arrayList.add(n3, "input");
                    arrayList.add(++n4, "output");
                    break;
                }
                case 1: {
                    if (dataMapItem.nameIn != null && dataMapItem.nameIn.length() > 0) {
                        arrayList.add("name=" + dataMapItem.nameIn);
                    }
                    if (dataMapItem.typeIn != null && dataMapItem.typeIn.length() > 0 && !dataMapItem.typeIn.equals(dataMapItem.vd.getUsageElk())) {
                        arrayList.add("type=" + dataMapItem.typeIn);
                    }
                    if (!bl && arrayList.size() <= 0) break;
                    arrayList.add(n3, "input");
                    break;
                }
                case 2: {
                    if (dataMapItem.nameOut != null && dataMapItem.nameOut.length() > 0) {
                        arrayList.add("name=" + dataMapItem.nameOut);
                    }
                    if (dataMapItem.typeOut != null && dataMapItem.typeOut.length() > 0 && !dataMapItem.typeOut.equals(dataMapItem.vd.getUsageElk())) {
                        arrayList.add("type=" + dataMapItem.typeOut);
                    }
                    if (!bl && arrayList.size() <= 0) break;
                    arrayList.add(n3, "output");
                }
            }
            if (dataMapItem.mandatory) {
                arrayList.add("mandatory");
            }
        }
        IElkParser iElkParser = dataMapItem.vd.getElkExtraInfo();
        IToken iToken = null;
        IToken iToken2 = dataMapItem.vd.getNameToken();
        if (iElkParser != null) {
            iToken = iElkParser.getFirstToken();
        }
        int n5 = iToken2.getFLN();
        if (iToken != null) {
            this.currSource = this.getCobolSource(iToken.getFileName());
            n2 = n5 - iToken.getFLN();
            for (n = 0; n < n2; ++n) {
                this.currSource.removeLine(iToken.getFLN() - 1 + n);
            }
        } else {
            this.currSource = this.getCobolSource(iToken2.getFileName());
        }
        if (arrayList.size() > 0) {
            if (this.currSource.getFormat() == 1) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    this.currSource.addLineBefore(n5 - 1, "      $elk " + (String)arrayList.get(n2));
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.currSource.getFormat() == 3) {
                    stringBuilder.append("*>((elk");
                } else {
                    stringBuilder.append("$elk");
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    stringBuilder.append(" " + (String)arrayList.get(n));
                }
                if (this.currSource.getFormat() == 3) {
                    stringBuilder.append("))");
                }
                this.currSource.addLineBefore(n5 - 1, stringBuilder.toString());
            }
        }
        for (int i = 0; i < dataMapItem.getChildCount(); ++i) {
            this.putElkDirectives(dataMapItem.getChild(i), dataMapItem);
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof FileEditorInput)) {
            throw new PartInitException("Illegal argument: " + iEditorInput);
        }
        this.input = (FileEditorInput)iEditorInput;
        IProject iProject = this.input.getFile().getProject();
        this.compiler = Factory.getCompiler((IProject)iProject);
        this.srv = new Service(Factory.getRuntime((IProject)iProject), this.compiler);
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setPartName(this.input.getName());
        this.setInput(iEditorInput);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        ManagedForm managedForm = new ManagedForm(composite);
        FormToolkit formToolkit = managedForm.getToolkit();
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText("Service Settings");
        scrolledForm.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/service.png"));
        Composite composite2 = scrolledForm.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        composite2.setLayout((Layout)tableWrapLayout);
        this.serviceSettings = new ServiceSettingsPanel();
        this.serviceSettings.createEnableServiceButton(composite2, formToolkit);
        Composite composite3 = formToolkit.createComposite(composite2);
        composite3.setLayout((Layout)new GridLayout());
        this.tabFolder = new CTabFolder(composite3, 128);
        GridData gridData = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gridData);
        formToolkit.adapt((Composite)this.tabFolder);
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0);
        cTabItem.setText("Service");
        this.serviceCmp = formToolkit.createComposite((Composite)this.tabFolder);
        cTabItem.setControl((Control)this.serviceCmp);
        CTabItem cTabItem2 = new CTabItem(this.tabFolder, 0);
        cTabItem2.setText("Data Map");
        this.dataMapCmp = formToolkit.createComposite((Composite)this.tabFolder);
        cTabItem2.setControl((Control)this.dataMapCmp);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.serviceCmp.setLayout((Layout)gridLayout);
        Composite composite4 = formToolkit.createComposite(this.serviceCmp);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData(1040);
        composite4.setLayoutData((Object)gridData2);
        gridData = new GridData();
        gridData.widthHint = 300;
        this.serviceSettings.createPartControl(composite4, gridData, formToolkit);
        composite4 = formToolkit.createComposite(this.serviceCmp);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        gridData2 = new GridData(1808);
        composite4.setLayoutData((Object)gridData2);
        this.linkageDecorationLbl = formToolkit.createLabel(composite4, "Decoration:", 0);
        this.linkageDecorationCmb = new Combo(composite4, 2056);
        this.linkageDecorationCmb.add("Default");
        this.linkageDecorationCmb.add("None");
        this.linkageDecorationCmb.setLayoutData((Object)new GridData(768));
        this.operationLbl = formToolkit.createLabel(composite4, "Operations", 0);
        this.operationToolbar = new ToolBar(composite4, 8519936);
        this.operationToolbar.setLayoutData((Object)new GridData(768));
        formToolkit.adapt((Composite)this.operationToolbar);
        this.editOperationItem = new ToolItem(this.operationToolbar, 8);
        this.editOperationItem.setToolTipText("Edit");
        this.editOperationItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/edit.gif"));
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.operationToolbar);
        this.operationTbl = formToolkit.createTable(composite4, 67584);
        this.operationTbl.setHeaderVisible(true);
        this.operationTbl.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.operationTbl.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.operationTbl, 0);
        tableColumn.setWidth(170);
        tableColumn.setText("Entry Point");
        tableColumn = new TableColumn(this.operationTbl, 0);
        tableColumn.setWidth(300);
        tableColumn.setText("Operation");
        gridLayout = new GridLayout();
        this.dataMapCmp.setLayout((Layout)gridLayout);
        Composite composite5 = formToolkit.createComposite(this.dataMapCmp);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite5.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite5.setLayoutData((Object)gridData);
        this.entryPointLbl = formToolkit.createLabel(composite5, "Entry Point:");
        this.entryPointCmb = new Combo(composite5, 2056);
        this.dataMapSash = new SashForm(this.dataMapCmp, 65792);
        this.dataMapSash.SASH_WIDTH = 5;
        this.dataMapSash.setLayoutData((Object)new GridData(1808));
        Composite composite6 = formToolkit.createComposite((Composite)this.dataMapSash);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite6.setLayout((Layout)gridLayout);
        this.linkageLbl = formToolkit.createLabel(composite6, "Linkage Section Fields", 0);
        this.linkageToolbar = new ToolBar(composite6, 8519936);
        formToolkit.adapt((Composite)this.linkageToolbar);
        this.linkageToolbar.setLayoutData((Object)new GridData(768));
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.linkageToolbar);
        this.editLinkageItem = new ToolItem(this.linkageToolbar, 8);
        this.editLinkageItem.setToolTipText("Edit");
        this.editLinkageItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/edit.gif"));
        this.linkageTree = formToolkit.createTree(composite6, 67586);
        this.linkageTree.setHeaderVisible(true);
        this.linkageTree.setLinesVisible(true);
        this.linkageTree.setToolTipText("Drag items to add them to the Service Fields");
        TreeColumn treeColumn = new TreeColumn(this.linkageTree, 0);
        treeColumn.setWidth(200);
        treeColumn.setText("Data Item");
        treeColumn = new TreeColumn(this.linkageTree, 0);
        treeColumn.setText("Value");
        treeColumn.setWidth(150);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.linkageTree.setLayoutData((Object)gridData);
        Composite composite7 = formToolkit.createComposite((Composite)this.dataMapSash);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite7.setLayout((Layout)gridLayout);
        this.dataMapLbl = formToolkit.createLabel(composite7, "Service Fields", 0);
        this.dataMapToolbar = new ToolBar(composite7, 8519936);
        formToolkit.adapt((Composite)this.dataMapToolbar);
        this.dataMapToolbar.setLayoutData((Object)new GridData(768));
        this.editDataMapItem = new ToolItem(this.dataMapToolbar, 8);
        this.editDataMapItem.setToolTipText("Edit");
        this.editDataMapItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/edit.gif"));
        this.deleteDataMapItem = new ToolItem(this.dataMapToolbar, 8);
        this.deleteDataMapItem.setToolTipText("Delete");
        this.deleteDataMapItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/delete.gif"));
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.dataMapToolbar);
        this.dataMapTree = formToolkit.createTree(composite7, 67586);
        this.dataMapTree.setHeaderVisible(true);
        this.dataMapTree.setLinesVisible(true);
        treeColumn = new TreeColumn(this.dataMapTree, 0);
        treeColumn.setText("Data Item");
        treeColumn.setWidth(150);
        treeColumn = new TreeColumn(this.dataMapTree, 0);
        treeColumn.setText("Name");
        treeColumn.setWidth(150);
        treeColumn = new TreeColumn(this.dataMapTree, 0);
        treeColumn.setText("Direction");
        treeColumn.setWidth(100);
        treeColumn = new TreeColumn(this.dataMapTree, 0);
        treeColumn.setText("Type");
        treeColumn.setWidth(70);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.dataMapTree.setLayoutData((Object)gridData);
        this.dataMapSash.setWeights(new int[]{42, 58});
        this.tabFolder.setSelection(0);
        this.initFields(false);
        this.addListeners();
    }

    private void addListeners() {
        this.serviceSettings.addListeners();
        this.serviceSettings.addPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linkageDecorationCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.operationTbl.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.entryPointCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.operationTbl.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editOperationItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editLinkageItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editDataMapItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteDataMapItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linkageTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linkageTree.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dataMapTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dataMapTree.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dataMapTree.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        DragSource dragSource = new DragSource((Control)this.linkageTree, 2);
        Transfer[] transferArray = new Transfer[]{this.transfer};
        dragSource.setTransfer(transferArray);
        dragSource.addDragListener((DragSourceListener)new /* Unavailable Anonymous Inner Class!! */);
        DropTarget dropTarget = new DropTarget((Control)this.dataMapTree, 2);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener((DropTargetListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void settingPropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if ("iscobol.compiler.servicebridge".equals(propertyChangeEvent.getProperty())) {
            this.setDirty(true);
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setEnabledAll(bl);
            this.serviceProps.setProperty("iscobol.compiler.servicebridge", bl ? "1" : "0");
        } else if (Service.isServiceProperty((String)propertyChangeEvent.getProperty())) {
            this.setDirty(true);
            this.serviceProps.setProperty(propertyChangeEvent.getProperty(), (String)propertyChangeEvent.getNewValue());
        }
    }

    private void dropDataMapItems(DropTargetEvent dropTargetEvent) {
        DataMapItem dataMapItem;
        if (this.transfer.getSelection() == null || this.transfer.getSelection().isEmpty()) {
            dropTargetEvent.detail = 0;
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)this.transfer.getSelection();
        TreeItem[] treeItemArray = this.getRootItems(structuredSelection.toList());
        Set set = this.getDataMapVariables(this.dataMapTree.getItems());
        for (TreeItem treeItem : treeItemArray) {
            DataMapItem dataMapItem2;
            dataMapItem = this.findDataMapItem(treeItem, set);
            if (dataMapItem != null) {
                switch (dataMapItem.direction) {
                    case 0: {
                        PluginUtilities.logError((String)("'" + dataMapItem.vd.getName() + "' data item is already in the list"));
                        dropTargetEvent.detail = 0;
                        return;
                    }
                    case 1: 
                    case 2: {
                        if (treeItem.getParentItem() == null || (dataMapItem2 = this.findDataMapItem(treeItem.getParentItem(), set)) != null && dataMapItem2.direction != dataMapItem.direction) break;
                        PluginUtilities.logError((String)"Operation not allowed: drag the parent item first");
                        dropTargetEvent.detail = 0;
                        return;
                    }
                }
                continue;
            }
            if (treeItem.getParentItem() == null || (dataMapItem2 = this.findDataMapItem(treeItem.getParentItem(), set)) != null && dataMapItem2.direction != 2) continue;
            PluginUtilities.logError((String)"Operation not allowed: drag the parent item first");
            dropTargetEvent.detail = 0;
            return;
        }
        for (TreeItem treeItem : treeItemArray) {
            dataMapItem = (DataMapItem)treeItem.getData();
            this.unsetHidden(dataMapItem);
            int n = dataMapItem.direction == 2 || dataMapItem.direction == 0 ? 1 : 2;
            ServiceEditor.addDirection((DataMapItem)dataMapItem, (int)n);
        }
        this.loadDataMapTree();
        this.setDirty(true);
    }

    private static void addDirection(DataMapItem dataMapItem, int n) {
        if (dataMapItem.direction == 0) {
            dataMapItem.direction = n;
        } else if (dataMapItem.direction != n) {
            dataMapItem.direction = 0;
        }
        for (int i = 0; i < dataMapItem.getChildCount(); ++i) {
            ServiceEditor.addDirection((DataMapItem)dataMapItem.getChild(i), (int)n);
        }
    }

    private static void removeDirection(DataMapItem dataMapItem, int n) {
        if (!dataMapItem.hidden) {
            if (dataMapItem.direction == 0) {
                if (n == 1) {
                    dataMapItem.direction = 2;
                    dataMapItem.nameIn = null;
                    dataMapItem.typeIn = null;
                } else {
                    dataMapItem.direction = 1;
                    dataMapItem.nameOut = null;
                    dataMapItem.typeOut = null;
                }
            } else if (dataMapItem.direction == n) {
                dataMapItem.setHidden(true);
                dataMapItem.nameIn = null;
                dataMapItem.typeIn = null;
                dataMapItem.nameOut = null;
                dataMapItem.typeOut = null;
            }
        }
        for (int i = 0; i < dataMapItem.getChildCount(); ++i) {
            ServiceEditor.removeDirection((DataMapItem)dataMapItem.getChild(i), (int)n);
        }
    }

    private TreeItem[] getRootItems(List<TreeItem> list) {
        HashSet<TreeItem> hashSet = new HashSet<TreeItem>(list);
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        for (TreeItem treeItem : hashSet) {
            while (treeItem.getParentItem() != null && hashSet.contains(treeItem.getParentItem())) {
                treeItem = treeItem.getParentItem();
            }
            arrayList.add(treeItem);
        }
        return arrayList.toArray(new TreeItem[arrayList.size()]);
    }

    private DataMapItem findDataMapItem(TreeItem treeItem, Set<IVariableDeclaration> set) {
        return this.findDataMapItem(new TreeItem[]{treeItem}, set);
    }

    private DataMapItem findDataMapItem(TreeItem[] treeItemArray, Set<IVariableDeclaration> set) {
        int n = 0;
        TreeItem[] treeItemArray2 = treeItemArray;
        int n2 = treeItemArray2.length;
        if (n < n2) {
            TreeItem treeItem = treeItemArray2[n];
            DataMapItem dataMapItem = (DataMapItem)treeItem.getData();
            if (set.contains(dataMapItem.vd)) {
                return dataMapItem;
            }
            return this.findDataMapItem(treeItem.getItems(), set);
        }
        return null;
    }

    private Set<IVariableDeclaration> getDataMapVariables(TreeItem[] treeItemArray) {
        HashSet<IVariableDeclaration> hashSet = new HashSet<IVariableDeclaration>();
        for (TreeItem treeItem : treeItemArray) {
            hashSet.add(((DataMapItem)treeItem.getData()).vd);
            hashSet.addAll(this.getDataMapVariables(treeItem.getItems()));
        }
        return hashSet;
    }

    private void dragLinkageItems() {
        StructuredSelection structuredSelection = new StructuredSelection((Object[])this.linkageTree.getSelection());
        this.transfer.setSelection((ISelection)structuredSelection);
    }

    private void dataMapItemChanged() {
        this.editDataMapItem.setEnabled(true);
        this.deleteDataMapItem.setEnabled(true);
    }

    private void linkageItemChanged() {
        this.editLinkageItem.setEnabled(true);
    }

    private void deleteDataMapItem() {
        MessageBox messageBox = new MessageBox(this.getSite().getShell(), 292);
        messageBox.setMessage("Delete selected items?");
        if (messageBox.open() == 32) {
            TreeItem[] treeItemArray;
            for (TreeItem treeItem : treeItemArray = this.getRootItems(Arrays.asList(this.dataMapTree.getSelection()))) {
                DataMapItem dataMapItem = (DataMapItem)treeItem.getData();
                if (dataMapItem.direction == 0) {
                    if (this.isInput(treeItem)) {
                        ServiceEditor.removeDirection((DataMapItem)dataMapItem, (int)1);
                        continue;
                    }
                    ServiceEditor.removeDirection((DataMapItem)dataMapItem, (int)2);
                    continue;
                }
                this.setHidden(dataMapItem, dataMapItem.direction, true);
            }
            this.loadDataMapTree();
            this.setDirty(true);
        }
    }

    private boolean isInput(TreeItem treeItem) {
        return this.getIODirection(treeItem) == 1;
    }

    private int getIODirection(TreeItem treeItem) {
        return "input".equals(treeItem.getText(2)) ? 1 : 2;
    }

    private void setHidden(DataMapItem dataMapItem, int n, boolean bl) {
        if (dataMapItem.direction == n) {
            dataMapItem.setHidden(bl);
        }
        for (int i = 0; i < dataMapItem.getChildCount(); ++i) {
            this.setHidden(dataMapItem.getChild(i), n, bl);
        }
    }

    private void unsetHidden(DataMapItem dataMapItem) {
        dataMapItem.hidden = false;
        for (int i = 0; i < dataMapItem.getChildCount(); ++i) {
            this.unsetHidden(dataMapItem.getChild(i));
        }
    }

    private void editLinkageItem() {
        TreeItem treeItem = this.linkageTree.getSelection()[0];
        DataMapItem dataMapItem = (DataMapItem)treeItem.getData();
        LinkageItemDialog linkageItemDialog = new LinkageItemDialog(this.getSite().getShell(), dataMapItem, dataMapItem.value);
        if (linkageItemDialog.openDialog()) {
            treeItem.setText(1, dataMapItem.value != null ? dataMapItem.value : "");
            this.setDirty(true);
        }
    }

    private void editOperation() {
        TableItem tableItem = this.operationTbl.getSelection()[0];
        OperationDialog operationDialog = new OperationDialog(this.getSite().getShell(), tableItem.getText(0), (String)tableItem.getData("operation"), null);
        if (operationDialog.openDialog()) {
            tableItem.setData("operation", (Object)operationDialog.getOperation());
            tableItem.setText(1, operationDialog.getOperation());
            this.setDirty(true);
        }
    }

    private void operationChanged() {
        this.editOperationItem.setEnabled(true);
        this.linkageTree.setRedraw(false);
        this.linkageTree.removeAll();
        TableItem tableItem = this.operationTbl.getSelection()[0];
        IVariableNameList iVariableNameList = (IVariableNameList)tableItem.getData("using");
        IVariableName iVariableName = iVariableNameList.getFirst();
        while (iVariableName != null) {
            DataMapItem dataMapItem = (DataMapItem)this.dataMap.get(iVariableName.getVarDecl());
            if (dataMapItem != null) {
                this.createLinkageTreeItem(dataMapItem, null);
            }
            iVariableName = iVariableNameList.getNext();
        }
        this.linkageTree.setRedraw(true);
        this.loadDataMapTree();
    }

    private void getExpandedPaths(TreeItem[] treeItemArray, List<int[]> list, int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < treeItemArray.length; ++i) {
            bl |= treeItemArray[i].getExpanded();
            if (!treeItemArray[i].getExpanded()) continue;
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = i;
            TreeItem[] treeItemArray2 = treeItemArray[i].getItems();
            if (treeItemArray2.length == 0) {
                list.add(nArray2);
                continue;
            }
            this.getExpandedPaths(treeItemArray2, list, nArray2);
        }
        if (!bl && nArray.length > 0) {
            list.add(nArray);
        }
    }

    private void setExpanded(TreeItem[] treeItemArray, int[] nArray, int n) {
        if (nArray[n] < treeItemArray.length) {
            treeItemArray[nArray[n]].setExpanded(true);
            if (n < nArray.length - 1) {
                this.setExpanded(treeItemArray[nArray[n]].getItems(), nArray, n + 1);
            }
        }
    }

    private void loadDataMapTree() {
        ArrayList arrayList = new ArrayList();
        this.getExpandedPaths(this.dataMapTree.getItems(), arrayList, new int[0]);
        this.dataMapTree.setRedraw(false);
        this.dataMapTree.removeAll();
        for (TreeItem treeItem : this.linkageTree.getItems()) {
            this.createDataMapTreeItem(null, treeItem, 1);
        }
        for (TreeItem treeItem : this.linkageTree.getItems()) {
            this.createDataMapTreeItem(null, treeItem, 2);
        }
        this.removeEmptyDataMaps(this.dataMapTree.getItems());
        TreeItem[] treeItemArray = this.dataMapTree.getItems();
        for (int[] nArray : arrayList) {
            this.setExpanded(treeItemArray, nArray, 0);
        }
        this.dataMapTree.setRedraw(true);
        if (this.dataMapTree.getItemCount() > 0) {
            this.dataMapTree.select(this.dataMapTree.getItem(0));
            this.editDataMapItem.setEnabled(true);
            this.deleteDataMapItem.setEnabled(true);
        } else {
            this.editDataMapItem.setEnabled(false);
            this.deleteDataMapItem.setEnabled(false);
        }
    }

    private void editDataMapItem() {
        if (this.dataMapTree.getSelectionCount() == 0) {
            return;
        }
        TreeItem treeItem = this.dataMapTree.getSelection()[0];
        DataMapItem dataMapItem = (DataMapItem)treeItem.getData();
        int n = this.getIODirection(treeItem);
        DataMapDialog dataMapDialog = new DataMapDialog(this.getSite().getShell(), dataMapItem, n, this.compiler.getElkTypeNames());
        if (dataMapDialog.openDialog()) {
            if (dataMapDialog.isChangedDataMapStructure()) {
                this.loadDataMapTree();
            } else {
                for (TreeItem treeItem2 : this.dataMapTree.getItems()) {
                    this.updateDataMapTreeItem(treeItem2, n);
                }
            }
            this.setDirty(true);
        }
    }

    private String getDefaultProcedureOperation() {
        return this.input.getFile().getLocation().removeFileExtension().lastSegment().toString();
    }

    private String getEntryName(IEntry iEntry) {
        String string = iEntry.getName();
        return string.substring(1, string.length() - 1);
    }

    private void initFields(boolean bl) {
        this.serviceProps = new Properties();
        this.serviceDefaults = new Properties();
        this.servicePropsTokens = new HashMap();
        this.pcc = this.srv.analyzeProgram(this.serviceProps, this.serviceDefaults, this.servicePropsTokens, this.input.getFile());
        if (this.pcc != null) {
            this.cobolProgram = this.pcc.getCobolProgram();
        }
        if (!bl) {
            boolean bl2 = this.srv.getBooleanProperty(this.serviceProps, "iscobol.compiler.servicebridge");
            this.serviceSettings.initFields(this.serviceProps);
            this.setEnabledAll(bl2);
        }
        if (this.pcc != null && this.cobolProgram != null) {
            String string;
            Object object;
            TableItem tableItem;
            IProcedureDivision iProcedureDivision = this.cobolProgram.getProcedureDivision();
            if (bl) {
                tableItem = this.operationTbl.getItem(0);
            } else {
                this.operationTbl.removeAll();
                this.linkageTree.removeAll();
                this.dataMapTree.removeAll();
                this.entryPointCmb.removeAll();
                tableItem = new TableItem(this.operationTbl, 0);
                object = null;
                if (iProcedureDivision != null) {
                    object = ServiceEditor.removeQuotes((String)iProcedureDivision.getServiceBridgeOperation());
                }
                if (object == null) {
                    object = this.getDefaultProcedureOperation();
                }
                tableItem.setText(new String[]{"procedure", object});
                tableItem.setData("operation", object);
                this.entryPointCmb.add(tableItem.getText(0));
            }
            if (iProcedureDivision != null) {
                tableItem.setData("using", (Object)iProcedureDivision.getUsing());
            }
            object = this.cobolProgram.getEntryPoints();
            for (int i = 0; i < ((IEntry[])object).length; ++i) {
                if (bl) {
                    tableItem = this.operationTbl.getItem(i + 1);
                } else {
                    tableItem = new TableItem(this.operationTbl, 0);
                    string = this.getEntryName(object[i]);
                    String string2 = ServiceEditor.removeQuotes((String)object[i].getServiceBridgeOperation());
                    if (string2 == null) {
                        string2 = string;
                    }
                    tableItem.setText(new String[]{string, string2});
                    tableItem.setData("operation", (Object)string2);
                    this.entryPointCmb.add(tableItem.getText(0));
                }
                tableItem.setData("using", (Object)object[i].getUsing());
            }
            this.linkageDecorationCmb.select(0);
            IDataDivision iDataDivision = this.cobolProgram.getDataDivision();
            if (iDataDivision != null && (this.linkage = iDataDivision.getLinkageSection()) != null) {
                string = this.linkage.getVariableDeclarationList();
                int n = 0;
                DataMapItem[] dataMapItemArray = null;
                if (bl) {
                    dataMapItemArray = this.dataMap.values().toArray(new DataMapItem[this.dataMap.size()]);
                    this.dataMap.clear();
                }
                Object object2 = string.getFirst();
                while (object2 != null) {
                    if (this.isValidChild(object2)) {
                        this.createDataMap(object2, null, bl ? dataMapItemArray[n++] : null);
                    }
                    object2 = string.getNext();
                }
                object2 = this.linkage.getServiceBridgeDecoration();
                if ("None".equalsIgnoreCase((String)object2)) {
                    this.linkageDecorationCmb.select(1);
                }
            }
            this.operationTbl.select(0);
            this.entryPointCmb.select(0);
            this.operationChanged();
        }
    }

    private void createDataMapTreeItem(TreeItem treeItem, TreeItem treeItem2, int n) {
        TreeItem treeItem3;
        boolean bl;
        DataMapItem dataMapItem = (DataMapItem)treeItem2.getData();
        boolean bl2 = bl = !dataMapItem.hidden && (dataMapItem.direction == 0 || dataMapItem.direction == n);
        if (bl) {
            treeItem3 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(this.dataMapTree, 0);
            this.setItemText(dataMapItem, treeItem3, n);
            treeItem3.setData((Object)dataMapItem);
        } else {
            treeItem3 = null;
        }
        for (TreeItem treeItem4 : treeItem2.getItems()) {
            this.createDataMapTreeItem(treeItem3, treeItem4, n);
        }
    }

    private void updateDataMapTreeItem(TreeItem treeItem, int n) {
        if (n == this.getIODirection(treeItem)) {
            this.setItemText((DataMapItem)treeItem.getData(), treeItem, n);
        }
        for (TreeItem treeItem2 : treeItem.getItems()) {
            this.updateDataMapTreeItem(treeItem2, n);
        }
    }

    private void setItemText(DataMapItem dataMapItem, TreeItem treeItem, int n) {
        treeItem.setText(0, dataMapItem.vd.getName().toLowerCase());
        block0 : switch (dataMapItem.direction) {
            case 1: {
                this.setInput(dataMapItem, treeItem);
                break;
            }
            case 2: {
                this.setOutput(dataMapItem, treeItem);
                break;
            }
            default: {
                switch (n) {
                    default: {
                        this.setInput(dataMapItem, treeItem);
                        break block0;
                    }
                    case 2: 
                }
                this.setOutput(dataMapItem, treeItem);
            }
        }
    }

    private void setInput(DataMapItem dataMapItem, TreeItem treeItem) {
        treeItem.setText(1, dataMapItem.nameIn != null ? dataMapItem.nameIn : "");
        treeItem.setText(2, "input");
        treeItem.setText(3, dataMapItem.typeIn != null ? dataMapItem.typeIn : dataMapItem.vd.getUsageElk());
    }

    private void setOutput(DataMapItem dataMapItem, TreeItem treeItem) {
        treeItem.setText(1, dataMapItem.nameOut != null ? dataMapItem.nameOut : "");
        treeItem.setText(2, "output");
        treeItem.setText(3, dataMapItem.typeOut != null ? dataMapItem.typeOut : dataMapItem.vd.getUsageElk());
    }

    private static String removeQuotes(String string) {
        if (string != null && (string.startsWith("'") || string.startsWith("\""))) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void removeEmptyDataMaps(TreeItem[] treeItemArray) {
        for (TreeItem treeItem : treeItemArray) {
            DataMapItem dataMapItem = (DataMapItem)treeItem.getData();
            if (treeItem.getItemCount() == 0 && this.getValidChildCount(dataMapItem.vd) > 0) {
                treeItem.dispose();
                continue;
            }
            this.removeEmptyDataMaps(treeItem.getItems());
        }
    }

    private int getValidChildCount(IVariableDeclaration iVariableDeclaration) {
        IVariableDeclarationList iVariableDeclarationList = iVariableDeclaration.getChildren();
        int n = 0;
        IVariableDeclaration iVariableDeclaration2 = iVariableDeclarationList.getFirst();
        while (iVariableDeclaration2 != null) {
            if (this.isValidChild(iVariableDeclaration2)) {
                ++n;
            }
            iVariableDeclaration2 = iVariableDeclarationList.getNext();
        }
        return n;
    }

    private void createLinkageTreeItem(DataMapItem dataMapItem, TreeItem treeItem) {
        TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(this.linkageTree, 0);
        String string = ServiceEditor.toString((IVariableDeclaration)dataMapItem.vd, (boolean)true);
        treeItem2.setText(0, string);
        if (dataMapItem.value != null) {
            treeItem2.setText(1, dataMapItem.value);
        }
        treeItem2.setData((Object)dataMapItem);
        for (int i = 0; i < dataMapItem.getChildCount(); ++i) {
            this.createLinkageTreeItem(dataMapItem.getChild(i), treeItem2);
        }
    }

    private static String getNameIn(IElkParser iElkParser) {
        IToken iToken;
        String string = null;
        if (iElkParser instanceof IElkParserExtension && (iToken = ((IElkParserExtension)iElkParser).getNameInToken()) != null) {
            string = iToken.getOriginalWord();
        }
        return string != null ? string : iElkParser.getNameIn();
    }

    private static String getNameOut(IElkParser iElkParser) {
        IToken iToken;
        String string = null;
        if (iElkParser instanceof IElkParserExtension && (iToken = ((IElkParserExtension)iElkParser).getNameOutToken()) != null) {
            string = iToken.getOriginalWord();
        }
        return string != null ? string : iElkParser.getNameOut();
    }

    private static String getName(IElkParser iElkParser) {
        IToken iToken;
        String string = null;
        if (iElkParser instanceof IElkParserExtension && (iToken = ((IElkParserExtension)iElkParser).getNameToken()) != null) {
            string = iToken.getOriginalWord();
        }
        return string != null ? string : iElkParser.getName();
    }

    private void createDataMap(IVariableDeclaration iVariableDeclaration, DataMapItem dataMapItem, DataMapItem dataMapItem2) {
        boolean bl;
        IElkParser iElkParser = iVariableDeclaration.getElkExtraInfo();
        boolean bl2 = bl = dataMapItem2 != null;
        if (bl) {
            if (dataMapItem == null) {
                this.dataMap.put(iVariableDeclaration, dataMapItem2);
            }
            dataMapItem2.vd = iVariableDeclaration;
        } else {
            dataMapItem2 = new DataMapItem(iVariableDeclaration);
            if (iElkParser != null) {
                dataMapItem2.direction = iElkParser.getMode();
                if (dataMapItem2.direction == -1 && dataMapItem != null) {
                    dataMapItem2.direction = dataMapItem.direction;
                }
                dataMapItem2.useGroup = iElkParser.isGroup();
                dataMapItem2.mandatory = iElkParser.isMandatory();
                switch (dataMapItem2.direction) {
                    case 1: {
                        dataMapItem2.nameIn = ServiceEditor.getNameIn((IElkParser)iElkParser);
                        if (dataMapItem2.nameIn == null || dataMapItem2.nameIn.length() == 0) {
                            dataMapItem2.nameIn = ServiceEditor.getName((IElkParser)iElkParser);
                        }
                        dataMapItem2.typeIn = iElkParser.getTypeIn();
                        if (dataMapItem2.typeIn != null && dataMapItem2.typeIn.length() != 0) break;
                        dataMapItem2.typeIn = iElkParser.getType();
                        break;
                    }
                    case 2: {
                        dataMapItem2.nameOut = ServiceEditor.getNameOut((IElkParser)iElkParser);
                        if (dataMapItem2.nameOut == null || dataMapItem2.nameOut.length() == 0) {
                            dataMapItem2.nameOut = ServiceEditor.getName((IElkParser)iElkParser);
                        }
                        dataMapItem2.typeOut = iElkParser.getTypeOut();
                        if (dataMapItem2.typeOut != null && dataMapItem2.typeOut.length() != 0) break;
                        dataMapItem2.typeOut = iElkParser.getType();
                        break;
                    }
                    default: {
                        dataMapItem2.nameIn = ServiceEditor.getNameIn((IElkParser)iElkParser);
                        if (dataMapItem2.nameIn == null || dataMapItem2.nameIn.length() == 0) {
                            dataMapItem2.nameIn = ServiceEditor.getName((IElkParser)iElkParser);
                        }
                        dataMapItem2.nameOut = ServiceEditor.getNameOut((IElkParser)iElkParser);
                        if (dataMapItem2.nameOut == null || dataMapItem2.nameOut.length() == 0) {
                            dataMapItem2.nameOut = ServiceEditor.getName((IElkParser)iElkParser);
                        }
                        dataMapItem2.typeIn = iElkParser.getTypeIn();
                        if (dataMapItem2.typeIn == null || dataMapItem2.typeIn.length() == 0) {
                            dataMapItem2.typeIn = iElkParser.getType();
                        }
                        dataMapItem2.typeOut = iElkParser.getTypeOut();
                        if (dataMapItem2.typeOut != null && dataMapItem2.typeOut.length() != 0) break;
                        dataMapItem2.typeOut = iElkParser.getType();
                    }
                }
                dataMapItem2.value = iElkParser.getValue();
                dataMapItem2.hidden = iElkParser.isHidden();
                if (dataMapItem2.hidden) {
                    dataMapItem2.direction = 0;
                }
            } else {
                dataMapItem2.direction = dataMapItem != null ? dataMapItem.direction : 0;
            }
            if (dataMapItem != null) {
                dataMapItem.addChild(dataMapItem2);
            } else {
                this.dataMap.put(iVariableDeclaration, dataMapItem2);
            }
        }
        IVariableDeclarationList iVariableDeclarationList = iVariableDeclaration.getChildren();
        int n = 0;
        IVariableDeclaration iVariableDeclaration2 = iVariableDeclarationList.getFirst();
        while (iVariableDeclaration2 != null) {
            if (this.isValidChild(iVariableDeclaration2)) {
                this.createDataMap(iVariableDeclaration2, dataMapItem2, bl ? dataMapItem2.getChild(n++) : null);
            }
            iVariableDeclaration2 = iVariableDeclarationList.getNext();
        }
    }

    private boolean isValidChild(IVariableDeclaration iVariableDeclaration) {
        int n = iVariableDeclaration.getLevel();
        if (n != 77 && (n < 1 || n > 49)) {
            return false;
        }
        return !iVariableDeclaration.isInRedefines();
    }

    private static String toString(IVariableDeclaration iVariableDeclaration, boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            int n = iVariableDeclaration.getLevel();
            if (n < 10) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n);
            stringBuilder.append(" ");
        }
        String string2 = iVariableDeclaration.getName();
        stringBuilder.append(string2);
        String string3 = iVariableDeclaration.getPicture();
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(" pic ");
            stringBuilder.append(string3);
        }
        if ((string = iVariableDeclaration.getUsage()) != null && string.length() > 0) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        if (iVariableDeclaration.isOccursClause()) {
            stringBuilder.append(" occurs ");
            if (iVariableDeclaration.isDynamic()) {
                stringBuilder.append("dynamic");
            } else if (iVariableDeclaration.isDepending()) {
                stringBuilder.append(iVariableDeclaration.getOccursMin());
                stringBuilder.append(" to ");
                stringBuilder.append(iVariableDeclaration.getOccursMax());
                stringBuilder.append(" depending on ");
                stringBuilder.append(iVariableDeclaration.getDepending().getName());
            } else {
                stringBuilder.append(iVariableDeclaration.getOccurs());
            }
        }
        return stringBuilder.toString().toLowerCase();
    }

    private void setEnabledAll(boolean bl) {
        this.linkageDecorationLbl.setEnabled(bl);
        this.linkageDecorationCmb.setEnabled(bl);
        this.operationLbl.setEnabled(bl);
        this.operationTbl.setEnabled(bl);
        this.entryPointLbl.setEnabled(bl);
        this.entryPointCmb.setEnabled(bl);
        this.linkageTree.setEnabled(bl);
        this.linkageLbl.setEnabled(bl);
        this.dataMapTree.setEnabled(bl);
        this.dataMapLbl.setEnabled(bl);
        this.editOperationItem.setEnabled(bl && this.operationTbl.getSelectionCount() > 0);
        this.editLinkageItem.setEnabled(bl && this.linkageTree.getSelectionCount() > 0);
        this.editDataMapItem.setEnabled(bl && this.dataMapTree.getSelectionCount() > 0);
        this.deleteDataMapItem.setEnabled(bl && this.dataMapTree.getSelectionCount() > 0);
    }

    public void setFocus() {
        this.serviceSettings.setFocus();
    }

    static /* synthetic */ void access$000(ServiceEditor serviceEditor, boolean bl) {
        serviceEditor.initFields(bl);
    }

    static /* synthetic */ void access$100(ServiceEditor serviceEditor, boolean bl) {
        serviceEditor.setDirty(bl);
    }

    static /* synthetic */ void access$200(ServiceEditor serviceEditor, PropertyChangeEvent propertyChangeEvent) {
        serviceEditor.settingPropertyChanged(propertyChangeEvent);
    }

    static /* synthetic */ Table access$300(ServiceEditor serviceEditor) {
        return serviceEditor.operationTbl;
    }

    static /* synthetic */ Combo access$400(ServiceEditor serviceEditor) {
        return serviceEditor.entryPointCmb;
    }

    static /* synthetic */ void access$500(ServiceEditor serviceEditor) {
        serviceEditor.operationChanged();
    }

    static /* synthetic */ void access$600(ServiceEditor serviceEditor) {
        serviceEditor.editOperation();
    }

    static /* synthetic */ void access$700(ServiceEditor serviceEditor) {
        serviceEditor.editLinkageItem();
    }

    static /* synthetic */ void access$800(ServiceEditor serviceEditor) {
        serviceEditor.editDataMapItem();
    }

    static /* synthetic */ void access$900(ServiceEditor serviceEditor) {
        serviceEditor.deleteDataMapItem();
    }

    static /* synthetic */ void access$1000(ServiceEditor serviceEditor) {
        serviceEditor.linkageItemChanged();
    }

    static /* synthetic */ Tree access$1100(ServiceEditor serviceEditor) {
        return serviceEditor.linkageTree;
    }

    static /* synthetic */ void access$1200(ServiceEditor serviceEditor) {
        serviceEditor.dataMapItemChanged();
    }

    static /* synthetic */ Tree access$1300(ServiceEditor serviceEditor) {
        return serviceEditor.dataMapTree;
    }

    static /* synthetic */ void access$1400(ServiceEditor serviceEditor) {
        serviceEditor.dragLinkageItems();
    }

    static /* synthetic */ void access$1500(ServiceEditor serviceEditor, DropTargetEvent dropTargetEvent) {
        serviceEditor.dropDataMapItems(dropTargetEvent);
    }
}

