/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.servicedesigner;

import com.iscobol.plugins.editor.util.Service;
import com.iscobol.plugins.editor.util.intf.Factory;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ServiceSettingsPanel {
    private Vector<IPropertyChangeListener> listeners = new Vector();
    private Button enableSrvBtn;
    private Button generateBeanBtn;
    private Label beanPrefixLbl;
    private Text beanPrefixTxt;
    private Label beanPackageLbl;
    private Text beanPackageTxt;
    private Label beanUrlLbl;
    private Text beanUrlTxt;
    private Label serviceTypeLbl;
    private Combo serviceTypeCmb;
    private Composite settingsCmp;
    private StackLayout settingsLayout;
    private Group soapGrp;
    private Label soapStyleLbl;
    private Combo soapStyleCmb;
    private Label soapPrefixLbl;
    private Text soapPrefixTxt;
    private Label soapUrlLbl;
    private Text soapUrlTxt;
    private Label soapNsLbl;
    private Text soapNsTxt;
    private Label soapNsSfxLbl;
    private Text soapNsSfxTxt;
    private Label soapCsLbl;
    private Text soapCsTxt;
    private Group restGrp;
    private Label restPrefixLbl;
    private Text restPrefixTxt;
    private Service srv = new Service(Factory.getRuntime(null), Factory.getCompiler(null));

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (!this.listeners.contains(iPropertyChangeListener)) {
            this.listeners.addElement(iPropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.removeElement(iPropertyChangeListener);
    }

    private void firePropertyChange(String string, Object object) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, null, object);
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            iPropertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void initFields(Properties properties) {
        boolean bl = this.srv.getBooleanProperty(properties, "iscobol.compiler.servicebridge");
        this.enableSrvBtn.setSelection(bl);
        String string = this.srv.getProperty(properties, "iscobol.compiler.servicebridge.type");
        for (int i = 0; i < this.serviceTypeCmb.getItemCount(); ++i) {
            if (!this.serviceTypeCmb.getItem(i).equalsIgnoreCase(string)) continue;
            this.serviceTypeCmb.select(i);
            break;
        }
        if (this.serviceTypeCmb.getSelectionIndex() < 0) {
            this.serviceTypeCmb.select(0);
        }
        String string2 = this.srv.getProperty(properties, "iscobol.compiler.servicebridge.bean");
        boolean bl2 = this.serviceTypeCmb.getText().equalsIgnoreCase(string2);
        this.generateBeanBtn.setSelection(bl2);
        this.setBEANEnabledAll(bl2);
        this.beanPrefixTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.bean.prefix"));
        this.beanUrlTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.bean.url"));
        this.beanPackageTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.bean.package"));
        String string3 = this.srv.getProperty(properties, "iscobol.compiler.servicebridge.soap.style");
        for (int i = 0; i < this.soapStyleCmb.getItemCount(); ++i) {
            if (!this.soapStyleCmb.getItem(i).equalsIgnoreCase(string3)) continue;
            this.soapStyleCmb.select(i);
            break;
        }
        if (this.soapStyleCmb.getSelectionIndex() < 0) {
            this.soapStyleCmb.select(0);
        }
        this.soapPrefixTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.soap.prefix"));
        this.soapUrlTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.soap.url"));
        this.soapNsTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.soap.namespace"));
        this.soapNsSfxTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.soap.namespace_suffix"));
        this.soapCsTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.soap.charset"));
        this.restPrefixTxt.setText(this.srv.getProperty(properties, "iscobol.compiler.servicebridge.rest.prefix"));
        this.setEnabledAll(this.enableSrvBtn.getSelection());
        this.showSettingsPanel();
    }

    private void setBEANEnabledAll(boolean bl) {
        this.beanPrefixLbl.setEnabled(bl);
        this.beanPrefixTxt.setEnabled(bl);
        this.beanUrlLbl.setEnabled(bl);
        this.beanUrlTxt.setEnabled(bl);
        this.beanPackageLbl.setEnabled(bl);
        this.beanPackageTxt.setEnabled(bl);
    }

    private Label createLabel(FormToolkit formToolkit, Composite composite, String string) {
        Label label;
        if (formToolkit != null) {
            label = formToolkit.createLabel(composite, string);
        } else {
            label = new Label(composite, 0);
            label.setText(string);
        }
        return label;
    }

    private Text createText(FormToolkit formToolkit, Composite composite, String string, int n) {
        Text text;
        if (formToolkit != null) {
            text = formToolkit.createText(composite, string, n);
        } else {
            text = new Text(composite, n);
            text.setText(string);
        }
        return text;
    }

    private Button createButton(FormToolkit formToolkit, Composite composite, String string, int n) {
        Button button;
        if (formToolkit != null) {
            button = formToolkit.createButton(composite, string, n);
        } else {
            button = new Button(composite, n);
            button.setText(string);
        }
        return button;
    }

    private Composite createComposite(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit != null ? formToolkit.createComposite(composite) : new Composite(composite, 0);
        return composite2;
    }

    private Group createGroup(FormToolkit formToolkit, Composite composite, String string) {
        Group group = new Group(composite, 0);
        if (formToolkit != null) {
            formToolkit.adapt((Composite)group);
        }
        group.setText(string);
        return group;
    }

    public void createPartControl(Composite composite, GridData gridData, FormToolkit formToolkit) {
        Composite composite2 = this.createComposite(formToolkit, composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData2);
        this.serviceTypeLbl = this.createLabel(formToolkit, composite2, "Type:");
        this.serviceTypeCmb = new Combo(composite2, 2056);
        this.serviceTypeCmb.setLayoutData((Object)gridData);
        this.serviceTypeCmb.add("SOAP");
        this.serviceTypeCmb.add("REST");
        this.settingsCmp = this.createComposite(formToolkit, composite);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.settingsCmp.setLayoutData((Object)gridData);
        this.settingsLayout = new StackLayout();
        this.settingsCmp.setLayout((Layout)this.settingsLayout);
        gridData = new GridData(768);
        this.soapGrp = this.createGroup(formToolkit, this.settingsCmp, "Settings");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.soapGrp.setLayout((Layout)gridLayout);
        this.soapGrp.setLayoutData((Object)gridData);
        this.soapStyleLbl = this.createLabel(formToolkit, (Composite)this.soapGrp, "Style:");
        this.soapStyleCmb = new Combo((Composite)this.soapGrp, 2056);
        this.soapStyleCmb.setLayoutData((Object)gridData);
        this.soapStyleCmb.add("RPC");
        this.soapStyleCmb.add("Document");
        this.soapPrefixLbl = this.createLabel(formToolkit, (Composite)this.soapGrp, "Prefix:");
        this.soapPrefixTxt = this.createText(formToolkit, (Composite)this.soapGrp, "", 2048);
        this.soapPrefixTxt.setLayoutData((Object)gridData);
        this.soapUrlLbl = this.createLabel(formToolkit, (Composite)this.soapGrp, "URL:");
        this.soapUrlTxt = this.createText(formToolkit, (Composite)this.soapGrp, "", 2048);
        this.soapUrlTxt.setLayoutData((Object)gridData);
        this.soapNsLbl = this.createLabel(formToolkit, (Composite)this.soapGrp, "Namespace:");
        this.soapNsTxt = this.createText(formToolkit, (Composite)this.soapGrp, "", 2048);
        this.soapNsTxt.setLayoutData((Object)gridData);
        this.soapNsSfxLbl = this.createLabel(formToolkit, (Composite)this.soapGrp, "Namespace suffix:");
        this.soapNsSfxTxt = this.createText(formToolkit, (Composite)this.soapGrp, "", 2048);
        this.soapNsSfxTxt.setLayoutData((Object)gridData);
        this.soapCsLbl = this.createLabel(formToolkit, (Composite)this.soapGrp, "Charset:");
        this.soapCsTxt = this.createText(formToolkit, (Composite)this.soapGrp, "", 2048);
        this.soapCsTxt.setLayoutData((Object)gridData);
        this.restGrp = this.createGroup(formToolkit, this.settingsCmp, "Settings");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.restGrp.setLayout((Layout)gridLayout);
        this.restGrp.setLayoutData((Object)gridData);
        this.restPrefixLbl = this.createLabel(formToolkit, (Composite)this.restGrp, "Prefix:");
        this.restPrefixTxt = this.createText(formToolkit, (Composite)this.restGrp, "", 2048);
        this.restPrefixTxt.setLayoutData((Object)gridData);
        composite2 = this.createComposite(formToolkit, composite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData2);
        this.generateBeanBtn = this.createButton(formToolkit, composite2, "", 32);
        gridData2 = new GridData();
        gridData2.verticalAlignment = 128;
        gridData2.verticalIndent = 2;
        this.generateBeanBtn.setLayoutData((Object)gridData2);
        Group group = this.createGroup(formToolkit, composite2, "Generate Java-Bean");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        gridData2 = new GridData(768);
        group.setLayoutData((Object)gridData2);
        this.beanPrefixLbl = this.createLabel(formToolkit, (Composite)group, "Prefix:");
        this.beanPrefixTxt = this.createText(formToolkit, (Composite)group, "", 2048);
        this.beanUrlLbl = this.createLabel(formToolkit, (Composite)group, "URL:");
        this.beanUrlTxt = this.createText(formToolkit, (Composite)group, "", 2048);
        this.beanPackageLbl = this.createLabel(formToolkit, (Composite)group, "Package:");
        this.beanPackageTxt = this.createText(formToolkit, (Composite)group, "", 2048);
        gridData2 = new GridData(768);
        this.beanPrefixTxt.setLayoutData((Object)gridData2);
        this.beanUrlTxt.setLayoutData((Object)gridData2);
        this.beanPackageTxt.setLayoutData((Object)gridData2);
    }

    public void createEnableServiceButton(Composite composite, FormToolkit formToolkit) {
        this.enableSrvBtn = this.createButton(formToolkit, composite, "Enable Service", 32);
    }

    private void serviceTypeChanged() {
        this.showSettingsPanel();
        this.firePropertyChange("iscobol.compiler.servicebridge.type", (Object)this.serviceTypeCmb.getText());
    }

    private boolean isServiceEnabled() {
        return this.enableSrvBtn == null || this.enableSrvBtn.getSelection();
    }

    private void restPrefixChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.rest.prefix", (Object)this.restPrefixTxt.getText());
    }

    private void soapNsChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.soap.namespace", (Object)this.soapNsTxt.getText());
    }

    private void soapNsSfxChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.soap.namespace_suffix", (Object)this.soapNsSfxTxt.getText());
    }

    private void soapCsChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.soap.charset", (Object)this.soapCsTxt.getText());
    }

    private void soapPrefixChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.soap.prefix", (Object)this.soapPrefixTxt.getText());
    }

    private void soapUrlChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.soap.url", (Object)this.soapUrlTxt.getText());
    }

    private void soapStyleChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.soap.style", (Object)this.soapStyleCmb.getText());
    }

    private void showSettingsPanel() {
        switch (this.serviceTypeCmb.getSelectionIndex()) {
            case 0: {
                this.setSOAPEnabledAll(this.isServiceEnabled());
                this.setRESTEnabledAll(false);
                this.settingsLayout.topControl = this.soapGrp;
                break;
            }
            case 1: {
                this.setSOAPEnabledAll(false);
                this.setRESTEnabledAll(this.isServiceEnabled());
                this.settingsLayout.topControl = this.restGrp;
            }
        }
        this.settingsCmp.layout();
    }

    private void setSOAPEnabledAll(boolean bl) {
        this.soapGrp.setEnabled(bl);
        this.soapStyleLbl.setEnabled(bl);
        this.soapStyleCmb.setEnabled(bl);
        this.soapUrlLbl.setEnabled(bl);
        this.soapUrlTxt.setEnabled(bl);
        this.soapNsLbl.setEnabled(bl);
        this.soapNsTxt.setEnabled(bl);
        this.soapNsSfxLbl.setEnabled(bl);
        this.soapNsSfxTxt.setEnabled(bl);
        this.soapCsLbl.setEnabled(bl);
        this.soapCsTxt.setEnabled(bl);
        this.soapPrefixLbl.setEnabled(bl);
        this.soapPrefixTxt.setEnabled(bl);
    }

    private void setRESTEnabledAll(boolean bl) {
        this.restGrp.setEnabled(bl);
        this.restPrefixLbl.setEnabled(bl);
        this.restPrefixTxt.setEnabled(bl);
    }

    private void serviceEnableChanged() {
        this.setEnabledAll(this.enableSrvBtn.getSelection());
        this.firePropertyChange("iscobol.compiler.servicebridge", (Object)new Boolean(this.enableSrvBtn.getSelection()));
    }

    private void setEnabledAll(boolean bl) {
        this.soapGrp.setEnabled(bl);
        this.serviceTypeLbl.setEnabled(bl);
        this.serviceTypeCmb.setEnabled(bl);
        this.generateBeanBtn.setEnabled(bl);
        this.setBEANEnabledAll(bl && this.generateBeanBtn.getSelection());
        this.setSOAPEnabledAll(bl && this.serviceTypeCmb.getSelectionIndex() == 0);
        this.setRESTEnabledAll(bl && this.serviceTypeCmb.getSelectionIndex() == 1);
    }

    public void addListeners() {
        if (this.enableSrvBtn != null) {
            this.enableSrvBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.serviceTypeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.generateBeanBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.beanPrefixTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.beanUrlTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.beanPackageTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.soapStyleCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.soapUrlTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.soapPrefixTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.soapNsTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.soapNsSfxTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.soapCsTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.restPrefixTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void beanUrlChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.bean.url", (Object)this.beanUrlTxt.getText());
    }

    private void beanPackageChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.bean.package", (Object)this.beanPackageTxt.getText());
    }

    private void beanPrefixChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.bean.prefix", (Object)this.beanPrefixTxt.getText());
    }

    private void generateBeanChanged() {
        this.firePropertyChange("iscobol.compiler.servicebridge.bean", (Object)(this.generateBeanBtn.getSelection() ? this.serviceTypeCmb.getText() : ""));
        this.setBEANEnabledAll(this.generateBeanBtn.getSelection());
    }

    public void setFocus() {
        if (this.enableSrvBtn != null) {
            this.enableSrvBtn.setFocus();
        } else {
            this.serviceTypeCmb.setFocus();
        }
    }

    static /* synthetic */ void access$000(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.serviceEnableChanged();
    }

    static /* synthetic */ void access$100(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.serviceTypeChanged();
    }

    static /* synthetic */ void access$200(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.generateBeanChanged();
    }

    static /* synthetic */ void access$300(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.beanPrefixChanged();
    }

    static /* synthetic */ void access$400(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.beanUrlChanged();
    }

    static /* synthetic */ void access$500(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.beanPackageChanged();
    }

    static /* synthetic */ void access$600(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.soapStyleChanged();
    }

    static /* synthetic */ void access$700(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.soapUrlChanged();
    }

    static /* synthetic */ void access$800(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.soapPrefixChanged();
    }

    static /* synthetic */ void access$900(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.soapNsChanged();
    }

    static /* synthetic */ void access$1000(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.soapNsSfxChanged();
    }

    static /* synthetic */ void access$1100(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.soapCsChanged();
    }

    static /* synthetic */ void access$1200(ServiceSettingsPanel serviceSettingsPanel) {
        serviceSettingsPanel.restPrefixChanged();
    }
}

