/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.servicedesigner.dialogs;

import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.servicedesigner.DataMapItem;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataMapDialog
extends Dialog {
    private Text dataItemTxt;
    private Combo directionCmb;
    private Combo typeCmb;
    private Text nameTxt;
    private Button useGroupBtn;
    private Button mandatoryBtn;
    private DataMapItem dataItem;
    private boolean ok;
    private int ioDirection;
    private boolean changedDataMapStructure;
    private Set<String> elkTypes;

    public DataMapDialog(Shell shell, DataMapItem dataMapItem, int n, Set<String> set) {
        super(shell);
        this.dataItem = dataMapItem;
        this.ioDirection = n;
        this.elkTypes = set;
    }

    public boolean isChangedDataMapStructure() {
        return this.changedDataMapStructure;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        boolean bl = this.dataItem.useGroup || this.dataItem.getChildCount() == 0;
        String[] stringArray = this.elkTypes.toArray(new String[this.elkTypes.size()]);
        Label label = new Label(composite2, 0);
        label.setText("Data Item:");
        this.dataItemTxt = new Text(composite2, 2048);
        this.dataItemTxt.setEditable(false);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.dataItemTxt.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Direction:");
        this.directionCmb = new Combo(composite2, 2056);
        this.directionCmb.setItems(new String[]{"input", "output"});
        gridData = new GridData();
        gridData.widthHint = 100;
        this.directionCmb.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Name:");
        this.nameTxt = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.widthHint = 150;
        this.nameTxt.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Type:");
        this.typeCmb = new Combo(composite2, 2056);
        this.typeCmb.setItems(stringArray);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.typeCmb.setLayoutData((Object)gridData);
        this.typeCmb.setEnabled(bl);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.useGroupBtn = new Button(composite3, 32);
        this.useGroupBtn.setText("Use Group");
        this.useGroupBtn.setEnabled(this.dataItem.getChildCount() > 0);
        this.mandatoryBtn = new Button(composite3, 32);
        this.mandatoryBtn.setText("Mandatory");
        this.mandatoryBtn.setEnabled(this.dataItem.getChildCount() == 0);
        this.dataItemTxt.setText(this.dataItem.vd.getName());
        block0 : switch (this.dataItem.direction) {
            case 1: {
                this.setInput();
                break;
            }
            case 2: {
                this.setOutput();
                break;
            }
            default: {
                switch (this.ioDirection) {
                    default: {
                        this.setInput();
                        break block0;
                    }
                    case 2: 
                }
                this.setOutput();
            }
        }
        this.useGroupBtn.setSelection(this.dataItem.useGroup);
        this.useGroupBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mandatoryBtn.setSelection(this.dataItem.mandatory);
        return composite2;
    }

    private void setInput() {
        String string;
        this.directionCmb.select(0);
        if (this.dataItem.nameIn != null) {
            this.nameTxt.setText(this.dataItem.nameIn);
        }
        if ((string = this.dataItem.typeIn) == null) {
            string = this.dataItem.vd.getUsageElk();
        }
        this.selectItem(this.typeCmb, string);
    }

    private void setOutput() {
        String string;
        this.directionCmb.select(1);
        if (this.dataItem.nameOut != null) {
            this.nameTxt.setText(this.dataItem.nameOut);
        }
        if ((string = this.dataItem.typeOut) == null) {
            string = this.dataItem.vd.getUsageElk();
        }
        this.selectItem(this.typeCmb, string);
    }

    private void selectItem(Combo combo, String string) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!combo.getItem(i).equals(string)) continue;
            combo.select(i);
            break;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Data Map");
    }

    public void okPressed() {
        String string = this.validateMask();
        if (string != null) {
            PluginUtilities.logError((String)string);
            return;
        }
        boolean bl = this.dataItem.getChildCount() > 0 ? this.useGroupBtn.getSelection() : false;
        if (this.dataItem.getChildCount() == 0) {
            this.dataItem.mandatory = this.mandatoryBtn.getSelection();
        }
        if (this.dataItem.useGroup != bl) {
            this.dataItem.useGroup = bl;
            this.changedDataMapStructure = true;
        }
        if (this.dataItem.direction != 0) {
            int n;
            switch (this.directionCmb.getSelectionIndex()) {
                default: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                }
            }
            if (n != this.dataItem.direction) {
                DataMapItem.changeDirection((DataMapItem)this.dataItem, (int)this.dataItem.direction, (int)n);
                this.changedDataMapStructure = true;
            }
        }
        String string2 = this.nameTxt.getText().length() > 0 ? this.nameTxt.getText() : null;
        block3 : switch (this.dataItem.direction) {
            case 1: {
                this.dataItem.nameIn = string2;
                break;
            }
            case 2: {
                this.dataItem.nameOut = string2;
                break;
            }
            default: {
                switch (this.ioDirection) {
                    case 2: {
                        this.dataItem.nameOut = string2;
                        break block3;
                    }
                    case 1: {
                        this.dataItem.nameIn = string2;
                    }
                }
            }
        }
        if (this.dataItem.getChildCount() == 0 || this.useGroupBtn.getSelection()) {
            String string3 = this.typeCmb.getText();
            if (string3.equals(this.dataItem.vd.getUsageElk())) {
                string3 = null;
            }
            block11 : switch (this.dataItem.direction) {
                case 1: {
                    this.dataItem.typeIn = string3;
                    break;
                }
                case 2: {
                    this.dataItem.typeOut = string3;
                    break;
                }
                default: {
                    switch (this.ioDirection) {
                        case 2: {
                            this.dataItem.typeOut = string3;
                            break block11;
                        }
                        case 1: {
                            this.dataItem.typeIn = string3;
                        }
                    }
                    break;
                }
            }
        } else {
            this.dataItem.typeOut = null;
            this.dataItem.typeIn = null;
        }
        this.ok = true;
        super.okPressed();
    }

    private String validateMask() {
        char c;
        String string = this.nameTxt.getText();
        if (string.length() > 2 && ((c = string.charAt(0)) == '\"' || c == '\'') && string.charAt(string.length() - 1) == c) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.length() > 0 && !PluginUtilities.isValidIdentifier((String)string)) {
            return "Invalid Name";
        }
        if (this.dataItem.direction == 0) {
            if (this.directionCmb.getSelectionIndex() == 0 && this.ioDirection == 2) {
                return "Input direction already set for this item";
            }
            if (this.directionCmb.getSelectionIndex() == 1 && this.ioDirection == 1) {
                return "Output direction already set for this item";
            }
        }
        return null;
    }

    public boolean openDialog() {
        this.open();
        return this.ok;
    }

    static /* synthetic */ Button access$000(DataMapDialog dataMapDialog) {
        return dataMapDialog.useGroupBtn;
    }

    static /* synthetic */ Combo access$100(DataMapDialog dataMapDialog) {
        return dataMapDialog.typeCmb;
    }
}

