/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.servicedesigner.dialogs;

import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.servicedesigner.DataMapItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LinkageItemDialog
extends Dialog {
    private DataMapItem dataItem;
    private String value;
    private boolean ok;
    private Text valueTxt;

    public LinkageItemDialog(Shell shell, DataMapItem dataMapItem, String string) {
        super(shell);
        this.dataItem = dataMapItem;
        this.value = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Data Item");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Data Item:");
        Text text = new Text(composite2, 2048);
        text.setEditable(false);
        text.setText(this.dataItem.vd.getName());
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        text.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Value:");
        this.valueTxt = new Text(composite2, 2048);
        if (this.value != null) {
            this.valueTxt.setText(this.value);
        }
        this.valueTxt.setLayoutData((Object)gridData);
        return composite2;
    }

    public void okPressed() {
        this.value = this.valueTxt.getText();
        String string = this.validateValue();
        if (string != null) {
            PluginUtilities.logError((String)string);
            return;
        }
        this.dataItem.value = this.value.length() > 0 ? this.value : null;
        this.ok = true;
        super.okPressed();
    }

    private String validateValue() {
        if (!(this.value.length() <= 0 || this.value.startsWith("\"") && this.value.endsWith("\"") || this.value.startsWith("'") && this.value.endsWith("'"))) {
            try {
                Double.parseDouble(this.value.replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
                return "Invalid Value: required string or numeric value";
            }
        }
        return null;
    }

    public boolean openDialog() {
        this.open();
        return this.ok;
    }
}

