/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.servicedesigner.dialogs;

import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OperationDialog
extends Dialog {
    private String entryPoint;
    private String operation;
    private String operationType;
    private boolean ok;
    private Text operationTxt;
    private Combo operationTypeCmb;

    public OperationDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        this.entryPoint = string;
        this.operation = string2;
        this.operationType = string3;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Operation");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Entry Point:");
        Text text = new Text(composite2, 2048);
        text.setEditable(false);
        text.setText(this.entryPoint);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        text.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Operation:");
        this.operationTxt = new Text(composite2, 2048);
        if (this.operation != null) {
            this.operationTxt.setText(this.operation);
        }
        this.operationTxt.setLayoutData((Object)gridData);
        if (this.operationType != null) {
            label = new Label(composite2, 0);
            label.setText("Operation Type:");
            this.operationTypeCmb = new Combo(composite2, 2056);
            this.operationTypeCmb.setItems(new String[]{"GET", "POST", "PUT", "PATCH", "DELETE"});
            this.operationTypeCmb.setText(this.operationType);
            this.operationTypeCmb.setLayoutData((Object)gridData);
        }
        return composite2;
    }

    public void okPressed() {
        String string = this.validateOperation();
        if (string != null) {
            PluginUtilities.logError((String)string);
            return;
        }
        this.operation = this.operationTxt.getText();
        if (this.operationType != null) {
            this.operationType = this.operationTypeCmb.getText();
        }
        this.ok = true;
        super.okPressed();
    }

    private String validateOperation() {
        String string = this.operationTxt.getText();
        if (string.length() == 0) {
            return "Insert Operation name";
        }
        if (!PluginUtilities.isValidIdentifier((String)string)) {
            return "Invalid Operation name";
        }
        return null;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public boolean openDialog() {
        this.open();
        return this.ok;
    }
}

