/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.servicedesigner.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ServiceInterfacePage1
extends WizardPage {
    private Tree projectTree;
    private Tree fileTree;
    private Button selectAll;
    private Button deselectAll;
    private IStructuredSelection selection;
    private Vector<IPropertyChangeListener> listeners = new Vector();
    private IProject selectedProject;
    private static final String SELECT_FILE = "Select a Source File";

    protected ServiceInterfacePage1(IStructuredSelection iStructuredSelection) {
        super("ServiceInterfacePage1");
        this.setTitle("Service Interface");
        this.setDescription("Select source files");
        this.selection = iStructuredSelection;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (!this.listeners.contains(iPropertyChangeListener)) {
            this.listeners.addElement(iPropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.removeElement(iPropertyChangeListener);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("isCOBOL Projects");
        group.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        this.projectTree = new Tree((Composite)group, 2048);
        this.projectTree.setLayoutData((Object)new GridData(1808));
        Group group2 = new Group(composite2, 0);
        group2.setText("Source files");
        group2.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        this.fileTree = new Tree((Composite)group2, 2080);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.fileTree.setLayoutData((Object)gridData);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (IProject iProject : iProjectArray) {
            try {
                if (!iProject.isOpen() || iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") == null) continue;
                TreeItem treeItem = new TreeItem(this.projectTree, 0);
                treeItem.setText(iProject.getName());
                treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
                treeItem.setData((Object)iProject);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (this.selection != null) {
            for (Object e : this.selection.toList()) {
                IProject iProject;
                if (e instanceof IProject) {
                    if (this.selectedProject != null) continue;
                    this.selectedProject = this.selectProject((IProject)e);
                    continue;
                }
                if (e instanceof IFolder) {
                    if (this.selectedProject != null) continue;
                    this.selectedProject = this.selectProject(((IFolder)e).getProject());
                    continue;
                }
                if (e instanceof IscobolProjectAdapter) {
                    if (this.selectedProject != null) continue;
                    this.selectedProject = this.selectProject(((IscobolProjectAdapter)e).getProject());
                    continue;
                }
                if (!(e instanceof IFile)) continue;
                IFile iFile = (IFile)e;
                if (this.selectedProject == null) {
                    this.selectedProject = this.selectProject(iFile.getProject());
                }
                if (iFile.getProject() != this.selectedProject) continue;
                iProject = iFile.getProjectRelativePath().removeFirstSegments(1);
                PluginUtilities.setTreeSelection((TreeItem[])this.fileTree.getItems(), (IPath)iProject, (boolean)true);
            }
            if (this.selectedProject != null && !this.listeners.isEmpty()) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, "project", null, (Object)this.selectedProject);
                for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
                    iPropertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }
        }
        this.projectTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectAll = new Button((Composite)group2, 8);
        this.selectAll.setText(IsresourceBundle.getString((String)"select_all_lbl"));
        this.selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deselectAll = new Button((Composite)group2, 8);
        this.deselectAll.setText(IsresourceBundle.getString((String)"deselect_all_lbl"));
        this.deselectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.validatePage();
        this.setControl((Control)composite2);
    }

    private void validatePage() {
        if (!this.hasSelectedFiles()) {
            this.setErrorMessage(SELECT_FILE);
            this.setPageComplete(false);
        }
    }

    private IProject selectProject(IProject iProject) {
        for (TreeItem treeItem : this.projectTree.getItems()) {
            if (!treeItem.getText().equals(iProject.getName())) continue;
            this.projectTree.select(treeItem);
            this.loadFileTree(iProject);
            break;
        }
        return iProject;
    }

    private void loadFileTree(IProject iProject) {
        this.fileTree.removeAll();
        try {
            IContainer iContainer = PluginUtilities.getSourceFolder((IProject)iProject);
            this.loadFileTree(iContainer, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void loadFileTree(IContainer iContainer, TreeItem treeItem) {
        try {
            IResource[] iResourceArray;
            for (IResource iResource : iResourceArray = iContainer.members()) {
                TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(this.fileTree, 0);
                treeItem2.setText(iResource.getName());
                treeItem2.setData((Object)iResource);
                if (iResource instanceof IFolder) {
                    treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
                    this.loadFileTree((IContainer)((IFolder)iResource), treeItem2);
                    continue;
                }
                treeItem2.setImage(PluginUtilities.getFileTreeItemImage((String)iResource.getName()));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void setSelected(boolean bl) {
        for (TreeItem treeItem : this.fileTree.getItems()) {
            treeItem.setChecked(bl);
            PluginUtilities.checkItems((TreeItem)treeItem, (boolean)bl);
        }
    }

    public List<IFile> getSelectedFiles() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        this.getSelectedFiles(this.fileTree.getItems(), arrayList);
        return arrayList;
    }

    private void getSelectedFiles(TreeItem[] treeItemArray, List<IFile> list) {
        for (TreeItem treeItem : treeItemArray) {
            if (!treeItem.getChecked()) continue;
            IResource iResource = (IResource)treeItem.getData();
            if (iResource instanceof IFile) {
                list.add((IFile)iResource);
                continue;
            }
            this.getSelectedFiles(treeItem.getItems(), list);
        }
    }

    private boolean hasSelectedFiles() {
        for (TreeItem treeItem : this.fileTree.getItems()) {
            if (!treeItem.getChecked() && !treeItem.getGrayed()) continue;
            return true;
        }
        return false;
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    static /* synthetic */ Tree access$000(ServiceInterfacePage1 serviceInterfacePage1) {
        return serviceInterfacePage1.projectTree;
    }

    static /* synthetic */ IProject access$100(ServiceInterfacePage1 serviceInterfacePage1) {
        return serviceInterfacePage1.selectedProject;
    }

    static /* synthetic */ IProject access$102(ServiceInterfacePage1 serviceInterfacePage1, IProject iProject) {
        serviceInterfacePage1.selectedProject = iProject;
        return serviceInterfacePage1.selectedProject;
    }

    static /* synthetic */ void access$200(ServiceInterfacePage1 serviceInterfacePage1, IProject iProject) {
        serviceInterfacePage1.loadFileTree(iProject);
    }

    static /* synthetic */ Vector access$300(ServiceInterfacePage1 serviceInterfacePage1) {
        return serviceInterfacePage1.listeners;
    }

    static /* synthetic */ void access$400(ServiceInterfacePage1 serviceInterfacePage1) {
        serviceInterfacePage1.validatePage();
    }

    static /* synthetic */ void access$500(ServiceInterfacePage1 serviceInterfacePage1, boolean bl) {
        serviceInterfacePage1.setSelected(bl);
    }
}

