/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.eclipse.joe.editors;

import com.veryant.eclipse.joe.editors.JoeDoubleClickStrategy;
import com.veryant.eclipse.joe.editors.JoeEditor;
import com.veryant.eclipse.joe.editors.JoeScanner;
import com.veryant.eclipse.joe.editors.NonRuleBasedDamagerRepairer;
import com.veryant.eclipse.joe.util.ColorManager;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class JoeConfiguration
extends SourceViewerConfiguration {
    private JoeDoubleClickStrategy doubleClickStrategy;
    private JoeScanner scanner;
    private ColorManager colorManager;
    private JoeEditor editor;
    private IAnnotationHover annotationHover;

    public JoeConfiguration(ColorManager colorManager, JoeEditor joeEditor) {
        this.colorManager = colorManager;
        this.editor = joeEditor;
    }

    public JoeEditor getJoeEditor() {
        return this.editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__joe_ml_comment"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new JoeDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected JoeScanner getJoeScanner() {
        if (this.scanner == null) {
            this.scanner = new JoeScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(this.colorManager.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getJoeScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer nonRuleBasedDamagerRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(this.colorManager.COMMENT)));
        presentationReconciler.setDamager((IPresentationDamager)nonRuleBasedDamagerRepairer, "__joe_ml_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)nonRuleBasedDamagerRepairer, "__joe_ml_comment");
        return presentationReconciler;
    }

    private Annotation[] findAnnotations(ISourceViewer iSourceViewer, int n) {
        try {
            IRegion iRegion = iSourceViewer.getDocument().getLineInformation(n);
            IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
            if (iAnnotationModel != null) {
                Iterator iterator = iAnnotationModel.getAnnotationIterator();
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
                while (iterator.hasNext()) {
                    Annotation annotation = (Annotation)iterator.next();
                    Position position = iAnnotationModel.getPosition(annotation);
                    if (position == null || !position.overlapsWith(iRegion.getOffset(), iRegion.getLength())) continue;
                    arrayList.add(annotation);
                }
                return arrayList.toArray(new Annotation[arrayList.size()]);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Annotation[0];
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        if (this.annotationHover == null) {
            this.annotationHover = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.annotationHover;
    }

    static /* synthetic */ Annotation[] access$000(JoeConfiguration joeConfiguration, ISourceViewer iSourceViewer, int n) {
        return joeConfiguration.findAnnotations(iSourceViewer, n);
    }
}

