/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.eclipse.joe.editors;

import com.veryant.eclipse.joe.editors.JoeConfiguration;
import com.veryant.eclipse.joe.editors.JoeDocumentProvider;
import com.veryant.eclipse.joe.editors.annotations.JoeProblemAnnotation;
import com.veryant.eclipse.joe.editors.annotations.JoeSpellingProblem;
import com.veryant.eclipse.joe.util.ColorManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class JoeEditor
extends TextEditor {
    public static final String ID = "com.veryant.eclipse.joe.joeEditor";
    private ProjectionSupport projectionSupport;
    private ColorManager colorManager;
    private HashMap<Position, JoeProblemAnnotation> problemAnnotations = new HashMap();
    private Annotation[] oldAnnotations;
    private ProjectionAnnotationModel annotationModel;

    public JoeEditor() {
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JoeConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new JoeDocumentProvider(this.colorManager));
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public SourceViewer getTextViewer() {
        return (SourceViewer)super.getSourceViewer();
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        projectionViewer.doOperation(19);
        this.annotationModel = projectionViewer.getProjectionAnnotationModel();
    }

    public void updateFoldingStructure(ArrayList arrayList) {
        Annotation[] annotationArray = new Annotation[arrayList.size()];
        HashMap hashMap = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            ProjectionAnnotation projectionAnnotation = new ProjectionAnnotation();
            hashMap.put(projectionAnnotation, arrayList.get(i));
            annotationArray[i] = projectionAnnotation;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, hashMap, null);
        this.oldAnnotations = annotationArray;
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        ProjectionViewer projectionViewer = new ProjectionViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
        this.getSourceViewerDecorationSupport((ISourceViewer)projectionViewer);
        return projectionViewer;
    }

    public void putProblemAnnotation(int n, int n2, String string, JoeProblemAnnotation joeProblemAnnotation) {
        this.getEditorSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void putProblemAnnotation(Position position, int n, int n2, String string, JoeProblemAnnotation joeProblemAnnotation, IAnnotationModel iAnnotationModel) {
        try {
            if (iAnnotationModel != null) {
                SpellingAnnotation spellingAnnotation = new SpellingAnnotation((SpellingProblem)new JoeSpellingProblem(n, n2, string));
                joeProblemAnnotation.setSpellingAnnotation(spellingAnnotation);
                iAnnotationModel.addAnnotation((Annotation)spellingAnnotation, position);
                iAnnotationModel.addAnnotation((Annotation)joeProblemAnnotation, position);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearProblemAnnotations() {
        this.getEditorSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void clearProblemAnnotations(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel != null) {
            ArrayList<JoeProblemAnnotation> arrayList = new ArrayList<JoeProblemAnnotation>();
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof JoeProblemAnnotation)) continue;
                arrayList.add((JoeProblemAnnotation)e);
            }
            for (JoeProblemAnnotation joeProblemAnnotation : arrayList) {
                iAnnotationModel.removeAnnotation((Annotation)joeProblemAnnotation.getSpellingAnnotation());
                iAnnotationModel.removeAnnotation((Annotation)joeProblemAnnotation);
            }
        }
    }

    static /* synthetic */ ISourceViewer access$000(JoeEditor joeEditor) {
        return joeEditor.getSourceViewer();
    }

    static /* synthetic */ HashMap access$100(JoeEditor joeEditor) {
        return joeEditor.problemAnnotations;
    }

    static /* synthetic */ ISourceViewer access$200(JoeEditor joeEditor) {
        return joeEditor.getSourceViewer();
    }
}

