/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.eclipse.joe.handlers;

import com.veryant.eclipse.joe.editors.JoeEditor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveBlockCommentHandler
extends AbstractHandler {
    private final Pattern commentPtn = Pattern.compile("(?s)/\\*.*?\\*/");

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        if (iEditorPart instanceof JoeEditor) {
            JoeEditor joeEditor = (JoeEditor)iEditorPart;
            SourceViewer sourceViewer = joeEditor.getTextViewer();
            StyledText styledText = sourceViewer.getTextWidget();
            int[] nArray = styledText.getSelectionRanges();
            if (nArray.length == 0) {
                nArray = new int[]{styledText.getCaretOffset(), styledText.getCaretOffset()};
            }
            int n = nArray[0];
            int n2 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
            IDocument iDocument = sourceViewer.getDocument();
            String string = iDocument.get();
            Matcher matcher = this.commentPtn.matcher(string);
            IUndoManager iUndoManager = sourceViewer.getUndoManager();
            iUndoManager.beginCompoundChange();
            int n3 = 0;
            while (matcher.find()) {
                if ((matcher.start() > n || matcher.end() < n) && (matcher.start() > n2 || matcher.end() < n2)) continue;
                styledText.replaceTextRange(matcher.start() - n3, 2, "");
                styledText.replaceTextRange(matcher.end() - n3 - 4, 2, "");
                n3 += 4;
            }
            iUndoManager.endCompoundChange();
        }
        return null;
    }
}

