/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.eclipse.joe.util;

import com.iscobol.plugins.editor.util.PreferenceConverter;
import com.veryant.eclipse.joe.JoeEclipsePlugin;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    public final RGB STRING;
    public final RGB COMMENT;
    public final RGB DIRECTIVE;
    public final RGB DEFAULT = new RGB(0, 0, 0);
    public final RGB COMMAND;
    protected Map fColorTable = new HashMap(10);

    public ColorManager() {
        IPreferenceStore iPreferenceStore = JoeEclipsePlugin.getDefault().getPreferenceStore();
        this.STRING = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"joe.syntaxcoloring.string.foreground");
        this.COMMAND = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"joe.syntaxcoloring.command.foreground");
        this.COMMENT = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"joe.syntaxcoloring.comment.foreground");
        this.DIRECTIVE = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"joe.syntaxcoloring.directive.foreground");
    }

    public void dispose() {
        Iterator iterator = this.fColorTable.values().iterator();
        while (iterator.hasNext()) {
            ((Color)iterator.next()).dispose();
        }
    }

    public Color getColor(RGB rGB) {
        Color color = (Color)this.fColorTable.get(rGB);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rGB);
            this.fColorTable.put(rGB, color);
        }
        return color;
    }
}

