      *>-----------------------------------------------------------
      *> isCOBOL Database Bridge 2020 R2 build#1023.11-20210311-31331
      *> Copyright (c) 2005 - 2020 Veryant
      *> Users of isCOBOL Database Bridge may freely modify and
      *> redistribute this program.
      *>-----------------------------------------------------------

      *>***************************************************
      *> ident=" @(#) EDBI-CONNECT.cbl 12/02/15 #40 Veryant   "
      *> rcsid="$Id: EDBI-CONNECT.cbl,v 1.1.1.1 2012/10/12 14:22:48 daniela Exp $"
      *>***************************************************
       IDENTIFICATION DIVISION.
       PROGRAM-ID.      EDBI-CONNECT.
       AUTHOR.          isCOBOL Database Bridge.
       DATA DIVISION.
      *>-----------------------------------------------------------
       WORKING-STORAGE SECTION.
           EXEC SQL INCLUDE SQLCA END-EXEC.
       77  EDBI-CONNDB        PIC 9 VALUE 0.
       77  CONNECTION         PIC X(80).
       77  NEW-RUNUNIT        PIC X EXTERNAL.
       01  STRING-CONUM.
           05  FILLER         PIC x(10) VALUE "EDBI.CONN.".
           05  NUM-CONAME     PIC 999 VALUE 0.
       01  STRING-CONAME.
           03  FILLER         PIC X(13) VALUE "EDBI.CONNECT.".
           03  ACT-CONAME     PIC X(255).
       01  STRING-ANSIDB.
           05  FILLER         PIC x(10) VALUE "EDBI.ANSI.".
           03  ANS-CONAME     PIC X(255).
            
       77  EDBI-DATABASE-TYPE PIC XXX  EXTERNAL.
       77  EDBI-DATABASE-ANSI PIC X  EXTERNAL.
       77  EDBI-AUTOCOMMIT    PIC X(1).
       88  IS-AUTOCOMMIT VALUE "t", "T", "y", "Y", " ", "1", "2", "3",
                               "4", "5", "6", "7", "8", "9".
           COPY "DATE-ENV.wrk".

       LINKAGE SECTION.
       01  RET-CODE               PIC S9(9) COMP-5.
       01  RET-ERMC               PIC X(254).
       01  BUF-RET REDEFINES RET-ERMC.
           02  INP-CONAME         PIC X(200).
           02  AUTOCOMMIT         PIC X.
           02  FILLER             PIC X(53).

       PROCEDURE DIVISION USING RET-CODE RET-ERMC.
       MAIN-PROG.
           MOVE INP-CONAME TO ACT-CONAME
           ACCEPT CONNECTION FROM ENVIRONMENT STRING-CONAME
           ACCEPT NUM-CONAME FROM ENVIRONMENT "EDBI.NUM.CONNECTION"
           IF CONNECTION NOT = "XXXXX"
              PERFORM  GET-DATE-ENV
              EXEC SQL SET CONNECTION :ACT-CONAME
              END-EXEC
              IF SQLCODE NOT = 0
                 EXEC SQL CONNECT AS :ACT-CONAME
                 END-EXEC
                 MOVE SQLCODE  TO RET-CODE
                 MOVE SQLERRMC TO RET-ERMC
              END-IF
              IF SQLCODE = 0
                 PERFORM SET-CONNECTION-ENV
              END-IF
           ELSE
              IF NEW-RUNUNIT NOT = "N"
                 PERFORM GET-DATE-ENV
                 PERFORM SET-CONNECTION-ENV
              END-IF
              EXEC SQL SET CONNECTION :ACT-CONAME
              END-EXEC
              IF SQLCODE NOT = 0
                 EXEC SQL CONNECT AS :ACT-CONAME
                 END-EXEC
                 MOVE SQLCODE  TO RET-CODE
                 MOVE SQLERRMC TO RET-ERMC
                 IF SQLCODE = 0
                    PERFORM SET-CONNECTION-ENV
                 END-IF
              ELSE
                 IF EDBI-DATABASE-TYPE = "IFX"
                    MOVE ACT-CONAME TO ANS-CONAME
                    ACCEPT EDBI-DATABASE-ANSI FROM ENVIRONMENT 
                           STRING-ANSIDB 
                 END-IF
              END-IF
           END-IF
           SET ENVIRONMENT "EDBI.ACTUAL.CONNECTION" TO ACT-CONAME
           IF IS-AUTOCOMMIT 
              MOVE "1" TO AUTOCOMMIT
           ELSE
              MOVE "0" TO AUTOCOMMIT
           END-IF
           GOBACK.

       GET-DATE-ENV.
           ACCEPT EDBI-MIN-DATE FROM ENVIRONMENT "easydb.min_date"
                  ON EXCEPTION
              ACCEPT EDBI-MIN-DATE FROM ENVIRONMENT "easydb_min_date"
                  ON EXCEPTION
                     EVALUATE EDBI-DATABASE-TYPE
                     WHEN "GEN"
                     WHEN "ORA"                     
                     WHEN "DB2"                     
                     WHEN "DB4"                     
                     WHEN "PGS"                     
                          MOVE "00010101" TO EDBI-MIN-DATE
                     WHEN "MYS"                     
                          MOVE "10010101" TO EDBI-MIN-DATE
                     WHEN "SRV"
                          MOVE "19000101" TO EDBI-MIN-DATE
                     WHEN "IFX"
                          MOVE "18991231" TO EDBI-MIN-DATE
                     END-EVALUATE
              END-ACCEPT
           END-ACCEPT
           ACCEPT EDBI-MAX-DATE FROM ENVIRONMENT "easydb.max_date"
                  ON EXCEPTION
              ACCEPT EDBI-MAX-DATE FROM ENVIRONMENT "easydb_max_date"
                  ON EXCEPTION
                     EVALUATE EDBI-DATABASE-TYPE
                     WHEN "GEN"
                     WHEN "ORA"
                     WHEN "SRV"
                     WHEN "MYS"                     
                     WHEN "DB2"                     
                     WHEN "DB4"                     
                     WHEN "PGS"                     
                     WHEN "IFX"                     
                          MOVE "99991231" TO EDBI-MAX-DATE
                     END-EVALUATE
              END-ACCEPT
           END-ACCEPT
           ACCEPT EDBI-INV-DATE FROM ENVIRONMENT "easydb.inv_date"
                  ON EXCEPTION                     
              ACCEPT EDBI-INV-DATE FROM ENVIRONMENT "easydb_inv_date"
                  ON EXCEPTION                     
                     EVALUATE EDBI-DATABASE-TYPE
                     WHEN "GEN"
                     WHEN "ORA"
                     WHEN "SRV"
                     WHEN "MYS"                     
                     WHEN "DB2"                     
                     WHEN "DB4"                     
                     WHEN "PGS"                     
                     WHEN "IFX"                     
                          MOVE "99991230" TO EDBI-INV-DATE
                     END-EVALUATE
              END-ACCEPT
           END-ACCEPT
           ACCEPT EDBI-JUL-DATE 
               FROM ENVIRONMENT "easydb.julian_base_date"
                  ON EXCEPTION                     
                     ACCEPT EDBI-JUL-DATE 
                      FROM ENVIRONMENT "easydb_julian_base_date"
                         ON EXCEPTION                     
                            EVALUATE EDBI-DATABASE-TYPE
                            WHEN "GEN"
                            WHEN "ORA"
                            WHEN "SRV"
                            WHEN "MYS"                     
                            WHEN "DB2"                     
                            WHEN "DB4"                     
                            WHEN "PGS"                     
                            WHEN "IFX"                     
                                 MOVE 0 TO DATE-JUL-START
                            END-EVALUATE
                         NOT ON EXCEPTION
                            IF EDBI-JUL-DATE > "16000101"
                        MOVE function INTEGER-OF-DATE(EDBI-JUL-DATE) TO
                             DATE-JUL-START
                               SUBTRACT 1 FROM DATE-JUL-START
                            END-IF
                     END-ACCEPT
               NOT ON EXCEPTION
                  IF EDBI-JUL-DATE > "16000101"
                     MOVE function INTEGER-OF-DATE(EDBI-JUL-DATE) TO
                          DATE-JUL-START
                     SUBTRACT 1 FROM DATE-JUL-START
                  END-IF
           END-ACCEPT
           ACCEPT EDBI-DATE-CUT FROM ENVIRONMENT "easydb.date_cutoff"
                  ON EXCEPTION
              ACCEPT EDBI-DATE-CUT FROM ENVIRONMENT "easydb_date_cutoff"
                  ON EXCEPTION
                     MOVE "20" TO EDBI-DATE-CUT
              END-ACCEPT
           END-ACCEPT.
       SET-CONNECTION-ENV.
           ADD 1 TO NUM-CONAME
           MOVE "N"                      TO NEW-RUNUNIT
           SET ENVIRONMENT STRING-CONAME TO "XXXXX"
           SET ENVIRONMENT STRING-CONUM  TO ACT-CONAME
           SET ENVIRONMENT "EDBI.NUM.CONNECTION"    TO NUM-CONAME
           ACCEPT EDBI-AUTOCOMMIT 
                  FROM ENVIRONMENT "jdbc.autocommit"
           IF EDBI-DATABASE-TYPE = "IFX"
              MOVE ACT-CONAME TO ANS-CONAME
              MOVE SQLWARN2   TO EDBI-DATABASE-ANSI
              SET ENVIRONMENT STRING-ANSIDB TO SQLWARN2
           END-IF.

